/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.OperadoraTelefonia;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCreditoDigital;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCreditoDigital;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MicCapturaOperadoraTelefoniaCreditoDigital {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR_AC = "ERROR_AC";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(Process dados) throws ExcecaoNaoLocal {
        DadosInicioDia dadosInicioDia;
        IdentTerminal identTerminal;
        ConfCTFClient config;
        EntradaApiTefC entradaApiTefC;
        InternacionalizacaoUtil inter;
        block18: {
            block19: {
                inter = InternacionalizacaoUtil.getInstance();
                entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
                if (entradaApiTefC.getCodigoAutorizadora() != null) {
                    return FILLED;
                }
                config = ControladorConfCTFClient.getInstance().getConfig();
                EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
                boolean multiEC = config.isMultiEC();
                identTerminal = null;
                identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
                ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
                dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
                if (Contexto.getContexto().getEntradaIntegracao() == null) break block18;
                if (!Contexto.getContexto().getEntradaIntegracao().isCodigoOperadoraTelefoniaCtrl()) break block19;
                if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                    entradaApiTefC.setCodigoAutorizadora(entradaIntegracao.getCodigoAutorizadora());
                    if (entradaIntegracao.getCodigoOperadoraTelefonia() != null) {
                        entradaApiTefC.setOperadora(entradaIntegracao.getCodigoOperadoraTelefonia());
                    }
                    return SUCESS;
                }
                String operadoraTelefoniaIntegracao = Contexto.getContexto().getEntradaIntegracao().getCodigoOperadoraTelefonia();
                if (!config.isIntegracaoWeb() && dadosInicioDia.isConsultaOperadorasCD()) {
                    if (operadoraTelefoniaIntegracao.length() <= 0) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERADORA_DE_TELEFONIA_INVALIDA, "OPERADORA DE TELEFONIA INVALIDA"));
                        return ERROR_AC;
                    }
                    entradaApiTefC.setCodigoAutorizadora(operadoraTelefoniaIntegracao);
                    break block18;
                } else {
                    OperadoraTelefonia operadora;
                    ConfCreditoDigital conf = null;
                    try {
                        conf = ControladorConfCreditoDigital.getInstance().getConfig();
                    }
                    catch (Exception e) {
                        logger.warn("N\u00e3o foi poss\u00edvel ler o configCreditoDigital.xml para a configura\u00e7\u00e3o das operadoras.");
                    }
                    if (conf == null) {
                        if (operadoraTelefoniaIntegracao != null) {
                            entradaApiTefC.setCodigoAutorizadora(operadoraTelefoniaIntegracao);
                            return SUCESS;
                        }
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERADORA_DE_TELEFONIA_INVALIDA, "OPERADORA DE TELEFONIA INVALIDA"));
                        return ERROR_AC;
                    }
                    Iterator<OperadoraTelefonia> ite = conf.getOperadorasTelefonia().iterator();
                    do {
                        if (!ite.hasNext()) {
                            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERADORA_DE_TELEFONIA_INVALIDA, "OPERADORA DE TELEFONIA INVALIDA"));
                            return ERROR_AC;
                        }
                        operadora = ite.next();
                    } while (operadoraTelefoniaIntegracao == null || !operadora.getAutorizadora().equals(operadoraTelefoniaIntegracao));
                    entradaApiTefC.setOperadora(operadora.getCodigo());
                    entradaApiTefC.setNomeOperadora(operadora.getNome());
                    entradaApiTefC.setCodigoAutorizadora(operadora.getAutorizadora());
                    return SUCESS;
                }
            }
            if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERADORA_DE_TELEFONIA_INVALIDA, "OPERADORA DE TELEFONIA INVALIDA"));
                return ERROR_AC;
            }
        }
        List<OperadoraTelefonia> listaOperadoras = null;
        if (!config.isIntegracaoWeb() && dadosInicioDia.isConsultaOperadorasCD()) {
            ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
            DadosPersistencia dadosPersistencia = controladorPersistencia.getDadosPersistencia(identTerminal);
            listaOperadoras = dadosPersistencia.getListaOperadorasRecarga().getDado();
        } else {
            ConfCreditoDigital conf = null;
            conf = ControladorConfCreditoDigital.getInstance().getConfig();
            listaOperadoras = new ArrayList<OperadoraTelefonia>(conf.getOperadorasTelefonia());
        }
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPOPETELCREDIG_TITLE), true);
        OperadoraTelefonia[] arrayOperadoraTecla = new OperadoraTelefonia[listaOperadoras.size()];
        int iTecla = 0;
        Iterator<OperadoraTelefonia> iter = listaOperadoras.iterator();
        while (iter.hasNext()) {
            OperadoraTelefonia operadora;
            arrayOperadoraTecla[iTecla] = operadora = iter.next();
            String nomeDisplayOperadora = "";
            if (operadora.getNome() != null) {
                nomeDisplayOperadora = operadora.getNome().length() > 26 ? operadora.getNome().substring(0, 26) : operadora.getNome();
            }
            layoutMenu.addItem(new ItemMenu(nomeDisplayOperadora, String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        entradaApiTefC.setOperadora(arrayOperadoraTecla[opcao - 1].getCodigo());
        entradaApiTefC.setNomeOperadora(arrayOperadoraTecla[opcao - 1].getNome());
        entradaApiTefC.setCodigoAutorizadora(arrayOperadoraTecla[opcao - 1].getAutorizadora());
        return SUCESS;
    }
}

