/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.model.Operadora;
import com.csi.ctfclient.apitef.model.OperadoraTelefonia;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Iterator;
import java.util.List;

public class MicCapturaOperadoraTelefonia {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaApiTefC.getCodigoAutorizadora() != null) {
            return FILLED;
        }
        DadosPersistencia dadosPersistencia = null;
        ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = null;
        boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
        boolean multiEC = config.isMultiEC();
        identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        dadosPersistencia = controladorPersistencia.getDadosPersistencia(identTerminal);
        List<Operadora> listOperadoras = dadosPersistencia.getListOperadorasTelefonia().getDado();
        if (listOperadoras == null || listOperadoras.isEmpty()) {
            logger.error("Erro ao capturar as operadoras telefonia pois a lista das operadoras n\u00e3o cont\u00e9m nenhuma operadora.");
            throw new IllegalArgumentException("Lista de operadoras nula");
        }
        if (listOperadoras.size() == 1) {
            entradaApiTefC.setCodigoAutorizadora(listOperadoras.get(0).getAutorizadora());
            if (listOperadoras.get(0) instanceof OperadoraTelefonia) {
                entradaApiTefC.setCapturaDigito(((OperadoraTelefonia)listOperadoras.get(0)).isDigito());
            }
            return SUCCESS;
        }
        Iterator<Operadora> ite = listOperadoras.iterator();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPOPETEL_TITLE), true);
        Operadora[] arrayOperadoraTecla = new Operadora[listOperadoras.size()];
        int iTecla = 0;
        while (ite.hasNext()) {
            Operadora ope;
            arrayOperadoraTecla[iTecla] = ope = ite.next();
            layoutMenu.addItem(new ItemMenu(ope.getNome(), String.valueOf(iTecla + 1)));
            ++iTecla;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int opcao = perifericos.imprimeMenu(layoutMenu);
        if (opcao == -1) {
            return USER_CANCEL;
        }
        entradaApiTefC.setCodigoAutorizadora(arrayOperadoraTecla[opcao - 1].getAutorizadora());
        Operadora operadora = arrayOperadoraTecla[opcao - 1];
        if (operadora instanceof OperadoraTelefonia) {
            entradaApiTefC.setCapturaDigito(((OperadoraTelefonia)operadora).isDigito());
        }
        return SUCCESS;
    }
}

