/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaNumeroPlanoPrivateLabel {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NUMERO_PLANO_INVALIDO = "NUMERO_INVALIDO";
    public static final String NUMERO_PLANO_INVALIDO_AC = "NUMERO_INVALIDO_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (null == saidaApiTefC || null == saidaApiTefC.getFlagPlano()) {
            return this.legacyFlow(dados);
        }
        return this.flagFlow(dados);
    }

    private String legacyFlow(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getNumPlano() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isNumeroPlanoCtrl()) {
            entradaApiTefC.setNumeroPlano(Contexto.getContexto().getEntradaIntegracao().getNumeroPlano());
            return SUCESS;
        }
        return this.getUserInput(entradaApiTefC, dados, ConstantesApiAc.CAP_NUMERO_PLANO);
    }

    private String flagFlow(Process dados) throws ExcecaoNaoLocal {
        ContextoCTFClient context = Contexto.getContexto();
        if (this.shouldCapture(context.getPlano(), context.getSaidaApiTefC().getFlagPlano().toUpperCase())) {
            if (null != context.getEntradaIntegracao().getNumeroPlano()) {
                context.getEntradaApiTefC().setNumPlano(context.getEntradaIntegracao().getNumeroPlano());
                return FILLED;
            }
            return this.getUserInput(context.getEntradaApiTefC(), dados, ConstantesApiAc.CAP_CODIGO_PLANO);
        }
        return NOT_REQUIRED;
    }

    private boolean shouldCapture(Plano operationType, String plan) {
        if (null != operationType && null != plan) {
            if (operationType.equals((Object)Plano.AVISTA)) {
                return plan.matches("1|5|6|7|B|C|D");
            }
            if (operationType.equals((Object)Plano.LOJISTA)) {
                return plan.matches("2|5|8|9|B|C|E");
            }
            if (operationType.equals((Object)Plano.ADMINISTRADORA)) {
                return plan.matches("3|6|8|A|B|D|E");
            }
        }
        return false;
    }

    private String getUserInput(EntradaApiTefC entradaApiTefC, Process dados, ConstantesApiAc.TipoCampo mask) throws ExcecaoNaoLocal {
        EventoTeclado input = dados.getPerifericos().getUserInput(dados, mask, MessageEnum.CAPNUMPLA_TITLE);
        if ("VOLTA".equals(input.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        if (input.getStringLida().length() < 2) {
            return NUMERO_PLANO_INVALIDO;
        }
        entradaApiTefC.setNumPlano(input.getStringLida());
        return SUCESS;
    }
}

