/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaNumeroParcelaPlanoPagamento {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String PARCELA_INVALIDA = "PARCELA_INVALIDA";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isNumeroParcelasCtrl()) {
            logger.info("Parcela informada AC: " + entradaIntegracao.getNumeroParcelas());
            entrada.setNumeroParcelas(entradaIntegracao.getNumeroParcelas());
            return SUCCESS;
        }
        if (entrada.getNumeroParcelas() > 0) {
            return FILLED;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPNUMPARPLAPAG_TITLE));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_PARCELAS, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numParcelas = eventoTeclado.getStringLida().substring(num);
        int parcelas = 0;
        try {
            parcelas = Integer.parseInt(numParcelas);
            logger.info("N\u00famero parcelas digitada: " + parcelas);
        }
        catch (NumberFormatException e) {
            if (this.exibeMensagem(inter.getMessage(MessageEnum.CAPNUMPAR_NR_PARC_INVALIDO), perifericos).equals("ENTRA")) {
                return PARCELA_INVALIDA;
            }
            return USER_CANCEL;
        }
        entrada.setNumeroParcelas(parcelas);
        return SUCCESS;
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

