/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaNumeroItem {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NUMERO_ITEM_INVALIDO = "NUMERO_INVALIDO";
    public static final String NUMERO_ITEM_INVALIDO_AC = "NUMERO_INVALIDO_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (null == saidaApiTefC || null == saidaApiTefC.getFlagItem()) {
            return this.legacyFlow(dados);
        }
        return this.flagFlow(dados);
    }

    private String legacyFlow(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (null != entradaApiTefC.getNumeroItem()) {
            return FILLED;
        }
        if (null != Contexto.getContexto().getEntradaIntegracao() && Contexto.getContexto().getEntradaIntegracao().isNumeroItemCtrl()) {
            entradaApiTefC.setNumeroItem(Contexto.getContexto().getEntradaIntegracao().getNumeroItem());
            return SUCESS;
        }
        return this.getUserInput(entradaApiTefC, dados, ConstantesApiAc.CAP_NUMERO_ITEM);
    }

    private String flagFlow(Process dados) throws ExcecaoNaoLocal {
        ContextoCTFClient context = Contexto.getContexto();
        if (!this.shouldCapture(context.getPlano(), context.getSaidaApiTefC().getFlagItem())) {
            return NOT_REQUIRED;
        }
        if (null != context.getEntradaIntegracao().getNumeroItem()) {
            context.getEntradaApiTefC().setNumItem(context.getEntradaIntegracao().getNumeroItem());
            return FILLED;
        }
        return this.getUserInput(context.getEntradaApiTefC(), dados, ConstantesApiAc.CAP_NUMERO_ITEM_RAMO);
    }

    private boolean shouldCapture(Plano operationType, String item) {
        if (null != operationType && null != item) {
            if (operationType.equals((Object)Plano.AVISTA)) {
                return item.matches("1|5|6|7|B|C|D");
            }
            if (operationType.equals((Object)Plano.LOJISTA)) {
                return item.matches("2|5|8|9|B|C|E");
            }
            if (operationType.equals((Object)Plano.ADMINISTRADORA)) {
                return item.matches("3|6|8|A|B|D|E");
            }
        }
        return false;
    }

    private String getUserInput(EntradaApiTefC entradaApiTefC, Process dados, ConstantesApiAc.TipoCampo mask) throws ExcecaoNaoLocal {
        EventoTeclado input = dados.getPerifericos().getUserInput(dados, mask, MessageEnum.CAPNUMITE_TITLE);
        if ("VOLTA".equals(input.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        entradaApiTefC.setNumeroItem(input.getStringLida());
        entradaApiTefC.setNumItem(input.getStringLida());
        return SUCESS;
    }
}

