/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaNumero {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    public static final String INVALID_NUMBER_AC = "INVALID_NUMBER_AC";
    private static final String MSG_INVALID_NUMBER = "NUMERO DO ENDERECO INVALIDO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getNumeroEndereco() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            if (Contexto.getContexto().getEntradaIntegracao().isNumeroCtrl()) {
                entradaApiTefC.setNumeroEndereco(Contexto.getContexto().getEntradaIntegracao().getNumero());
                return SUCESS;
            }
            if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_5399, MSG_INVALID_NUMBER));
                return INVALID_NUMBER_AC;
            }
        }
        String valor = null;
        int caracteresDigitados = 0;
        ControladorPerifericos periferico = dados.getPerifericos();
        while (caracteresDigitados == 0) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPNUM_TITLE));
            EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_NUMERO_ENDERECO);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
            caracteresDigitados = valor.length();
        }
        entradaApiTefC.setNumeroEndereco(valor);
        return SUCESS;
    }
}

