/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import org.apache.commons.lang3.StringUtils;

public class MicCapturaNsuTransacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_NSU = "INVALID_NSU";
    public static final String INVALID_NSU_AC = "INVALID_NSU_AC";
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    /*
     * Enabled aggressive block sorting
     */
    public String execute(Process dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        String nsuTransacao = "";
        if (Contexto.getContexto().getEntradaApiTefC().getNsuCtfTransacaoOriginal() > 0) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isNsuCTFCtrl()) {
            if (!MicCapturaNsuTransacao.isNsuValido(entradaIntegracao.getNsuCTF())) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.NSU_INVALIDO, inter.getMessage(MessageEnum.CAPNSUTRA_INVALID_NSU)));
                return INVALID_NSU_AC;
            }
            nsuTransacao = String.valueOf(entradaIntegracao.getNsuCTF());
        } else {
            EventoTeclado eventoTeclado;
            ControladorPerifericos perifericos = dado.getPerifericos();
            do {
                LayoutDisplay displayModel;
                if (!(eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPNSUTRA_TITLE)), ConstantesApiAc.CAP_NSU_CTF_CANCELAMENTO, true, 7, true, nsuTransacao)).getTeclaFinalizadora().equals("VOLTA")) continue;
                return USER_CANCEL;
            } while (!this.isNsuValido(nsuTransacao = StringUtil.retornaStringDigitada(eventoTeclado.getStringLida(), eventoTeclado.getNumCaracteresDigitados())));
        }
        this.logger.info("execute: Nsu Transacao: {}", nsuTransacao);
        Contexto.getContexto().getEntradaApiTefC().setNsuCtfTransacaoOriginal(Integer.parseInt(nsuTransacao));
        return SUCESS;
    }

    private boolean isNsuValido(String nsu) {
        return StringUtils.isNotBlank(nsu) && StringUtils.isNumeric(nsu) && nsu.length() == 6 && MicCapturaNsuTransacao.isNsuValido(Integer.parseInt(nsu));
    }

    private static boolean isNsuValido(int nsu) {
        return nsu > 0 && nsu <= 999999;
    }
}

