/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaNsuAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CODIGO = "INVALID_CODIGO";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(Process dado) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (!Contexto.getContexto().getSaidaApiTefC().isCapturaNsuAutorizacao()) {
            return UNECESSARY;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
            String nsuAutorizadora = Contexto.getContexto().getEntradaIntegracao().getCodigoAutorizacao();
            if (nsuAutorizadora != null && nsuAutorizadora.length() < 9) {
                nsuAutorizadora = StringUtil.completaString(nsuAutorizadora, 9, '0', 3);
            }
            Contexto.getContexto().getEntradaApiTefC().setNsuAutorizacao(nsuAutorizadora);
            return SUCESS;
        }
        if (Contexto.getContexto().getEntradaApiTefC().getCodigoAutorizacao() != null) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODAUT_TITLE)), ConstantesApiAc.CAP_NSU_AUTORIZADORA, true, 10, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String codigoAutorizacao = eventoTeclado.getStringLida().substring(num);
        if (codigoAutorizacao.equals("")) {
            if (this.exibeMensagem(perifericos, inter.getMessage(MessageEnum.CAPCODAUT_ERROR)).equals("ENTRA")) {
                return INVALID_CODIGO;
            }
            return USER_CANCEL;
        }
        Contexto.getContexto().getEntradaApiTefC().setNsuAutorizacao(codigoAutorizacao);
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

