/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.EMVResponseCode;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessGoOnChip;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.operacoes.model.PinInfo;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.model.controller.PinpadUtil;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;

public class MicCapturaMudancaSenha {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String ERROR_FALLBACK = "ERROR_FALLBACK";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) {
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (!saida.isCapturaDadosChip()) {
            return ERROR;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        RegistroCriptografia registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
        int modoCriptografia = registroCriptografia.getAlgoritmo();
        String workingKey = registroCriptografia.getWorkingKey();
        int indiceCriptografia = registroCriptografia.getIndiceMasterKey() == 42 ? 0 : registroCriptografia.getIndiceMasterKey();
        Criptografia criptografia = new Criptografia(modoCriptografia, indiceCriptografia, workingKey);
        BigDecimal valorTotal = Contexto.getContexto().getEntradaApiTefC().getValorTransacao();
        BigDecimal valorSaque = new BigDecimal(0);
        boolean possuiChaveContingencia = CriptografiaUtil.possuiChaveContingencia(registroCriptografia, tabelaCriptografia.getCriptografiaSenhaContingencia());
        possuiChaveContingencia = false;
        ProcessGoOnChip processGoOnChip = new ProcessGoOnChip(dados.getProcessConstructorArguments(), criptografia, valorTotal, valorSaque, possuiChaveContingencia);
        processGoOnChip.setActiveDialogUserCancel(false);
        ProcessManager manager = ProcessManager.getInstance();
        try {
            manager.subProcess(dados.getIdProcess(), processGoOnChip);
            PinInfo pinInfoSenhaAtual = Contexto.getContexto().getPinInfo();
            String retorno = this.trataRetornoGoOnChip(dados, processGoOnChip);
            if (!retorno.equals(SUCCESS)) {
                return retorno;
            }
            Contexto.getContexto().setTagsMandatorias(saida.getGoOnChipMandatoryTags());
            PinEMV pinEMV = dados.getPerifericos().getPinpad();
            pinEMV.setCapturaSenha(true);
            DadoSolicitaPin[] dadoSolicitaPin = new DadoSolicitaPin[]{new DadoSolicitaPin(4, 12, PinpadUtil.montaDisplayNovaSenha(), 0)};
            ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, dadoSolicitaPin, true, possuiChaveContingencia);
            processLeituraPin.setActiveDialogUserCancel(false);
            processLeituraPin.setTituloAguardaPin(inter.getMessage(MessageEnum.CAPMUDSEN_NOVA_SENHA));
            manager.subProcess(dados.getIdProcess(), processLeituraPin);
            String retornoNovaSenha = this.trataRetornoGetPin(dados, processLeituraPin);
            if (!retornoNovaSenha.equals(SUCCESS)) {
                return retornoNovaSenha;
            }
            PinInfo pinInfoNovaSenha = Contexto.getContexto().getPinInfo();
            pinEMV.setCapturaSenha(true);
            DadoSolicitaPin[] dadoSolicitaPinConfirmacao = new DadoSolicitaPin[]{new DadoSolicitaPin(4, 12, PinpadUtil.montaDisplayConfirmacaoNovaSenha(), 0)};
            ProcessLeituraPin processLeituraPinConfirmacao = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, dadoSolicitaPinConfirmacao, true, possuiChaveContingencia);
            processLeituraPinConfirmacao.setActiveDialogUserCancel(false);
            processLeituraPinConfirmacao.setTituloAguardaPin(inter.getMessage(MessageEnum.CAPMUDSEN_CONFIRMA_NOVA_SENHA));
            manager.subProcess(dados.getIdProcess(), processLeituraPinConfirmacao);
            String retornoCofirmacaoNovaSenha = this.trataRetornoGetPin(dados, processLeituraPinConfirmacao);
            if (!retornoCofirmacaoNovaSenha.equals(SUCCESS)) {
                return retornoCofirmacaoNovaSenha;
            }
            PinInfo pinInfoNovaSenhaConfirmacao = Contexto.getContexto().getPinInfo();
            if (pinInfoSenhaAtual != null) {
                EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
                entrada.setSenhaOfflineChip(pinInfoSenhaAtual.isVerificadoOffline());
                entrada.setAssinaturaChip(pinInfoSenhaAtual.isRequerAssinatura());
                entrada.setChipBloqueadoOffline(pinInfoSenhaAtual.isOfflineBloqueado());
                entrada.setDecisaoChip(pinInfoSenhaAtual.getDecisaoTomada());
                if (Contexto.getContexto().getCartao() != Cartao.CHIP && Contexto.getContexto().getCartao() != Cartao.CONTACTLESS_EMV || (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) && pinInfoSenhaAtual.isCapturadoVerificacaoOnline()) {
                    entrada.setSenha(pinInfoSenhaAtual.getPinCriptografado());
                    if (pinInfoSenhaAtual != null && pinInfoSenhaAtual.getNumeroSerieChaveDUKPT() != null) {
                        entrada.setNumeroSerieChaveSenha(pinInfoSenhaAtual.getNumeroSerieChaveDUKPT());
                    }
                    if (pinInfoNovaSenha != null) {
                        entrada.setNovaSenha(StringUtil.completaString(pinInfoNovaSenha.getNumeroSerieChaveDUKPT(), 16, '0', 3) + pinInfoNovaSenha.getPinCriptografado());
                    }
                    if (pinInfoNovaSenhaConfirmacao != null) {
                        entrada.setNovaSenhaConfirmacao(StringUtil.completaString(pinInfoNovaSenhaConfirmacao.getNumeroSerieChaveDUKPT(), 16, '0', 3) + pinInfoNovaSenhaConfirmacao.getPinCriptografado());
                    }
                }
                if (pinInfoSenhaAtual.getDadosCampo55() != null) {
                    entrada.setDadosChip(pinInfoSenhaAtual.getDadosCampo55());
                }
            }
        }
        catch (Exception e) {
            logger.error("Erro generico durante a captura da senha: " + e.getMessage());
            return ERROR;
        }
        return SUCCESS;
    }

    private String trataRetornoGoOnChip(Process dados, ProcessGoOnChip processGoOnChip) {
        ContextoCTFClient contexto = Contexto.getContexto();
        if (processGoOnChip.getState() == 3) {
            contexto.setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_PINPAD_CANCEL));
            return USER_CANCEL;
        }
        if (processGoOnChip.getState() == 1) {
            int errorCode = Contexto.getContexto().getErrorCode();
            if (errorCode == EMVResponseCode.PP_SAMERR.getId() || errorCode == EMVResponseCode.PP_DUMBCARD.getId() || errorCode == EMVResponseCode.PP_ERRCARD.getId() || errorCode == EMVResponseCode.PP_CARDAPPNAV.getId() || errorCode == EMVResponseCode.PPC_ERRFALBACK.getId()) {
                contexto.resetCartao();
                contexto.setSaidaApiTefC(null);
                contexto.getEntradaApiTefC().setRetornoBibliotecaCompartilhada(errorCode);
                return ERROR_FALLBACK;
            }
            return ERROR;
        }
        if (processGoOnChip.getState() == 5) {
            contexto.setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_PINPAD_CANCEL));
            return USER_CANCEL_INTERNAL;
        }
        return SUCCESS;
    }

    private String trataRetornoGetPin(Process dados, ProcessLeituraPin process) {
        if (process.getState() == 3) {
            Contexto.getContexto().setRemoveCardMessage(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.REMCAR_PINPAD_CANCEL));
            return USER_CANCEL;
        }
        if (process.getState() == 1) {
            if (Contexto.getContexto().getErrorCode() == EMVResponseCode.PP_ERRPIN.getId().intValue()) {
                return "RERUN";
            }
            return ERROR;
        }
        if (process.getState() == 5) {
            return USER_CANCEL;
        }
        return SUCCESS;
    }
}

