/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Vector;

public class MicCapturaFinanciamentoSaque {
    public static final String SAQUE_AVISTA = "SAQUE_AVISTA";
    public static final String SAQUE_PARCELADO = "SAQUE_PARCELADO";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERROR = "ERROR";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String SIMULACAO = "SIMULACAO";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        boolean habilitadoAVista = saidaApiTefC.isPedePlanoAVista();
        boolean habilitadoParcelado = saidaApiTefC.isPedePlanoAdministradora();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (Contexto.getContexto().getPlano() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getOperacao() == OperationEnum.OP_SAQUE_DEBITO.getKey().intValue()) {
                return UNECESSARY;
            }
            if (entradaIntegracao.getOperacao() == OperationEnum.OP_SIMULACAO_SAQUE_CREDITO.getKey().intValue() || entradaIntegracao.getOperacao() == OperationEnum.OP_SIMULACAO_SAQUE_TRANSFERENCIA_CREDITO.getKey().intValue()) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SIMULACAO;
            }
            if (!habilitadoParcelado && (!entradaIntegracao.isNumeroParcelasCtrl() || entradaIntegracao.isNumeroParcelasCtrl() && entradaIntegracao.getNumeroParcelas() <= 1)) {
                logger.info("plano parcelado n\u00e3o habilitado. selecionado plano a vista");
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SAQUE_AVISTA;
            }
        }
        if (entradaIntegracao != null && entradaIntegracao.isNumeroParcelasCtrl()) {
            logger.info("numero de parcelas informada pela ac = " + entradaIntegracao.getNumeroParcelas());
            if (entradaIntegracao.getNumeroParcelas() > 1) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SAQUE_PARCELADO;
            }
            Contexto.getContexto().setPlano(Plano.AVISTA);
            return SAQUE_AVISTA;
        }
        Vector<String> vtTitleMenu = new Vector<String>();
        if (habilitadoAVista) {
            vtTitleMenu.add(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_AVISTA));
        }
        if (habilitadoParcelado) {
            vtTitleMenu.add(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_PARCELADO));
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (vtTitleMenu.size() == 0) {
            Contexto.getContexto().setPlano(null);
            return ERROR;
        }
        if (vtTitleMenu.size() == 1) {
            if (habilitadoAVista) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SAQUE_AVISTA;
            }
            if (habilitadoParcelado) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SAQUE_PARCELADO;
            }
        } else {
            LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.LEITIPFINCRE_TITLE), true);
            int iTecla = 1;
            for (int i = 0; i < vtTitleMenu.size(); ++i) {
                layoutMenu.addItem(new ItemMenu((String)vtTitleMenu.get(i), String.valueOf(iTecla)));
                ++iTecla;
            }
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USERCANCEL;
            }
            ItemMenu itemSelecionado = layoutMenu.getItens().get(opcao - 1);
            if (itemSelecionado.getTexto().equals(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_AVISTA))) {
                Contexto.getContexto().setPlano(Plano.AVISTA);
                return SAQUE_AVISTA;
            }
            if (itemSelecionado.getTexto().equals(inter.getMessage(MessageEnum.LEITIPFINCRE_MENU_PARCELADO))) {
                Contexto.getContexto().setPlano(Plano.ADMINISTRADORA);
                return SAQUE_PARCELADO;
            }
        }
        return ERROR;
    }
}

