/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.EMVDadosPin;
import br.com.auttar.model.constants.EMVResponseCode;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraPin;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.ControladorModeloPinPad;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import org.apache.commons.lang3.StringUtils;

public class MicCapturaDadosPinpad
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String CAPTURA_NAO_CONFIRMADA = "CAPTURA_NAO_CONFIRMADA";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String MSG_CONFIRMA_PINPAD = "CONFIRMA?";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        PinEMV pinEMV;
        try {
            pinEMV = dados.getPerifericos().getPinpad();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.error("Nao foi possivel carregar o pin: " + excecaoPerifericos.getMessage());
            return ERROR;
        }
        try {
            String capturaDado = this.capturaDadoPinpad(dados, pinEMV);
            if (this.confirmaDado(dados, pinEMV, capturaDado)) {
                Contexto.getContexto().getSaidaApiTefC().setRetorno(0);
                Contexto.getContexto().setCapturaDadoPinpad(capturaDado);
                return SUCCESS;
            }
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.USUARIO_NAO_CONFIRMOU, "USUARIO NAO CONFIRMOU#O CPF"));
            dados.setActiveDialogUserCancel(false);
            return CAPTURA_NAO_CONFIRMADA;
        }
        catch (UserCancelException | UserCancelInternalException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            dados.setActiveDialogUserCancel(false);
            return USER_CANCEL;
        }
        catch (ReadErrorException e) {
            Contexto.getContexto().getSaidaApiTefC().setRetorno(20);
            return ERROR;
        }
    }

    private String capturaDadoPinpad(Process dados, PinEMV pin) throws ReadErrorException, UserCancelException, UserCancelInternalException {
        int modoCriptografia = 0;
        int indiceMkAuttar = 0;
        String wkAuttar = "10BDA8B87A9E8357";
        Criptografia criptografia = new Criptografia(modoCriptografia, indiceMkAuttar, wkAuttar, true);
        pin.setCapturaSenha(true);
        DadoSolicitaPin dadoSolicitaPin = this.returnDadoSolicitacaoPinpad();
        DadoSolicitaPin[] dadoSolicitaPins = new DadoSolicitaPin[]{dadoSolicitaPin};
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, dadoSolicitaPins, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(dadoSolicitaPin.getMensagemSolicitacao());
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
        }
        catch (Exception e) {
            throw new ReadErrorException();
        }
        if (processLeituraPin.getState() == 3) {
            throw new UserCancelException();
        }
        if (processLeituraPin.getState() == 5) {
            throw new UserCancelInternalException();
        }
        if (processLeituraPin.getState() == 1) {
            throw new ReadErrorException();
        }
        BibliotecaPinpad libPinpad = (BibliotecaPinpad)pin;
        String capturaDado = libPinpad.isPinpadAbecs() && !libPinpad.isCapturaSenha() ? Contexto.getContexto().getPinInfo().getPinCriptografado() : this.decriptografaSenhaCTF(Contexto.getContexto().getPinInfo().getPinCriptografado(), criptografia);
        return capturaDado;
    }

    private DadoSolicitaPin returnDadoSolicitacaoPinpad() {
        int indMensagem = Contexto.getContexto().getEntradaIntegracao().getTipoCapturaDadosPinpad();
        this.logger.debug("returnDadoSolicitacaoPinpad: " + indMensagem);
        EMVDadosPin emvDadosPin = EMVDadosPin.getEnumByKey(indMensagem);
        this.logger.debug("returnDadoSolicitacaoPinpad: " + (Object)((Object)emvDadosPin));
        if (emvDadosPin.equals((Object)EMVDadosPin.IND_NON_EXIST)) {
            return new DadoSolicitaPin(EMVDadosPin.IND_DIGITE_CPF.getTamMim(), EMVDadosPin.IND_DIGITE_CPF.getTamMax(), EMVDadosPin.IND_DIGITE_CPF.getMsgDisplay(), EMVDadosPin.IND_DIGITE_CPF.getId());
        }
        return new DadoSolicitaPin(emvDadosPin.getTamMim(), emvDadosPin.getTamMax(), emvDadosPin.getMsgDisplay(), emvDadosPin.getId());
    }

    private String decriptografaSenhaCTF(String senhaCryptoPP, Criptografia criptografia) {
        byte[] senhaPPBytes = Ansi98Crypto.chaveStrHex2Bin(senhaCryptoPP);
        byte[] wkAuttarBytes = Ansi98Crypto.chaveStrHex2Bin(criptografia.getWorkingKey());
        byte[] chaveBytes = Ansi98Crypto.chaveStrHex2Bin("3132333435363738");
        String senhaDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes = Des.decrypt(chaveBytes, wkAuttarBytes), senhaPPBytes), 8);
        if (StringUtils.isNotBlank(senhaDecriptografada)) {
            int tamanho = Integer.decode("0x" + senhaDecriptografada.substring(0, 2));
            senhaDecriptografada = senhaDecriptografada.substring(2, 2 + tamanho);
        }
        return senhaDecriptografada;
    }

    private boolean confirmaDado(Process dados, PinEMV pin, String dado) {
        Criptografia criptografia = null;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        try {
            criptografia = ControladorModeloPinPad.getInstance().getCriptografia(pin);
        }
        catch (Exception e) {
            this.logger.warn("Erro ao tentar definir o tipo de criptografia na confirmacao de dado do pinpad: " + e.getMessage());
        }
        String mensagemPin = StringUtil.completaString(dado, 16, ' ', 4) + MSG_CONFIRMA_PINPAD;
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraPin processLeituraPin = new ProcessLeituraPin(dados.getProcessConstructorArguments(), criptografia, null, false, false);
        processLeituraPin.setActiveDialogUserCancel(false);
        processLeituraPin.setTituloAguardaPin(inter.getMessage(MessageEnum.EXICONTEL_MSG_CONFIRMACAO));
        processLeituraPin.setTipoLeituraPin(3);
        try {
            dados.getPerifericos().getPinpad().setMsgDisplay(mensagemPin);
            processManager.subProcess(dados.getIdProcess(), processLeituraPin);
            if (processLeituraPin.getState() == 3 || processLeituraPin.getState() == 5) {
                this.logger.info("confirmacao cancelada pelo usuario.");
                return false;
            }
            if (processLeituraPin.getState() == 1) {
                this.logger.error("erro na confirmacao do dado capturado.");
                return false;
            }
            if (processLeituraPin.getTeclaFuncaoPressionada() != EMVResponseCode.PP_OK.getId().intValue()) {
                this.logger.info("usuario nao confirmou o dado capturado.");
                return false;
            }
        }
        catch (Exception e) {
            this.logger.error("erro na confirmacao do dado capturado : " + e.getMessage());
            return false;
        }
        return true;
    }

    private static class ReadErrorException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ReadErrorException() {
        }
    }

    private static class UserCancelInternalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelInternalException() {
        }
    }

    private static class UserCancelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private UserCancelException() {
        }
    }
}

