/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.math.BigDecimal;

public class MicCapturaCompraSaque {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String INVALID_NUMBER = "INVALID_NUMBER";
    private static final String MSG_DADOS_INVALIDOS = "DADOS INVALIDOS";

    /*
     * Enabled aggressive block sorting
     */
    public String execute(Process dado) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (entradaApiTefC.getValorCashBack() != null) {
            return FILLED;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isValorSaqueCtrl()) {
            if (saidaApiTefC.isCompraSaque()) {
                if (this.isValidaValorSaque(Contexto.getContexto().getEntradaIntegracao().getValorSaque())) {
                    Contexto.getContexto().getEntradaApiTefC().setValorCashBack(Contexto.getContexto().getEntradaIntegracao().getValorSaque());
                    return SUCESS;
                }
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.DADOS_INVALIDOS, MSG_DADOS_INVALIDOS));
                return ERROR_AC;
            }
            if (Contexto.getContexto().getEntradaIntegracao().getValorSaque().longValue() > 0L) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.DADOS_INVALIDOS, MSG_DADOS_INVALIDOS));
                return ERROR_AC;
            }
            Contexto.getContexto().getEntradaApiTefC().setValorCashBack(new BigDecimal(0));
            return SUCESS;
        }
        if (!saidaApiTefC.isCompraSaque()) return SUCESS;
        String issuer = saidaApiTefC.getNomeIssuer();
        if (issuer == null || issuer.length() == 0) {
            issuer = saidaApiTefC.getLogomarca();
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(issuer));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.CAPCOMSAQ_TITLE)));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_VALOR_SAQUE, false, 8, false);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String digitos = eventoTeclado.getStringLida().substring(num);
        if (digitos.equals("")) {
            digitos = "000";
        }
        BigDecimal valor = new BigDecimal(digitos);
        if (!this.isValidaValorSaque(valor = valor.movePointLeft(2))) {
            if (!this.exibeMensagem(inter.getMessage(MessageEnum.VALVALCAN_INVALID_VALUE), perifericos).equals("ENTRA")) return USERCANCEL;
            return INVALID_NUMBER;
        }
        if (!(valor.doubleValue() > 0.0)) return SUCESS;
        Contexto.getContexto().getEntradaApiTefC().setValorCashBack(valor);
        return SUCESS;
    }

    private boolean isValidaValorSaque(BigDecimal valorSaque) {
        BigDecimal valorMaxSaque = Contexto.getContexto().getSaidaApiTefC().getValorMaxSaque();
        if (valorMaxSaque != null && valorMaxSaque.doubleValue() > 0.0) {
            return valorSaque.compareTo(valorMaxSaque) != 1;
        }
        return true;
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

