/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.CodigoCvv;
import br.com.auttar.model.CodingCvvBuilder;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import org.apache.commons.lang3.ArrayUtils;

public class MicCapturaCodigoSeguranca {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_MOTIVO = "USERCANCEL_MOTIVO";
    public static final String INVALID_LENGTH = "INVALID_LENGTH";
    public static final String INVALID_LENGTH_AC = "INVALID_LENGTH_AC";
    public static final String ERRO_IS_REQUIRED = "ERRO_IS_REQUIRED";
    private static final String MSG_INVALID_COD_SEGURANCA = "COD. SEGURANCA INVALIDO";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida.isPedeCVV2()) {
            EventoTeclado eventoTeclado;
            if (Contexto.getContexto().getEntradaApiTefC().getCvv2() != null) {
                return FILLED;
            }
            int tamanhoMinimo = 3;
            int tamanhoMaximo = 5;
            if (saida.getTamanhoMinimoCodigoSeguranca() > 0 && saida.getTamanhoMaximoCodigoSeguranca() > 0) {
                tamanhoMinimo = saida.getTamanhoMinimoCodigoSeguranca();
                tamanhoMaximo = saida.getTamanhoMaximoCodigoSeguranca();
            }
            if (Contexto.getContexto().getEntradaIntegracao() != null) {
                if (Contexto.getContexto().getEntradaIntegracao().isCodigoSeguracaCtrl()) {
                    String codSeguranca = Contexto.getContexto().getEntradaIntegracao().getCodigoSeguraca();
                    if (codSeguranca.length() < tamanhoMinimo || codSeguranca.length() > tamanhoMaximo) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.COD_SEGURANCA_INVALIDO, MSG_INVALID_COD_SEGURANCA));
                        return INVALID_LENGTH_AC;
                    }
                    if (codSeguranca.trim().length() == 0) {
                        this.insertCodingCVV(CodingCvvBuilder.buildNonExistant());
                        return SUCESS;
                    }
                    this.insertCodingCVV(CodingCvvBuilder.buildPresent(codSeguranca));
                    return SUCESS;
                }
                if (Contexto.getContexto().getEntradaIntegracao().isMultiTerminal()) {
                    if (saida.isObrigatorioCVV2()) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.COD_SEGURANCA_INVALIDO, MSG_INVALID_COD_SEGURANCA));
                        return INVALID_LENGTH_AC;
                    }
                    this.insertCodingCVV(CodingCvvBuilder.buildIlegible());
                    return SUCESS;
                }
            }
            ControladorPerifericos periferico = dados.getPerifericos();
            String codigoSeguranca = "";
            do {
                LayoutDisplay displayModel;
                if (!(eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CVV_CODIGO_SEGURANCA)), ConstantesApiAc.CAP_CVV2, codigoSeguranca)).getTeclaFinalizadora().equals("VOLTA")) continue;
                return USERCANCEL;
            } while ((codigoSeguranca = StringUtil.retornaStringDigitada(eventoTeclado.getStringLida(), eventoTeclado.getNumCaracteresDigitados())).length() == 0 && saida.isObrigatorioCVV2() || codigoSeguranca.length() < tamanhoMinimo && codigoSeguranca.length() >= 1);
            if (codigoSeguranca.length() >= tamanhoMinimo && codigoSeguranca.length() <= tamanhoMaximo) {
                this.insertCodingCVV(CodingCvvBuilder.buildPresent(codigoSeguranca));
            } else if ("".equals(codigoSeguranca)) {
                LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CVV_TITLE_MOTIVO), true);
                layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.CVV_ITEM_MOTIVO1), "0"));
                layoutMenu.addItem(new ItemMenu(inter.getMessage(MessageEnum.CVV_ITEM_MOTIVO2), "1"));
                eventoTeclado = periferico.imprimeMenu(layoutMenu, ArrayUtils.EMPTY_STRING_ARRAY, null);
                if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                    this.insertCodingCVV(null);
                    return USERCANCEL_MOTIVO;
                }
                switch (eventoTeclado.getTeclaFinalizadora()) {
                    case "0": {
                        this.insertCodingCVV(CodingCvvBuilder.buildIlegible());
                        break;
                    }
                    case "1": {
                        this.insertCodingCVV(CodingCvvBuilder.buildNonExistant());
                    }
                }
            } else {
                this.exibeMensagem(dados.getPerifericos(), inter.getMessage(MessageEnum.CVV_INVALID_LENGTH));
                return INVALID_LENGTH;
            }
        }
        return SUCESS;
    }

    private void insertCodingCVV(CodigoCvv codigoCvv) {
        Contexto.getContexto().getEntradaApiTefC().setCvv2(codigoCvv);
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        perifericos.confirmaDado(displayModel);
    }
}

