/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import org.apache.commons.lang3.StringUtils;

public class MicCapturaCodigoPreAutorizacao {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CODIGO = "INVALID_CODIGO";
    public static final String UNECESSARY = "UNECESSARY";
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(MicCapturaCodigoPreAutorizacao.class);

    public String execute(Process dado) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (!this.isCapturaPreAutorizacao(saidaApiTefC)) {
            return UNECESSARY;
        }
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCodigoAutorizacao() != null) {
            return FILLED;
        }
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isInfoAdicionaisCtrl()) {
            entradaApiTefC.setCodigoAutorizacao(Contexto.getContexto().getEntradaIntegracao().getInfoAdicionais());
            return SUCESS;
        }
        if (conf.isIntegracaoWeb()) {
            logger.warn("Integra\u00e7\u00e3o Web e c\u00f3digo de pr\u00e9-autoriza\u00e7\u00e3o n\u00e3o preenchido");
            return SUCESS;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dado.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODPREAUT_TITLE)), ConstantesApiAc.CAP_CODIGO_PRE_AUTORIZACAO, true, 7, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String codigoAutorizacao = eventoTeclado.getStringLida().substring(num);
        if (codigoAutorizacao.equals("")) {
            if (this.exibeMensagem(perifericos, inter.getMessage(MessageEnum.CAPCODPREAUT_ERROR)).equals("ENTRA")) {
                return INVALID_CODIGO;
            }
            return USER_CANCEL;
        }
        entradaApiTefC.setCodigoAutorizacao(codigoAutorizacao);
        return SUCESS;
    }

    private String exibeMensagem(ControladorPerifericos perifericos, String msg) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }

    protected boolean isCapturaPreAutorizacao(SaidaApiTefC saidaApiTefC) {
        if (saidaApiTefC != null) {
            if (OperationEnum.OP_CONFIRMACAO_PRE_AUT.getDescription().equals(Contexto.getContexto().getTipoOperacao())) {
                return StringUtils.isBlank(saidaApiTefC.getFlagCodAutDig()) && StringUtils.isBlank(saidaApiTefC.getFlagCodAutMag()) || this.isCaptura(saidaApiTefC);
            }
            return this.isCapturaPreAutorizacaoOperacaoCreditoDigitado(saidaApiTefC);
        }
        return false;
    }

    private boolean isCapturaPreAutorizacaoOperacaoCreditoDigitado(SaidaApiTefC saidaApiTefC) {
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            if (StringUtils.isBlank(saidaApiTefC.getFlagCodAutDig()) && StringUtils.isBlank(saidaApiTefC.getFlagCodAutMag())) {
                return false;
            }
            return this.isCaptura(saidaApiTefC);
        }
        return false;
    }

    private boolean isCaptura(SaidaApiTefC saidaApiTefC) {
        return !"0".equals(saidaApiTefC.getFlagCodAutDig()) || !"0".equals(saidaApiTefC.getFlagCodAutMag());
    }
}

