/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaCodigoPlano {
    public static final String SUCCESS = "SUCCESS";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String FILLED = "FILLED";
    public static final String UNECESSARY = "UNECESSARY";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        if (Contexto.getContexto().getSaidaApiTefC() == null || !Contexto.getContexto().getSaidaApiTefC().isCapturaCodigoPlano()) {
            return UNECESSARY;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCodigoPlano() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isNumeroPlanoCtrl()) {
            entradaApiTefC.setCodigoPlano(Contexto.getContexto().getEntradaIntegracao().getNumeroPlano());
            return SUCCESS;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPNUMPLA_TITLE));
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_CODIGO_PLANO, true, 14, true);
        if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
            return USERCANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        String numPlano = eventoTeclado.getStringLida().substring(num);
        entradaApiTefC.setCodigoPlano(numPlano);
        return SUCCESS;
    }
}

