/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.InputCodigoBarrasConfig;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.FormatoCodigoBarrasEnum;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaCodigoBarras
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String FILLED = "FILLED";
    public static final String ERROR_AC = "ERROR_AC";

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCodigoBarras() != null) {
            return FILLED;
        }
        if (entradaIntegracao != null && entradaIntegracao.isCodigoBarrasCtrl() && entradaIntegracao.isModoEntradaCodigoBarrasCtrl()) {
            FormatoCodigoBarrasEnum modoEntraCbEnum = FormatoCodigoBarrasEnum.getObterEnumPorChave(entradaIntegracao.getModoEntradaCodigoBarras());
            if (modoEntraCbEnum.equals((Object)FormatoCodigoBarrasEnum.INEXISTENTE)) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.MODO_DE_ENTRADA_INVALIDO, "MODO DE ENTRADA INVALIDO"));
                return ERROR_AC;
            }
            entradaApiTefC.setCodigoBarras(entradaIntegracao.getCodigoBarras());
            entradaApiTefC.setFormatoCodigoBarrasEnum(modoEntraCbEnum);
            return SUCESS;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        int numeroBloco = Contexto.getContexto().getNumeroBloco();
        Scanner scanner = null;
        if (numeroBloco == 1) {
            scanner = this.tryEnableScanner();
        }
        LeitorDocumento leitorDocumento = this.tryEnableDocumentReader();
        String digitos = null;
        boolean continuaCaptura = true;
        while (continuaCaptura) {
            InputCodigoBarrasConfig inputCodigoBarrasConfig = this.montaInputTextSetup(inter, confCTFClient, numeroBloco, Contexto.getContexto().getTipoConta());
            LayoutDisplay displayModel = inputCodigoBarrasConfig.getDisplayModel();
            ConstantesApiAc.TipoCampo mascaraEdicao = inputCodigoBarrasConfig.getMascaraEdicao();
            int tamanhoMinimoExigido = inputCodigoBarrasConfig.getTamanhoMinimoExigido();
            PerifericoEventHandler.setActive(true);
            EventoDispositivoEntrada evento = perifericos.capturaDado(displayModel, mascaraEdicao, true, "", new long[]{1L, 2L, 16L});
            if (evento instanceof EventoTeclado) {
                EventoTeclado eventoTeclado = (EventoTeclado)evento;
                if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                    this.tryDisablePeripheral(scanner);
                    this.tryDisablePeripheral(leitorDocumento);
                    return USER_CANCEL;
                }
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                digitos = eventoTeclado.getStringLida().substring(num);
                if (tamanhoMinimoExigido != 0 && digitos.length() < tamanhoMinimoExigido || digitos.length() <= 0) continue;
                continuaCaptura = false;
                entradaApiTefC.setFormatoCodigoBarrasEnum(FormatoCodigoBarrasEnum.CNAB_DIGITADO);
                continue;
            }
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                digitos = eventoScanner.getRepresentacaoString();
                continuaCaptura = false;
                entradaApiTefC.setFormatoCodigoBarrasEnum(FormatoCodigoBarrasEnum.CNAB_LIDO);
                continue;
            }
            if (evento instanceof EventoLeitorDocumento) {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                digitos = eventoLeitorDocumento.getCodigo();
                continuaCaptura = false;
                entradaApiTefC.setFormatoCodigoBarrasEnum(FormatoCodigoBarrasEnum.CNAB_LIDO);
                continue;
            }
            throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
        }
        this.tryDisablePeripheral(scanner);
        this.tryDisablePeripheral(leitorDocumento);
        PerifericoEventHandler.setActive(false);
        if (entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_LIDO)) {
            entradaApiTefC.setCodigoBarras(digitos);
        } else if (entradaApiTefC.getFormatoCodigoBarrasEnum().equals((Object)FormatoCodigoBarrasEnum.CNAB_DIGITADO)) {
            entradaApiTefC.setLinhaDigitavel(digitos);
        }
        return SUCESS;
    }

    InputCodigoBarrasConfig montaInputTextSetup(InternacionalizacaoUtil inter, ControladorConfCTFClient confCTFClient, int numeroBloco, int tipoConta) {
        InputCodigoBarrasConfig inputCodigoBarrasConfig = new InputCodigoBarrasConfig();
        if (tipoConta == 1) {
            switch (numeroBloco) {
                case 1: {
                    inputCodigoBarrasConfig.setDisplayModel(new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODBAR_TITLE) + numeroBloco));
                    inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL1);
                    inputCodigoBarrasConfig.setTamanhoMinimoExigido(10);
                    break;
                }
                case 2: {
                    inputCodigoBarrasConfig.setDisplayModel(new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODBAR_TITLE) + numeroBloco));
                    inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL2);
                    inputCodigoBarrasConfig.setTamanhoMinimoExigido(11);
                    break;
                }
                case 3: {
                    inputCodigoBarrasConfig.setDisplayModel(new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODBAR_TITLE) + numeroBloco));
                    inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL3);
                    inputCodigoBarrasConfig.setTamanhoMinimoExigido(11);
                    break;
                }
                case 4: {
                    inputCodigoBarrasConfig.setDisplayModel(new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODBAR_TITLE) + numeroBloco));
                    inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL4);
                    inputCodigoBarrasConfig.setTamanhoMinimoExigido(1);
                    break;
                }
                case 5: {
                    inputCodigoBarrasConfig.setDisplayModel(new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODBAR_TITLE) + numeroBloco));
                    inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL5);
                }
            }
        } else {
            inputCodigoBarrasConfig.setDisplayModel(new LayoutDisplay(inter.getMessage(MessageEnum.CAPCODBAR_TITLE) + numeroBloco));
            if (confCTFClient.getConfig().isCapturaApenasLinhaDigitavel() && numeroBloco == 1) {
                inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS);
                inputCodigoBarrasConfig.setTamanhoMinimoExigido(10);
            } else {
                switch (numeroBloco) {
                    case 1: {
                        inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL1);
                        break;
                    }
                    case 2: {
                        inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL2);
                        break;
                    }
                    case 3: {
                        inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL3);
                        break;
                    }
                    case 4: {
                        inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL4);
                        break;
                    }
                    default: {
                        inputCodigoBarrasConfig.setMascaraEdicao(ConstantesApiAc.CAP_CODIGO_BARRAS);
                    }
                }
                if (numeroBloco > 1) {
                    inputCodigoBarrasConfig.setTamanhoMinimoExigido(12);
                }
            }
        }
        return inputCodigoBarrasConfig;
    }
}

