/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.CnpjUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaCnpj {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_CNPJ = "INVALID_CNPJ";
    public static final String INVALID_CNPJ_AC = "INVALID_CNPJ_AC";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (entradaApiTefC.getCnpj() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isDocumentoCtrl() && Contexto.getContexto().getEntradaIntegracao().isTipoDocumentoCtrl() && Contexto.getContexto().getEntradaIntegracao().getTipoDocumento() == 1) {
            String cnpj = Contexto.getContexto().getEntradaIntegracao().getDocumento();
            if (CnpjUtil.validaCnpj(cnpj)) {
                entradaApiTefC.setCnpj(cnpj);
                return SUCESS;
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_5318, inter.getMessage(MessageEnum.CAPCNP_INVALID_CNPJ)));
            return INVALID_CNPJ_AC;
        }
        ControladorPerifericos periferico = dados.getPerifericos();
        String valor = null;
        int caracteresDigitados = 0;
        while (caracteresDigitados != 14) {
            displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPCNP_TITLE));
            eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, ConstantesApiAc.CAP_CNPJ);
            if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
                return USER_CANCEL;
            }
            caracteresDigitados = eventoTeclado.getNumCaracteresDigitados();
            int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
            valor = eventoTeclado.getStringLida().substring(num);
        }
        if (CnpjUtil.validaCnpj(valor)) {
            entradaApiTefC.setCnpj(valor);
            return SUCESS;
        }
        displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPCNP_INVALID_CNPJ));
        eventoTeclado = (EventoTeclado)periferico.confirmaDado(displayModel);
        if (eventoTeclado.getTeclaFinalizadora().equals("ENTRA")) {
            return INVALID_CNPJ;
        }
        return USER_CANCEL;
    }
}

