/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaCmc7
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String UNNECESSARY = "UNNECESSARY";
    public static final String FILLED = "FILLED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private Scanner scanner;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean capturaCmc7 = ControladorConfCTFClient.getInstance().getConfig().isCapturaCmc7();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (!capturaCmc7) {
            return UNNECESSARY;
        }
        if (entradaApiTefC.getCmc7() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isCmc7Ctrl()) {
            entradaApiTefC.setCmc7(Contexto.getContexto().getEntradaIntegracao().getCmc7());
            return SUCESS;
        }
        ControladorPerifericos perifericos = dados.getPerifericos();
        try {
            this.scanner = perifericos.getScanner();
            if (this.scanner != null) {
                this.scanner.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info("Scanner n\u00e3o conectado");
        }
        LeitorDocumento leitorDocumento = this.tryGetDocumentReader();
        try {
            if (leitorDocumento != null) {
                leitorDocumento.habilita();
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.info("Leitor de documentos n\u00e3o conectado");
        }
        String digitos = "";
        while (digitos.trim().length() != 30 && digitos.trim().length() != 34) {
            LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPCMC7_TITLE));
            long[] entradaDados = new long[]{1L, 16L, 2L};
            PerifericoEventHandler.setActive(true);
            EventoDispositivoEntrada evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_CMC7, true, digitos, entradaDados);
            if (evento instanceof EventoTeclado) {
                EventoTeclado eventoTeclado = (EventoTeclado)evento;
                if ("VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) {
                    return USER_CANCEL;
                }
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                digitos = eventoTeclado.getStringLida().substring(num);
                continue;
            }
            if (evento instanceof EventoLeitorDocumento) {
                EventoLeitorDocumento eventoLeitorDocumento = (EventoLeitorDocumento)evento;
                digitos = eventoLeitorDocumento.getCodigo();
                this.logger.debug("Documento lido pelo leitor de documentos");
                continue;
            }
            if (evento instanceof EventoScanner) {
                EventoScanner eventoScanner = (EventoScanner)evento;
                digitos = eventoScanner.getRepresentacaoString();
                continue;
            }
            throw new IllegalArgumentException("Tipo de evento n\u00e3o esperado");
        }
        entradaApiTefC.setCmc7(digitos);
        return SUCESS;
    }
}

