/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.BombaFusion;
import com.csi.ctfclient.apitef.model.ProdutoConvenioCombustivel;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.fusion.ControladorFusion;
import com.csi.ctfclient.tools.devices.fusion.DadosPistaFusion;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.List;

public class MicCapturaBombaCombustivel {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        if (Contexto.getContexto().isConvenioCombustivelPosAutorizado()) {
            return UNECESSARY;
        }
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.ENVIO1F_TITLE));
        dados.getPerifericos().imprimeDisplay(displayModel);
        ControladorFusion fusion = ControladorFusion.getInstancia();
        LayoutMenu layoutMenu = new LayoutMenu(inter.getMessage(MessageEnum.CAPBOMCOM_TITLE), true);
        DadosPistaFusion pistaFusion = null;
        try {
            ProdutoConvenioCombustivel produto = Contexto.getContexto().getEntradaApiTefC().getListProdutoConvenioCombustivel().get(0);
            pistaFusion = fusion.infoPista(produto.getCodigo());
        }
        catch (Exception e) {
            logger.warn("Erro ao tentar interpretar produtos de convenio combustivel: " + e.getMessage());
        }
        if (pistaFusion == null || pistaFusion.getResultado() != 0) {
            if (pistaFusion != null) {
                logger.error("Erro ao ler os produtos dispon\u00edveis para abastecimento, c\u00f3digo: " + pistaFusion.getResultado());
            }
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_CONEXAO_FUSION, "ERRO CONEXAO FUSION"));
            return ERROR;
        }
        List<BombaFusion> bombas = pistaFusion.getBombas();
        for (int i = 0; i < bombas.size(); ++i) {
            BombaFusion bomba = bombas.get(i);
            layoutMenu.addItem(new ItemMenu("BOMBA " + bomba.getId(), i + 1 + ""));
        }
        boolean continuaCaptura = true;
        while (continuaCaptura) {
            int opcao = perifericos.imprimeMenu(layoutMenu);
            if (opcao == -1) {
                return USER_CANCEL;
            }
            LayoutDisplay displayConfirmaProduto = new LayoutDisplay(2);
            displayConfirmaProduto.addLinha(new Linha("BOMBA " + bombas.get(opcao - 1).getId() + " SELECIONADA"));
            displayConfirmaProduto.addLinha(new Linha("CONFIRMA?"));
            EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayConfirmaProduto);
            continuaCaptura = !eventoTeclado.getTeclaFinalizadora().equals("ENTRA");
            Contexto.getContexto().getEntradaApiTefC().setBombaCombustivel(bombas.get(opcao - 1));
        }
        return SUCCESS;
    }
}

