/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public class MicCapturaBeneficiarioRazaoSocial {
    public static final String SUCCESS = "SUCCESS";
    public static final String FILLED = "FILLED";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String USER_CANCEL = "USER_CANCEL";

    public String execute(Process dados) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (entrada.getBeneficiarioRazaoSocial() != null) {
            return FILLED;
        }
        if (!saida.isCapturaBeneficiarioRazaoSocial()) {
            return NOT_REQUIRED;
        }
        String valor = null;
        ControladorPerifericos periferico = dados.getPerifericos();
        EventoTeclado eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel = new LayoutDisplay(inter.getMessage(MessageEnum.CAPBENRAZSOC_TITLE)), ConstantesApiAc.CAP_BENEFICIARIO_RAZAO_SOCIAL);
        if (eventoTeclado.getTeclaFinalizadora().equals("VOLTA")) {
            return USER_CANCEL;
        }
        int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
        valor = eventoTeclado.getStringLida().substring(num);
        entrada.setBeneficiarioRazaoSocial(valor);
        return SUCCESS;
    }
}

