/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import org.apache.commons.lang3.StringUtils;

public class MicCaptura4UltimodigitoCartao {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String ERRO_NOT_VALID = "ERRO_NOT_VALID";
    public static final String ERRO_NOT_VALID_AC = "ERRO_NOT_VALID_AC";

    public String execute(Process dado) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        if (Contexto.getContexto().getCartao() == null) {
            throw new IllegalArgumentException("Cartao n\u00e3o informado");
        }
        if (!Contexto.getContexto().getSaidaApiTefC().isPede4Digitos()) {
            return UNECESSARY;
        }
        if (Contexto.getContexto().isQuatroUltimosDigCapturados()) {
            return UNECESSARY;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        if (entradaIntegracao != null && entradaIntegracao.isMultiTerminal()) {
            return SUCESS;
        }
        ControladorPerifericos perifericos = dado.getPerifericos();
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.CAP4ULTDIG_TITLE1)));
        displayModel.addLinha(new Linha(inter.getMessage(MessageEnum.CAP4ULTDIG_TITLE2)));
        String digitos = "";
        do {
            if (!"VOLTA".equals((eventoTeclado = (EventoTeclado)perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_4ULTIMOS_DIGITOS, true, 12, false, digitos)).getTeclaFinalizadora())) continue;
            return USERCANCEL;
        } while (StringUtils.isBlank(digitos = StringUtil.retornaStringDigitada(eventoTeclado.getStringLida(), eventoTeclado.getNumCaracteresDigitados())) || !StringUtils.isNumeric(digitos) || digitos.length() != 4);
        String pan = KeyFactory.isChaveLocal() ? Contexto.getContexto().getEntradaApiTefC().getPAN() : Contexto.getContexto().getSaidaApiTefC().getPanMascarado();
        if (!this.isvalid4UltimoDigito(pan, digitos)) {
            this.exibeMensagem(perifericos, inter.getMessage(MessageEnum.CAP4ULTDIG_ERRO_NOT_VALID));
            Contexto.getContexto().setCartao(null);
            return ERRO_NOT_VALID;
        }
        if (entradaIntegracao != null && entradaIntegracao.isConsulta()) {
            Contexto.getContexto().setQuatroUltimosDigCapturados(true);
        }
        return SUCESS;
    }

    private boolean isvalid4UltimoDigito(String numero, String ultimos4digitos) {
        int tamanho = numero.length();
        return ultimos4digitos.equals(numero.substring(tamanho - 4, tamanho));
    }

    private void exibeMensagem(ControladorPerifericos perifericos, String messagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(messagem);
        perifericos.confirmaDado(displayModel);
    }
}

