/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.model.constants.CodigoRetornoAutomacao;
import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.autenticacao.AutenticacaoUtil;
import com.csi.ctfclient.autenticacao.DadosAutenticacao;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.controller.ControladorApitefC;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.FileOutputStream;
import java.security.MessageDigest;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

public class MicAutenticacao
extends MicAbstractBase {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    private String login = null;
    private String cnpj = null;
    private String codigoAtivacaoMultiEC = null;
    private String codigoLoja = null;

    @Override
    public String derivedExecute(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        boolean isHomologacao = confCTFClient.isHomologacao();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean isMultiEC = confCTFClient.isMultiEC();
        return this.capturaDadosAutenticacao(dados, false, isHomologacao, isMultiEC, confCTFClient, inter, perifericos);
    }

    private void limpaDadosAutenticacao() {
        this.login = null;
        this.cnpj = null;
        this.codigoAtivacaoMultiEC = null;
        this.codigoLoja = null;
    }

    private String capturaDadosAutenticacao(Process dados, boolean capturaLoja, boolean isHomologacao, boolean isMultiEC, ConfCTFClient confCTFClient, InternacionalizacaoUtil inter, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        if (!confCTFClient.isSuporteHttps()) {
            return SUCCESS;
        }
        try {
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            if (autenticacaoUtil.isTokenAutorizacao()) {
                return this.returnSucessComDadosRetorno(CodigoRetornoAutomacao.SUCESSO.getCode(), CodigoRetornoAutomacao.SUCESSO.getCode(), "DISPOSITIVO JA REGISTRADO", inter, perifericos, dados, false);
            }
        }
        catch (Exception e) {
            this.logger.error("Erro ao tentar recuperar o token de autorizacao: " + e.getMessage());
            return this.returnErroComDadosRetorno(inter, perifericos, dados, "ERRO RECUPERAR TOKEN AUTORIZACAO");
        }
        String pwd = null;
        while (this.login == null || pwd == null || !isMultiEC && this.cnpj == null || isMultiEC && this.codigoAtivacaoMultiEC == null || this.codigoLoja == null && capturaLoja) {
            EventoTeclado eventoTeclado = null;
            if (this.login == null) {
                eventoTeclado = this.capturaDado(MessageEnum.CAPAUTENTICADOR_LOGIN, ConstantesApiAc.CAP_AUT_LOGIN, inter, perifericos, false);
                this.login = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (pwd == null) {
                eventoTeclado = this.capturaDado(MessageEnum.CAPAUTENTICADOR_PW, ConstantesApiAc.CAP_AUT_PASSWORD, inter, perifericos, true);
                pwd = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            } else if (this.cnpj == null || isMultiEC && this.codigoAtivacaoMultiEC == null) {
                if (isMultiEC) {
                    eventoTeclado = this.capturaDado(MessageEnum.CAPAUTENTICADOR_ATIVACAO_MULTIEC, ConstantesApiAc.CAP_AUT_ATIVACAO_MULTIEC, inter, perifericos, false);
                    this.codigoAtivacaoMultiEC = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
                } else {
                    eventoTeclado = this.capturaDado(MessageEnum.CAPAUTENTICADOR_CNPJ, ConstantesApiAc.CAP_AUT_CNPJ, inter, perifericos, false);
                    this.cnpj = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
                }
            } else if (capturaLoja) {
                eventoTeclado = this.capturaDado(MessageEnum.CAPAUTENTICADOR_LOJA, ConstantesApiAc.CAP_CODIGO_LOJA, inter, perifericos, false);
                this.codigoLoja = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados());
            }
            if (!"VOLTA".equals(eventoTeclado.getTeclaFinalizadora())) continue;
            return USER_CANCEL;
        }
        JsonObject parameters = new JsonObject();
        if (!this.login.contains(String.valueOf('@'))) {
            this.login = this.login.toLowerCase();
            pwd = pwd.toLowerCase();
        }
        parameters.addProperty("login", this.login);
        parameters.addProperty("senha", pwd);
        if (isMultiEC) {
            parameters.addProperty("codigoAtivacao", this.codigoAtivacaoMultiEC);
            parameters.addProperty("codigoMultiEC", String.valueOf(confCTFClient.getCodigoGrupoMultiEC()));
        } else {
            parameters.addProperty("cnpj", this.cnpj);
        }
        if (capturaLoja) {
            parameters.addProperty("codigoLoja", this.codigoLoja.toLowerCase());
        }
        parameters.addProperty("tipo", String.valueOf(confCTFClient.getTipoIntegracaoEnum().getOrigemTransacao().getId()));
        parameters.addProperty("suporteHttps", "true");
        parameters.addProperty("tipoIdentificacao", "3");
        parameters.addProperty("identificacao", AutenticacaoUtil.getIdentificao());
        parameters.addProperty("fabricante", this.getOSName());
        parameters.addProperty("modelo", this.getOSVersion());
        LayoutDisplay displayModel = new LayoutDisplay("AGUARDE...");
        perifericos.imprimeDisplay(displayModel);
        return this.processaResposta(dados, this.cnpj, parameters, isHomologacao, isMultiEC, confCTFClient, inter, perifericos);
    }

    private String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    private String getOSVersion() {
        return System.getProperty("os.version") + "-" + System.getProperty("os.arch");
    }

    /*
     * Exception decompiling
     */
    private String processaResposta(Process dados, String cnpj, JsonObject parameters, boolean isHomolagacao, boolean isMultiEC, ConfCTFClient confCTFClient, InternacionalizacaoUtil inter, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String processaResposta(int httpCode, Process dados, String resposta, String cnpj, boolean isHomolagacao, boolean isMultiEC, ConfCTFClient confCTFClient) throws Exception {
        ControladorPerifericos perifericos;
        InternacionalizacaoUtil inter;
        block23: {
            JsonObject jsonObject;
            inter = InternacionalizacaoUtil.getInstance();
            perifericos = dados.getPerifericos();
            ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
            ConfCTFClient newConfCTFClient = new ConfCTFClient();
            AutenticacaoUtil autenticacaoUtil = AutenticacaoUtil.getInstance();
            autenticacaoUtil.clean();
            try {
                jsonObject = new JsonParser().parse(resposta).getAsJsonObject();
            }
            catch (JsonParseException e) {
                this.exibeMensagemError(inter, perifericos, e, "ERRO NO PROCESSAMENTO", "Erro parser response");
                return "RERUN";
            }
            try {
                int retorno = Integer.parseInt(this.retornaValorObjetoJson(jsonObject, "code", 20).toString());
                if (httpCode == 409 && retorno == 8) {
                    return this.capturaDadosAutenticacao(dados, true, isHomolagacao, isMultiEC, confCTFClient, inter, perifericos);
                }
                if (httpCode != 200) {
                    this.limpaDadosAutenticacao();
                } else {
                    retorno = Integer.parseInt(this.retornaValorObjetoJson(jsonObject, "retorno", 20).toString());
                }
                String token = (String)this.retornaValorObjetoJson(jsonObject, "token", null);
                if (retorno == 0) {
                    String certificadoMD5;
                    JsonArray parametros;
                    newConfCTFClient.setCnpj(cnpj);
                    String terminal = (String)this.retornaValorObjetoJson(jsonObject, "codigoterminal", "codigoTerminal", null);
                    if (terminal != null) {
                        IdentApiTefC identApiTefC = Contexto.getContexto().getIdentApiTefC();
                        String companyCode = terminal.substring(0, 5);
                        String storeCode = terminal.substring(5, 9);
                        String[] terminalCode = terminal.substring(9);
                        newConfCTFClient.setEstabelecimento(companyCode);
                        identApiTefC.setNumeroEstabelecimento(companyCode);
                        newConfCTFClient.setLoja(storeCode);
                        identApiTefC.setNumeroLoja(storeCode);
                        newConfCTFClient.setTerminal((String)terminalCode);
                        identApiTefC.setNumeroPdv(terminal);
                    }
                    if ((parametros = (JsonArray)this.retornaValorObjetoJson(jsonObject, "parametros", "parametro", null)) == null || parametros.size() <= 0) break block23;
                    String[] hostsArray = this.retornaValorParametro(parametros, "hostctf", new ExcecaoParametroInvalido("AUT01", "HOST INVALIDO")).split(";");
                    if (hostsArray.length > 0) {
                        LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                        for (String s : hostsArray) {
                            ServicoCTF servico;
                            newConfCTFClient.setComunicacaoCTF(hostsArray);
                            if (!s.toLowerCase().contains("http")) continue;
                            String strHost = s;
                            Host hostCTF = new Host(strHost);
                            try {
                                servico = new ServicoCTF(hostCTF, "443", "HTTPS");
                            }
                            catch (ExcecaoParametroInvalido e) {
                                this.logger.error("valor de parametro invalido ==> ips = protocolo, usar TCP, UDP ou UDP2, HTTPS");
                                return this.returnErroComDadosRetorno(inter, perifericos, dados);
                            }
                            ips.add(servico);
                        }
                        newConfCTFClient.setIps(ips);
                    }
                    this.retornaValorParametro(parametros, "ambiente", new ExcecaoParametroInvalido("AUT02", "AMBIENTE INVALIDO"));
                    String md5 = this.retornaValorParametro(parametros, "certificado-md5", new ExcecaoParametroInvalido("AUT03", "CERTIFICADO-MD5 INVALIDO"));
                    String certificado = this.retornaValorParametro(parametros, "certificado", new ExcecaoParametroInvalido("AUT04", "CERTIFICADO INVALIDO"));
                    try {
                        byte[] buffer = certificado.getBytes();
                        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                        messageDigest.reset();
                        messageDigest.update(buffer);
                        byte[] resultByte = messageDigest.digest();
                        certificadoMD5 = ByteUtil.byteArrayToHex(resultByte);
                    }
                    catch (Exception e) {
                        this.exibeMensagemError(inter, perifericos, e, "CERTIFICADO INVALIDO", "Erro durante a validacao do certificado: ");
                        return "RERUN";
                    }
                    String clientServicesHost = this.retornaValorParametro(parametros, "clienteservico-host", new ExcecaoParametroInvalido("AUT05", "CLIENTE SERVICO HOST INVALIDO"));
                    if (certificadoMD5.equalsIgnoreCase(md5)) {
                        try {
                            String nomeCertificado = "ca-bundle.crt";
                            FileOutputStream fos = new FileOutputStream(nomeCertificado);
                            fos.write(certificado.getBytes());
                            fos.flush();
                            fos.close();
                        }
                        catch (Exception e) {
                            this.exibeMensagemError(inter, perifericos, e, "ERRO AO GRAVAR CERTIFICADO.", "Erro durante a escrita do certificado: ");
                            return "RERUN";
                        }
                    }
                    if (Objects.requireNonNull(controladorConfCTFClient).getConfig().isSuporteHttps()) {
                        DadosAutenticacao dadosAutenticacao = new DadosAutenticacao();
                        dadosAutenticacao.setToken(token);
                        dadosAutenticacao.setTerminal(terminal);
                        dadosAutenticacao.setClientServicesHost(clientServicesHost);
                        if (newConfCTFClient.getComunicacaoCTF() != null && newConfCTFClient.getComunicacaoCTF().length > 0) {
                            dadosAutenticacao.setCtfHosts(newConfCTFClient.getComunicacaoCTF());
                        }
                        dadosAutenticacao.setIdentificacao(AutenticacaoUtil.getIdentificao());
                        autenticacaoUtil.configDadosAutenticacao(dadosAutenticacao);
                        try {
                            controladorConfCTFClient.save(newConfCTFClient, true);
                        }
                        catch (ExcecaoApiAc e) {
                            autenticacaoUtil.clean();
                        }
                    }
                    dados.setApitef(ControladorApitefC.newInstancia());
                    return this.returnSucessComDadosRetorno(retorno, CodigoRetornoAutomacao.SUCESSO.getCode(), String.valueOf(this.retornaValorObjetoJson(jsonObject, "mensagem", "DISPOSITIVO REGISTRADO!")).toUpperCase(), inter, perifericos, dados, true);
                }
                this.exibeMensagemError(inter, perifericos, null, String.valueOf(this.retornaValorObjetoJson(jsonObject, "message", "ERRO NA AUTENTICACAO")), "Retorno de erro da autenticacao: " + retorno);
                return "RERUN";
            }
            catch (ExcecaoParametroInvalido e) {
                this.exibeMensagemError(inter, perifericos, e, e.getDetalhe(), "parametro invalido, dados retorno autenticacao");
                return "RERUN";
            }
            catch (Exception e) {
                this.exibeMensagemError(inter, perifericos, e, "Erro na Autenticacao", e.getMessage());
                return "RERUN";
            }
        }
        return this.returnErroComDadosRetorno(inter, perifericos, dados);
    }

    private String returnSucessComDadosRetorno(int codigoRetorno, int codigoErro, String message, InternacionalizacaoUtil inter, ControladorPerifericos perifericos, Process dados, boolean isExibeMensagemDisplayCTFClient) throws ExcecaoNaoLocal {
        this.montaDadosRetorno(codigoRetorno, codigoErro, message, inter, perifericos, dados, isExibeMensagemDisplayCTFClient);
        return SUCCESS;
    }

    private String returnErroComDadosRetorno(InternacionalizacaoUtil inter, ControladorPerifericos perifericos, Process dados) throws ExcecaoNaoLocal {
        return this.returnErroComDadosRetorno(inter, perifericos, dados, "ERRO NO PROCESSO AUTENTICACAO");
    }

    private String returnErroComDadosRetorno(InternacionalizacaoUtil inter, ControladorPerifericos perifericos, Process dados, String message) throws ExcecaoNaoLocal {
        this.montaDadosRetorno(CodigoRetornoAutomacao.ERRO_PROCESSO_AUTENTICACAO.getCode(), CodigoErroIntegracaoEnum.ERRO_DURANTE_PROCESSO_AUTENTICACAO.getCode(), message, inter, perifericos, dados, true);
        this.limpaDadosAutenticacao();
        this.setIntegrationError(CodigoErroIntegracaoEnum.ERRO_DURANTE_PROCESSO_AUTENTICACAO, message);
        try {
            AutenticacaoUtil.getInstance().clean();
        }
        catch (Exception e) {
            this.logger.error("Erro ao tentar apagar dados Autenticacao");
        }
        return ERROR;
    }

    private void montaDadosRetorno(int codigoRetorno, int codigoErro, String message, InternacionalizacaoUtil inter, ControladorPerifericos perifericos, Process dados, boolean isExibeMensagemDisplayCTFClient) throws ExcecaoNaoLocal {
        if (!OperationEnum.OP_AUTENTICACAO_TERMINAL.getDescription().equalsIgnoreCase(dados.getOperation().getDescription())) {
            if (isExibeMensagemDisplayCTFClient) {
                this.exibeMensagem(inter, perifericos, null, message, "Retorno da autenticacao: " + codigoRetorno);
            }
        } else {
            SaidaApiTefC saidaApiTefC = new SaidaApiTefC();
            saidaApiTefC.setRetorno(codigoRetorno);
            saidaApiTefC.setDisplayCTF(StringUtils.join(StringUtil.completeNumberZERO(message.length(), 4), message));
            saidaApiTefC.setCodigoErro(codigoErro);
            Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        }
    }

    private EventoTeclado capturaDado(MessageEnum mensagem, ConstantesApiAc.TipoCampo tipoCampo, InternacionalizacaoUtil inter, ControladorPerifericos perifericos, boolean isAplicacaMascaraSenha) throws ExcecaoNaoLocal {
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha(inter.getMessage(MessageEnum.CAPAUTENTICADOR_TITLE)));
        layoutDisplay.addLinha(new Linha(inter.getMessage(mensagem), 0, 1));
        return (EventoTeclado)perifericos.capturaDado(layoutDisplay, tipoCampo, 0, true, isAplicacaMascaraSenha);
    }

    private void exibeMensagemError(InternacionalizacaoUtil inter, ControladorPerifericos perifericos, Exception exception, String msgDisplay, String msgLog) throws ExcecaoNaoLocal {
        this.exibeMensagem(inter, perifericos, exception, msgDisplay, msgLog);
        this.limpaDadosAutenticacao();
    }

    private void exibeMensagem(InternacionalizacaoUtil inter, ControladorPerifericos perifericos, Exception exception, String msgDisplay, String msgLog) throws ExcecaoNaoLocal {
        this.logger.info((Object)msgLog, exception);
        LayoutDisplay layoutDisplay = new LayoutDisplay();
        layoutDisplay.addLinha(new Linha(inter.getMessage(MessageEnum.CAPAUTENTICADOR_TITLE)));
        layoutDisplay.addLinha(new Linha(msgDisplay, 0, 1));
        perifericos.confirmaDado(layoutDisplay);
    }

    String retornaValorParametro(JsonArray jsonParametros, String nomeParametro, ExcecaoParametroInvalido excecaoParametroInvalido) throws ExcecaoParametroInvalido {
        JsonObject parametro;
        JsonElement parametroElement = StreamSupport.stream(jsonParametros.spliterator(), false).filter(jsonObject -> Objects.nonNull(jsonObject.getAsJsonObject())).filter(jsonObject -> Objects.nonNull(jsonObject.getAsJsonObject().get("id"))).filter(jsonObject -> !jsonObject.getAsJsonObject().get("id").isJsonNull()).filter(jsonObject -> nomeParametro.equals(jsonObject.getAsJsonObject().get("id").getAsString())).findFirst().orElse(null);
        JsonObject jsonObject2 = parametro = parametroElement == null ? null : parametroElement.getAsJsonObject();
        if (parametro != null && parametro.get("id") != null && parametro.get("valor") != null && !parametro.get("id").isJsonNull() && !parametro.get("valor").isJsonNull() && StringUtils.isNotBlank(parametro.get("valor").getAsString()) && nomeParametro.equalsIgnoreCase(parametro.get("id").getAsString())) {
            return parametro.get("valor").getAsString();
        }
        throw excecaoParametroInvalido;
    }

    Object retornaValorObjetoJson(JsonObject jsonObject, String nomeObjetoOne, Object valorDefault) {
        return this.retornaValorObjetoJson(jsonObject, nomeObjetoOne, null, valorDefault);
    }

    Object retornaValorObjetoJson(JsonObject jsonObject, String nomeObjetoOne, String nomeObjetoTwo, Object valorDefault) {
        if (jsonObject.has(nomeObjetoOne)) {
            if (jsonObject.get(nomeObjetoOne).isJsonArray()) {
                return jsonObject.getAsJsonArray(nomeObjetoOne);
            }
            if (jsonObject.get(nomeObjetoOne).isJsonObject()) {
                return jsonObject.getAsJsonObject(nomeObjetoOne).getAsJsonArray(nomeObjetoTwo);
            }
            return jsonObject.get(nomeObjetoOne).getAsString();
        }
        if (StringUtils.isNotBlank(nomeObjetoTwo) && jsonObject.has(nomeObjetoTwo)) {
            return jsonObject.get(nomeObjetoTwo).getAsString();
        }
        return valorDefault;
    }
}

