/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicAlterarDataVencimentoCorBan {
    public static final String SUCCESS = "SUCCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String INVALID_DATE = "INVALID_DATE";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public String execute(Process dados) throws ExcecaoNaoLocal {
        EventoTeclado eventoTeclado;
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        if (saida == null || !saida.isPermiteAlteracaoDataVencimentoCorban()) {
            return UNECESSARY;
        }
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if (saida.isDesconsiderarDataVencimentoCodigoBarras()) {
            entrada.setDataVencimentoCorBan(null);
        }
        SimpleDateFormat df = this.createSimpleDateFormat();
        String valorDefault = null;
        if (entrada.getDataVencimentoCorBan() != null) {
            valorDefault = df.format(entrada.getDataVencimentoCorBan());
        }
        String dataDigitada = "";
        ControladorPerifericos perifericos = dados.getPerifericos();
        do {
            if (!"VOLTA".equals((eventoTeclado = this.getEventoTeclado(valorDefault, perifericos)).getTeclaFinalizadora())) continue;
            return USER_CANCEL;
        } while ((dataDigitada = eventoTeclado.getStringLida().substring(0, eventoTeclado.getNumCaracteresDigitados())).length() != 6);
        return this.ajustaDataVencimento(df, dataDigitada, perifericos);
    }

    protected String ajustaDataVencimento(SimpleDateFormat df, String dataDigitada, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        Date novaDataVencimento;
        try {
            novaDataVencimento = df.parse(dataDigitada);
        }
        catch (ParseException e) {
            perifericos.confirmaDado(this.createLayoutDisplay(MessageEnum.CAPDATVEN_ERROR));
            return INVALID_DATE;
        }
        Date dataVencimentoCorBan = Contexto.getContexto().getEntradaApiTefC().getDataVencimentoCorBan();
        if (novaDataVencimento.equals(dataVencimentoCorBan)) {
            logger.info("Data de vencimento n\u00e3o alterada");
        } else {
            logger.info("Data de vencimento alterada de '" + dataVencimentoCorBan + "' para '" + novaDataVencimento + "'");
            Contexto.getContexto().getEntradaApiTefC().setDataVencimentoCorBan(novaDataVencimento);
        }
        return SUCCESS;
    }

    protected SimpleDateFormat createSimpleDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        df.setLenient(false);
        return df;
    }

    protected EventoTeclado getEventoTeclado(String valorDefault, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        return (EventoTeclado)perifericos.capturaDado(this.createLayoutDisplay(MessageEnum.CAPDATVEN_TITLE), ConstantesApiAc.CAP_DATA_VENCIMENTO_DOCUMENTO, 1, true, 10, true, valorDefault);
    }

    protected LayoutDisplay createLayoutDisplay(MessageEnum msgKey) {
        return new LayoutDisplay(InternacionalizacaoUtil.getInstance().getMessage(msgKey));
    }
}

