/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.util.encrypted.EncryptedDataExecutor;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public abstract class MicAbstractSolicitacaoTEF
extends MicAbstractBase {
    public static final String ERROR = "ERROR";
    public static final String SUCCESS = "SUCCESS";
    public static final String ERRO_REJEITADO_AUTORIZADORA = "ERRO_REJEITADO_AUTORIZADORA";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERRO_NAO_AUT_CARTAO = "ERRO_NAO_AUT_CARTAO";
    public static final String CREDITO_REFERIDO = "CREDITO_REFERIDO";

    protected abstract String getCodigoTransacao(Process var1);

    protected abstract String trataRetorno(SaidaApiTefC var1) throws ExcecaoNaoLocal;

    public String genericExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        this.initEntradaApiTefC(entradaApiTefC, dados);
        this.montaDisplay(dados);
        this.performDataEncryption(dados);
        SaidaApiTefC saidaApiTefC = this.solicitaTEF(entradaApiTefC, dados);
        this.preparaDadosParaSolicitarCargaTabela(saidaApiTefC);
        return this.trataRetorno(saidaApiTefC);
    }

    private void performDataEncryption(Process dados) {
        try {
            EncryptedDataExecutor.getInstance(Contexto.getContexto().getSaidaApiTefC()).execute(dados);
        }
        catch (ExcecaoNaoLocal | ExcecaoPerifericos | NullPointerException e) {
            this.logger.error("Nao foi possivel realizar criptografia de dados: " + e.getMessage());
        }
    }

    protected void initEntradaApiTefC(EntradaApiTefC entradaApiTefC, Process dados) {
        String operacao = this.getCodigoTransacao(dados);
        entradaApiTefC.setOperacao(operacao);
        this.logger.debug("initEntradaApiTefC:operacao=" + operacao);
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null) {
            entradaApiTefC.setTimeoutCtf(saidaApiTefC.getTimeOutCTF());
            this.logger.debug("initEntradaApiTefC:timeout-ctf=" + saidaApiTefC.getTimeOutCTF());
        }
    }

    private SaidaApiTefC solicitaTEF(EntradaApiTefC entradaApiTefC, Process dados) {
        return dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entradaApiTefC);
    }

    private void montaDisplay(Process dados) {
        try {
            if (Contexto.getContexto().getSaidaApiTefC() == null) {
                dados.getPerifericos().imprimeDisplay(this.createLayoutDisplayAguarde());
            } else if (!Contexto.getContexto().getSaidaApiTefC().isReenvioNegadaHost()) {
                dados.getPerifericos().imprimeDisplay(this.createLayoutDisplaySolicitacao());
            }
        }
        catch (ExcecaoNaoLocal excecaoNaoLocal) {
            this.logger.warn("Nao foi possivel exibir display no periferico: " + excecaoNaoLocal.getMessage());
        }
    }

    protected LayoutDisplay createLayoutDisplayAguarde() {
        InternacionalizacaoUtil internacionalizacaoUtil = InternacionalizacaoUtil.getInstance();
        LayoutDisplay display = new LayoutDisplay();
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage(MessageEnum.SOLDESPREVAL_SOLICITACAO3)));
        return display;
    }

    protected LayoutDisplay createLayoutDisplaySolicitacao() {
        InternacionalizacaoUtil internacionalizacaoUtil = InternacionalizacaoUtil.getInstance();
        LayoutDisplay display = new LayoutDisplay();
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage(MessageEnum.ENVTRA_SOLICITACAO1)));
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage(MessageEnum.ENVTRA_SOLICITACAO2)));
        display.addLinha(new Linha(internacionalizacaoUtil.getMessage(MessageEnum.ENVTRA_SOLICITACAO3)));
        return display;
    }

    protected void preparaDadosParaSolicitarCargaTabela(SaidaApiTefC saidaApiTefC) {
        try {
            if (saidaApiTefC.isSolicitaCargaTabela() && this.tryGetCardReader() != null) {
                this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Carga solicitada pelo CTFServer");
                CMOSPinPad.getInstance().solicitarCargaTabelas(0);
                this.tryGetCardReader().setSolicitaCargaTabelas(LeitorCartao.CARGA_TABELA_SOLICITADA);
            }
        }
        catch (ExcecaoApiAc e) {
            this.logger.error("Erro ao preparar dados para solicitar realizacao de carga de tabela: " + e.getMessage());
        }
    }
}

