/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;

public abstract class MicAbstractEnvioConsulta {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERROR = "ERROR";
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    protected abstract String getCodigoTransacao(Process var1);

    protected abstract String getOperacao();

    public abstract String execute(Process var1) throws ExcecaoNaoLocal;

    public String genericExecute(Process dados) throws ExcecaoNaoLocal {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        this.imprimeDisplayQuandoIntegracaoWeb(dados);
        entrada.setDataCliente(dados.getStartProcess());
        entrada.setTimeoutCtf(15);
        entrada.setOperacao(this.getOperacao());
        String codigoTransacao = this.getCodigoTransacao(dados);
        if (codigoTransacao != null) {
            entrada.setOperacaoConsultada(codigoTransacao);
        }
        this.setDadosMultiECEntradaApiTefc(entrada);
        SaidaApiTefC saidaApiTefC = this.realizaSolicitacao(dados, entrada);
        if (saidaApiTefC.getRetorno() == 0) {
            logger.info(this.getOperacao() + " APROVADA");
            return SUCESS;
        }
        logger.info(this.getOperacao() + " N\u00c3O APROVADA RETORNO :" + saidaApiTefC.getRetorno() + " CODIGO DETALHE " + saidaApiTefC.getCodigoErro());
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        return ERROR;
    }

    protected SaidaApiTefC realizaSolicitacao(Process dados, EntradaApiTefC entrada) {
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        Contexto.getContexto().setSaidaConsulta(saidaApiTefC);
        return saidaApiTefC;
    }

    protected void setDadosMultiECEntradaApiTefc(EntradaApiTefC entrada) throws ExcecaoNaoLocal {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (conf.isMultiEC()) {
            entrada.setMultiEC(true);
            entrada.setCodigoGrupoMultiEC(conf.getCodigoGrupoMultiEC());
        }
    }

    protected void imprimeDisplayQuandoIntegracaoWeb(Process dados) throws ExcecaoNaoLocal {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (!conf.isIntegracaoWeb()) {
            LayoutDisplay displayModel = new LayoutDisplay(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.ENVIO1G_TITLE));
            dados.getPerifericos().imprimeDisplay(displayModel);
        }
    }
}

