/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.CartaoSeguro;
import com.csi.ctfclient.apitef.model.Produto;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractBase;
import com.csi.ctfclient.operacoes.model.CMOSPinPad;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaCartaoEnvio1F;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartao;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.MessageEnum;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class MicAbstractEnvio1F
extends MicAbstractBase {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String ERRO = "ERRO";
    public static final String ERRO_TRANSGENERICA = "ERRO_TRANSGENERICA";
    public static final String ERRO_AC = "ERROR_AC";
    public static final String REFAZER_LEITURA_CARTAO = "REFAZER_LEITURA_CARTAO";
    public static final String SOLICITA_CARGA_TABELA = "SOLICITA_CARGA_TABELA";
    protected ConfCTFClient confCTFClient;
    private String codigoTransacaoRetorno;

    protected abstract String getCodigoTransacao(Process var1);

    public String genericExecute(Process dados) throws ExcecaoNaoLocal {
        boolean isMultiTerminal;
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        this.confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        this.setIdentificacaoTransacao(entrada);
        PinEMV pin = this.tryGetPin();
        boolean connectedPin = pin != null;
        boolean bl = isMultiTerminal = Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isMultiTerminal();
        if (isMultiTerminal) {
            this.preparaDadosMultiTerminal(entrada);
        } else if (TransactionOperationRules.isCartaoQualidade()) {
            periferico.imprimeDisplay(this.createLayoutDisplay());
            if (!TransactionOperationRules.isTypedOperation() && connectedPin) {
                entrada.setInfo(Contexto.getContexto().getEntradaApiTefC().getIdentificadorCartaoQualidade());
                entrada.setModoEntrada(5);
                if (!this.setDadosBiblioteca(entrada, periferico)) {
                    return ERRO_AC;
                }
            }
        } else {
            periferico.imprimeDisplay(this.createLayoutDisplay());
            if (!TransactionOperationRules.isTypedOperation()) {
                if (connectedPin) {
                    if (!this.setDadosBiblioteca(entrada, periferico)) {
                        return ERRO_AC;
                    }
                    if (conBaixaTecnica.verificaNecessidadeBaixaTecnica(dados)) {
                        entrada.setFlagBaixaTecnicaVisanet('2');
                    }
                } else {
                    entrada.setTipoPin("**");
                }
            }
        }
        entrada.setTimeoutCtf(this.getTimeout1F());
        entrada.setOperacao("1F");
        entrada.setOperacaoConsultada(this.getCodigoTransacao(dados));
        this.preparaDadosMultiEC(entrada);
        boolean isInformouDataVencimento = this.isSetouDataVencimentoQuandoCartaoDigitadoPara1DiaNoFuturo();
        SaidaApiTefC saidaApiTefC = dados.getApitef().solicitacao(Contexto.getContexto().getIdentApiTefC(), entrada);
        this.solicitarDataVencimentoCartao(isInformouDataVencimento);
        Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
        entrada.setFlagBaixaTecnicaVisanet('0');
        conBaixaTecnica.setBaixaTecnicaSolicitada(this.isBaixaTecnicaSolicitada(saidaApiTefC));
        if (connectedPin && !isMultiTerminal && !TransactionOperationRules.isCartaoQualidade()) {
            this.preparaDadosRedeChip(periferico, saidaApiTefC);
            if (saidaApiTefC.isSolicitaCargaTabela() && (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV)) {
                try {
                    return this.preparaDadosParaSolicitarCargaTabela(periferico);
                }
                catch (ExcecaoApiAc e) {
                    this.logger.error("Erro ao preparar dados para solicitar realizacao de carga de tabela: " + e.getMessage());
                }
            }
            if (saidaApiTefC.isRefazerLeituraCartao()) {
                return this.preparaDadosParaRefazerLeituraCartao(saidaApiTefC);
            }
        }
        if (saidaApiTefC.getRetorno() == 0) {
            this.logger.info("1F APROVADA");
            if (saidaApiTefC.isEnableGetInfo1F()) {
                if (connectedPin) {
                    if (!this.setDadosBiblioteca(entrada, periferico)) {
                        return ERRO_AC;
                    }
                } else {
                    entrada.setTipoPin("**");
                }
            }
            this.preparaDadosVan(saidaApiTefC);
            this.preparaDadosAutorizadora(saidaApiTefC);
            this.preparaDadosInstituicaoFinanceira(saidaApiTefC);
            Contexto.getContexto().setDataVencimento(saidaApiTefC.getDataVencimento());
            Contexto.getContexto().setNomeCliente(saidaApiTefC.getNomeCliente());
            entrada.setTimeoutCtf(saidaApiTefC.getTimeOutCTF());
            entrada.setIndiceMasterKey(saidaApiTefC.getIndiceMasterKey());
            if (connectedPin) {
                if (!isMultiTerminal) {
                    this.fillEmvData(entrada, periferico, (BibliotecaPinpad)pin);
                    TabelaCriptografia tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia(saidaApiTefC);
                    CriptografiaOperacoesUtil.atualizaEntradaCriptografia(tabelaCriptografia);
                    if (saidaApiTefC.isCriptografiaCartao()) {
                        this.logger.debug("Criptografar os dados do cart\u00e3o");
                        try {
                            this.createCriptografiaCartaoEnvio1F().montaCriptografiaDados(dados);
                        }
                        catch (ExcecaoPerifericos ex) {
                            this.logger.error("Nao foi possivel criptografar os dados do cartao: " + ex.getMessage());
                            Contexto.getContexto().setErrorCode(ex.getCodigoErroOriginal());
                            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.ERRO_PINPAD, StringUtils.join(inter.getMessage(MessageEnum.REMCAR_OPER_PINPAD_ERROR), " ", Integer.valueOf(ex.getCodigoErroOriginal()))));
                            return ERRO;
                        }
                    }
                    this.persisteBaixaTecnica(entrada, conBaixaTecnica);
                } else {
                    this.preparaDadosRedecardEmv(entrada, periferico);
                }
            }
            return SUCESS;
        }
        if (connectedPin) {
            if (Contexto.getContexto().getErrorCode() == -1 && (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV)) {
                Contexto.getContexto().setErrorCode(0);
            }
            conBaixaTecnica.setBaixaTecnicaSolicitada(false);
        }
        return this.preparaRespostaErro(entrada, saidaApiTefC, periferico);
    }

    protected void fillEmvData(EntradaApiTefC entrada, ControladorPerifericos periferico, BibliotecaPinpad pin) {
        if (pin.isPinpadAbecs()) {
            this.logger.debug("fillEmvData :: fillAbecsEmvKernelVersions");
            this.fillAbecsEmvKernelVersions(entrada, periferico);
        } else {
            this.logger.debug("fillEmvData :: preparaDadosRedecardEmv");
            this.preparaDadosRedecardEmv(entrada, periferico);
        }
    }

    protected void setIdentificacaoTransacao(EntradaApiTefC entrada) {
        if (Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isOrigemTransacaoCtrl()) {
            entrada.setOrigemTransacao(Contexto.getContexto().getEntradaIntegracao().getOrigemTransacao());
        } else if (this.confCTFClient.isIntegracaoWeb()) {
            entrada.setOrigemTransacao(OrigemTransacaoEnum.INTERNET);
        }
    }

    protected void preparaDadosMultiTerminal(EntradaApiTefC entrada) {
        entrada.setTipoPin("**");
        entrada.setOrigemTransacao(OrigemTransacaoEnum.INTERNET);
        entrada.setCodigoAdquirenteWeb(Contexto.getContexto().getEntradaIntegracao().getRedeAdquirente());
    }

    protected boolean setDadosBiblioteca(EntradaApiTefC entrada, ControladorPerifericos periferico) {
        try {
            entrada.setTipoPin("16");
            entrada.setTipoBibliotecaPinpad(1);
            if (!KeyFactory.isChaveLocal()) {
                if (entrada.getCartaoSeguro() == null) {
                    entrada.setCartaoSeguro(new CartaoSeguro());
                }
                entrada.getCartaoSeguro().setWkPAN(ProtocoloBibliotecaCompartilhada.getWkpan());
            }
            GetInfo dadosGetInfo = this.createGetInfo();
            DadosGetInfoRedeEMV dadosGetInfoRedeEMV = periferico.getPinpad().getInfoRedeEMV(4);
            if (dadosGetInfoRedeEMV != null) {
                entrada.setDadosGetInfoRede4(dadosGetInfoRedeEMV.getRespostaDLL());
                entrada.setVersaoBibliotecaRedeEMV(dadosGetInfoRedeEMV.getVersaoAplicacao());
                entrada.setVersaoEspecificacaoRedeEMV(dadosGetInfoRedeEMV.getInformacoesProprietarias());
                dadosGetInfo.setVersaoBibRede4(dadosGetInfoRedeEMV.getVersaoAplicacao());
            }
            SaidaGetInfoEMV getInfoEMV = periferico.getPinpad().getInfo();
            entrada.setNumeroSeriePin(getInfoEMV.getNumSeriePinpad());
            entrada.setRetornoGetInfo(getInfoEMV.getRetorno());
            entrada.setFabricantePinpad(getInfoEMV.getFabricante());
            entrada.setModeloHardware(getInfoEMV.getModeloHardware());
            entrada.setVersaoEspecificacao(getInfoEMV.getVersaoEspecificacao());
            entrada.setVersaoFirmwarePinpad(getInfoEMV.getVersaoFirmware());
            entrada.setVersaoAplicacaoBasica(getInfoEMV.getVersaoAplBasica());
            dadosGetInfo.setCodigoRetorno(getInfoEMV.getRetorno());
            dadosGetInfo.setFabricante(getInfoEMV.getFabricante());
            dadosGetInfo.setModeloHardware(getInfoEMV.getModeloHardware());
            dadosGetInfo.setNumeroSerie(getInfoEMV.getNumSeriePinpad());
            dadosGetInfo.setVersaoEspecificao(getInfoEMV.getVersaoEspecificacao());
            dadosGetInfo.setVersaoAplicacao(getInfoEMV.getVersaoAplBasica());
            dadosGetInfo.setVersaoFirmware(getInfoEMV.getVersaoFirmware());
            dadosGetInfo.setSuportaContactless(getInfoEMV.isSuportaContactless());
            Contexto.getContexto().setDadosGetInfo(dadosGetInfo);
        }
        catch (Exception e) {
            this.logger.error("Erro ao recuperar os dados do PINPAD: " + e.getMessage());
            Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.CONECTE_PIN_PAD, "999 - ERRO CONECTE PINPAD"));
            return false;
        }
        return true;
    }

    protected void preparaDadosMultiEC(EntradaApiTefC entrada) {
        if (this.confCTFClient != null && this.confCTFClient.isMultiEC()) {
            entrada.setMultiEC(true);
            entrada.setCodigoGrupoMultiEC(this.confCTFClient.getCodigoGrupoMultiEC());
        }
    }

    protected boolean isBaixaTecnicaSolicitada(SaidaApiTefC saidaApiTefC) {
        return saidaApiTefC.getRetorno() == 0 && (saidaApiTefC.getFlagBaixaTecnica() == '1' || saidaApiTefC.getFlagBaixaTecnica() == '2');
    }

    protected void preparaDadosRedeChip(ControladorPerifericos periferico, SaidaApiTefC saidaApiTefC) {
        boolean cartaoChipOrContactLess;
        ILeitorCartaoHandler leitorCartao;
        try {
            leitorCartao = periferico.getLeitorCartao();
            cartaoChipOrContactLess = this.isCartaoChipOrContactLess(periferico);
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel preparar os dados da rede chip: " + excecaoPerifericos.getMessage());
            return;
        }
        if (saidaApiTefC.getRedeChip() > 0 && saidaApiTefC.isRefazerLeituraCartao() && cartaoChipOrContactLess) {
            leitorCartao.setRedeAdquirente(saidaApiTefC.getRedeChip());
            if (saidaApiTefC.getIndiceAID() != null) {
                leitorCartao.setIndiceAID(saidaApiTefC.getIndiceAID());
            }
        }
    }

    private boolean isCartaoChipOrContactLess(ControladorPerifericos periferico) throws ExcecaoPerifericos {
        return periferico.getLeitorCartao() != null && (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV);
    }

    protected String preparaDadosParaSolicitarCargaTabela(ControladorPerifericos periferico) throws ExcecaoApiAc {
        this.logger.info("NECESSITA REALIZAR CARGA DE TABELA - Carga solicitada pelo CTFServer");
        CMOSPinPad.getInstance().solicitarCargaTabelas(0);
        if (periferico.getLeitorCartao() != null) {
            periferico.getLeitorCartao().setSolicitaCargaTabelas(LeitorCartao.CARGA_TABELA_SOLICITADA);
            Contexto.getContexto().setSaidaApiTefC(null);
            Contexto.getContexto().resetCartao();
        }
        return SOLICITA_CARGA_TABELA;
    }

    protected String preparaDadosParaRefazerLeituraCartao(SaidaApiTefC saidaApiTefC) {
        this.setCodigoTransacaoRetorno(saidaApiTefC.getCodigoTransacao());
        Contexto.getContexto().setNovaLeituraCartao(true);
        Contexto.getContexto().setSaidaApiTefC(null);
        Contexto.getContexto().resetCartao();
        return REFAZER_LEITURA_CARTAO;
    }

    protected void preparaDadosRedecardEmv(EntradaApiTefC entrada, ControladorPerifericos periferico) {
        try {
            SaidaGetInfoRedecardEMV infoRedecardEMV = periferico.getPinpad().getInfoRedecard();
            entrada.setVersaoBibliotecaCompartilhada(infoRedecardEMV.getInformacaoProprietaria());
            entrada.setVersaoRedeAdquirente(infoRedecardEMV.getVersaoRedeAdquirente());
            entrada.setVersaoKernelEMV(infoRedecardEMV.getVersaoKernelEMV());
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel praparar os dados da redecard EMV: " + excecaoPerifericos.getMessage());
        }
        catch (NullPointerException e) {
            this.logger.warn("Nao foi possivel praparar os dados da redecard EMV: Cartao " + (Object)((Object)Contexto.getContexto().getCartao()));
        }
    }

    protected void preparaDadosVan(SaidaApiTefC saidaApiTefC) {
        Contexto.getContexto().setCodigoVan(saidaApiTefC.getCodigoVan());
        Contexto.getContexto().setCodigoVanAlfa(saidaApiTefC.getCodigoVanAlfa());
        Contexto.getContexto().setNomeVan(saidaApiTefC.getNomeVan());
    }

    protected void preparaDadosAutorizadora(SaidaApiTefC saidaApiTefC) {
        Contexto.getContexto().setDataAutorizadora(saidaApiTefC.getDataAutorizadora());
        Contexto.getContexto().setCodigoAutorizadora(saidaApiTefC.getCodigoAutorizadora());
        Contexto.getContexto().setNomeAutorizadora(saidaApiTefC.getNomeAutorizadora());
    }

    protected void preparaDadosInstituicaoFinanceira(SaidaApiTefC saidaApiTefC) {
        Contexto.getContexto().setCodigoInstituicaoFinanceira(saidaApiTefC.getCodigoInstituicaoFinanceira());
        Contexto.getContexto().setNomeInstituicaoFinanceira(saidaApiTefC.getNomeInstituicaoFinanceira());
    }

    protected void fillAbecsEmvKernelVersions(EntradaApiTefC entradaApiTefC, ControladorPerifericos periferico) {
        try {
            SaidaGetInfoEMV saidaGetInfoEMV = periferico.getPinpad().getInfo();
            entradaApiTefC.setVersaoKernelEMV(saidaGetInfoEMV.getContactEmvKernelVersion());
            entradaApiTefC.setContactlessEmvKernelVersion(saidaGetInfoEMV.getContactlessEmvKernelVersion());
            entradaApiTefC.setMastercardEmvKernelVersion(saidaGetInfoEMV.getMastercardEmvKernelVersion());
            entradaApiTefC.setVisaEmvKernelVersion(saidaGetInfoEMV.getVisaEmvKernelVersion());
            entradaApiTefC.setAmexEmvKernelVersion(saidaGetInfoEMV.getAmexEmvKernelVersion());
            entradaApiTefC.setDiscoverEmvKernelVersion(saidaGetInfoEMV.getDiscoverEmvKernelVersion());
            entradaApiTefC.setPureEmvKernelVersion(saidaGetInfoEMV.getPureEmvKernelVersion());
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("N\u00e3o foi poss\u00edvel ler as informa\u00e7\u00f5es do pinpad ABECS: " + excecaoPerifericos.getMessage());
        }
    }

    @Deprecated
    protected String capturaKsnDukpt(int algoritmo, int indiceMasterKey, PinEMV pinpad) {
        try {
            return pinpad.getDUKPT(algoritmo, indiceMasterKey);
        }
        catch (ExcecaoPerifericos e) {
            this.logger.warn("Erro ao tentar capturar o KSN DUKPT DES/3DES, algoritmo " + algoritmo + ", \u00edndice: " + indiceMasterKey + ". Desc: " + e.getMessage());
            return null;
        }
    }

    protected void persisteBaixaTecnica(EntradaApiTefC entrada, ControladorBaixaTecnica conBaixaTecnica) throws ExcecaoNaoLocal {
        if (conBaixaTecnica.isBaixaTecnicaSolicitada()) {
            entrada.setFlagBaixaTecnicaVisanet('1');
            entrada.setDadosGeraisPin(conBaixaTecnica.montaDadosGeraisPin());
            entrada.setDadosVisanetPin(conBaixaTecnica.montaDadosVisaNetPin());
            ControladorConfCTFClient configInstance = ControladorConfCTFClient.getInstance();
            if (configInstance != null) {
                entrada.setVersaoAc(configInstance.getConfig().getVersaoAC());
            }
            conBaixaTecnica.persisteBaixaTecnica();
        }
    }

    protected String preparaRespostaErro(EntradaApiTefC entrada, SaidaApiTefC saidaApiTefC, ControladorPerifericos periferico) {
        this.logger.info(String.format("1F N\u00c3O APROVADA RETORNO: %d CODIGO DETALHE: %s RESPOSTA AUTORIZADORA: %s", saidaApiTefC.getRetorno(), saidaApiTefC.getCodigoErro(), saidaApiTefC.getCodigoRespostaAutorizadora()));
        String resposta = saidaApiTefC.getCodigoRespostaAutorizadora();
        if (Contexto.getContexto().isTransacaoGenerica()) {
            return ERRO_TRANSGENERICA;
        }
        if ("0ZY".equals(resposta) || "ZY".equals(resposta)) {
            return this.preparaDadosRefazerLeitura(periferico);
        }
        if ("0EB".equals(resposta) || "EB".equals(resposta)) {
            this.resetaCartaoOuSetParaNovaLeitura();
        } else if (Contexto.getContexto().getCartao() != Cartao.DIGITADO) {
            this.resetarCartaoDiferenteDigitado(resposta);
        } else {
            this.resetarDataVencimentoEOuCartao(entrada, resposta);
        }
        return ERRO;
    }

    private String preparaDadosRefazerLeitura(ControladorPerifericos periferico) {
        this.resetaCartaoOuSetParaNovaLeitura();
        KeyFactory.reset();
        try {
            periferico.getLeitorCartao().desabilita();
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            this.logger.warn("Nao foi possivel carregar o leitor de cartoes: " + excecaoPerifericos.getMessage());
        }
        return REFAZER_LEITURA_CARTAO;
    }

    private void resetarCartaoDiferenteDigitado(String resposta) {
        if (this.isResetCartaoAposErroRetornoCTF(resposta)) {
            this.resetaCartaoOuSetParaNovaLeitura();
        } else {
            this.logger.info("Os dados do cart\u00e3o ser\u00e3o preservados ap\u00f3s o retorno com erro");
        }
    }

    private void resetarDataVencimentoEOuCartao(EntradaApiTefC entrada, String resposta) {
        if ("0EM".equals(resposta) || "EM".equals(resposta) || "0EH".equals(resposta) || "EH".equals(resposta)) {
            this.logger.debug("execute :: preparaRespostaErro :: resetarDataVencimentoEOuCartao :: Resetando Data Vencimento");
            entrada.setDataVencimento(null);
        } else if (this.isResetCartaoAposErroRetornoCTF(resposta)) {
            this.logger.debug("execute :: preparaRespostaErro :: resetarDataVencimentoEOuCartao :: Resetando Dados Cartao");
            Contexto.getContexto().resetCartao();
        }
    }

    protected void resetaCartaoOuSetParaNovaLeitura() {
        if (Contexto.getContexto().getCartao() == Cartao.CHIP || Contexto.getContexto().getCartao() == Cartao.CONTACTLESS_EMV) {
            Contexto.getContexto().setNovaLeituraCartao(true);
        } else {
            this.logger.debug("execute :: preparaRespostaErro :: resetaCartaoOuSetParaNovaLeitura :: Resetando Dados Cartao");
            Contexto.getContexto().resetCartao();
        }
    }

    protected LayoutDisplay createLayoutDisplay() {
        return new LayoutDisplay(InternacionalizacaoUtil.getInstance().getMessage(MessageEnum.ENVIO1F_TITLE));
    }

    protected CriptografiaCartaoEnvio1F createCriptografiaCartaoEnvio1F() {
        return new CriptografiaCartaoEnvio1F();
    }

    protected GetInfo createGetInfo() {
        return new GetInfo();
    }

    protected int getTimeout1F() {
        if (this.confCTFClient != null && this.confCTFClient.getTimeOutDefault() > 0) {
            return this.confCTFClient.getTimeOutDefault();
        }
        return 15;
    }

    protected boolean isResetCartaoAposErroRetornoCTF(String resposta) {
        return !"0F0".equals(resposta) && !"F0".equals(resposta);
    }

    protected String getCodigoTransacaoRetorno() {
        return this.codigoTransacaoRetorno;
    }

    protected void setCodigoTransacaoRetorno(String codigoTransacaoRetorno) {
        this.codigoTransacaoRetorno = codigoTransacaoRetorno;
    }

    protected boolean isSetouDataVencimentoQuandoCartaoDigitadoPara1DiaNoFuturo() {
        if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(new Date());
            calender.add(5, 1);
            Contexto.getContexto().getEntradaApiTefC().setDataVencimento(calender.getTime());
            return true;
        }
        return false;
    }

    protected void solicitarDataVencimentoCartao(boolean isSetouDataVencimento) {
        if (isSetouDataVencimento) {
            Contexto.getContexto().getEntradaApiTefC().setDataVencimento(null);
        }
    }

    protected String checkProdutosSaida(String retorno) {
        Produto[] produtos;
        if (Contexto.getContexto().getSaidaApiTefC() != null && SUCESS.equals(retorno) && (produtos = Contexto.getContexto().getSaidaApiTefC().getProdutos()) != null && produtos.length != 0) {
            if (produtos.length > 1) {
                this.logger.info("n\u00famero de produtos inv\u00e1lido. n\u00e3o \u00e9 poss\u00edvel processar a transa\u00e7\u00e3o");
                CodigoErroIntegracao erroIntegracao = new CodigoErroIntegracao(CodigoErroIntegracaoEnum.OPERACAO_NAO_PERMITIDA, "OPERACAO  NAO PERMITIDA");
                Contexto.getContexto().setErroIntegracao(erroIntegracao);
                retorno = ERRO;
            } else {
                Contexto.getContexto().getEntradaApiTefC().setCodigoProduto(produtos[0].getCodigo());
                Contexto.getContexto().getEntradaApiTefC().setFluxoTef(produtos[0].getKeyFluxo());
                Contexto.getContexto().getEntradaApiTefC().setCodigoBandeira(produtos[0].getCodigoBandeira());
            }
        }
        return retorno;
    }
}

