/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.constantes;

public enum ProcessEnum {
    PROCESS_CREDIARIO("", "Crediario"),
    PROCESS_INTEGRACAO("001", "Integra\u00e7\u00e3o"),
    PROCESS_CONFIRMACAO("006", "Processo de Confirma\u00e7\u00e3o"),
    PROCESS_DESFAZIMENTO("007", "Processo de Desfazimento"),
    PROCESS_ULTIMO_COMPROVANTE("012", "Reimpressao do ultimo comprovante"),
    PROCESS_CREDITO("1", "Cart\u00e3o Cr\u00e9dito"),
    PROCESS_CREDITO_PRIMEIRA_COMPRA("1", "Cart\u00e3o Cr\u00e9dito"),
    PROCESS_CREDITO_IATA("2", "Cr\u00e9dito IATA"),
    PROCESS_LEITURA_CARTAO("100", "Leitura do cart\u00e3o"),
    PROCESS_LEITURA_PIN("100", "Leitura do PIN"),
    PROCESS_GO_ON_CHIP("101", "Go On Chip"),
    PROCESS_DEBITO("101", "Cart\u00e3o D\u00e9bito"),
    PROCESS_CONSULTA_FINANCIAMENTO_CREDITO("118", "Consulta Plano Financiamento Cr\u00e9dito"),
    PROCESS_CONSULTA_FINANCIAMENTO_CREDITO_WEB("118", "Consulta Plano Financiamento Cr\u00e9dito - WEB"),
    PROCESS_CONSULTA_ANALITICA_SPC("126", "Consulta Anal\u00edtica SPC"),
    PROCESS_CONSULTA_ANALITICA_SPC_WEB("126", "Consulta Anal\u00edtica SPC Web"),
    PROCESS_VOUCHER("130", "Cart\u00e3o Voucher"),
    PROCESS_CONSULTA_AVS_MULTI_TERMINAL("139", "Consulta AVS Web"),
    PROCESS_REIMPRESSAO_COMPROVANTE("151", "Reimpress\u00e3o de comprovantes."),
    PROCESS_CASH_PRIVATE_LABEL("167", "Cash Private Label"),
    PROCESS_PAGAMENTO_FATURA_CARTAO("183", "Pagamento de fatura do cart\u00e3o"),
    PROCESS_CARGA_TABELA_FORCADA_TEST("189", "Carga Tabela Menu"),
    PROCESS_CARGA_TABELA_MENU("189", "Carga Tabela Menu"),
    PROCESS_DESFAZIMENTO_GERAL("191", "Processo de Desfazimento de Todas as Transa\u00e7\u00f5es"),
    PROCESS_GERACAO_BENEFICIO("215", "Gera\u00e7\u00e3o de benef\u00edcio"),
    PROCESS_ESTATISTICA_MANUAL("225", "Transa\u00e7\u00e3o de estat\u00edstica manual"),
    PROCESS_INICIO_DIA("225", "Transa\u00e7\u00e3o de Inicio Dia"),
    PROCESS_CREDITO_CELULAR("232", "Cr\u00e9dito celular"),
    PROCESS_VALE_GAS("235", "Vale g\u00e1s"),
    PROCESS_TROCO("236", "Troco surpresa"),
    PROCESS_PARCELE_MAIS("238", "Parcele Mais"),
    PROCESS_SAQUE_CARTAO("245, 248", "Saque cr\u00e9dito ou d\u00e9bito, Simula\u00e7\u00e3o saque cr\u00e9dito"),
    PROCESS_SAQUE_TRANSFERENCIA("247, 249", "Saque Transferencia de Cr\u00e9dito, Simula\u00e7\u00e3o Saque Transferencia de Cr\u00e9dito"),
    PROCESS_CONSULTA_SALDO("250-251", "Consulta saldo cr\u00e9dito ou d\u00e9bito"),
    PROCESS_RECARGA_CARTAO_PRE_PAGO("252", "Resgate de Fidelidade"),
    PROCESS_RESGATE_FIDELIDADE("252", "Resgate de Fidelidade"),
    PROCESS_RESGATE_PREMIO("254", "Resgate de pr\u00eamios"),
    PROCESS_FUEL_CONTROL("255", "Fuel Control"),
    PROCESS_OPERACOES_DROGAO("256", "Consulta Cartao"),
    PROCESS_CARTAO_PRESENTE("259, 260 e 300", "Cart\u00e3o presente - Upsight"),
    PROCESS_CRIPTOGRAFIA_DUKPT("259", "Criptografia DUKPT"),
    PROCESS_CARTAO_PREPAGO("260", "Resgate de cart\u00e3o pr\u00e9-pago"),
    PROCESS_DEPOSITO_CONTA("264", "Transferencia Domestica - Deposito"),
    PROCESS_SAQUE_TRANSFERENCIA_DOMESTICA("265", "Transferencia Domestica - Saque"),
    PROCESS_CONSULTA_CONTA_CARTAO("266/349", "Consulta Conta Digital / Conta Credito"),
    PROCESS_CONSULTA_TRANSFERENCIA_DOMESTICA("266", "Transferencia Domestica - Consulta"),
    PROCESS_SIMULACAO_CREDIARIO_CREDITO("270", "Simula\u00e7\u00e3o de Credi\u00e1rio"),
    PROCESS_TROCA_SENHA("271", "Troca de senha"),
    PROCESS_CARGA_PRODUTOS_PROMOCIONAIS("277", "Transa\u00e7\u00e3o carga de produtos S\u00f3cio Torcedor"),
    PROCESS_DESCONTO_PRODUTOS_PROMOCIONAIS("278", "Transa\u00e7\u00e3o de desconto de produtos promocionais - S\u00f3cio Torcedor"),
    PROCESS_CONFIRMACAO_PRE_VENDA("279", "Confirma\u00e7\u00e3o de pr\u00e9-venda"),
    PROCESS_CONFIRMACAO_DESFAZIMENTO_NSUCTF("280/281", "Confirma\u00e7\u00e3o/Desfazimento pelo NSU do CTF"),
    PROCESS_CONVENIO_COMBUSTIVEL("282", "Conv\u00eanio Combust\u00edvel - Shell Expers"),
    PROCESS_ATUALIZACAO_CHIP("283", "Atualiza\u00e7\u00e3o de Chip"),
    PROCESS_CAPTURA_CREDITO("284", "Captura de cr\u00e9dito"),
    PROCESS_ATUALIZACAO_PARTICIPANTE("284", "Atualiza\u00e7\u00e3o Participante"),
    PROCESS_CONSULTA_CPFPROMOCAO_SHELL("286", "Consulta CPF Promo\u00e7\u00e3o Shell"),
    PROCESS_AUTO("287", "Auto"),
    PROCESS_RESGATE_PREMIOS_SHELL("287", "Resgate de Pr\u00eamios"),
    PROCESS_DOTZ("289", "Dotz"),
    PROCESS_CREDITO_MULTI_TERMINAL("301", "Cr\u00e9dito M\u00falti-Terminal"),
    PROCESS_IDENTIFICACAO_ASSOCIADO("301", "Identificacao Associado"),
    PROCESS_CANCELAMENTO_MULTI_TERMINAL("311", "Cancelamento gen\u00e9rico Web"),
    PROCESS_PRE_AUTORIZACAO_ADICIONAL("322", "Pr\u00e9-Autoriza\u00e7\u00e3o Adicional"),
    PROCESS_PAGAMENTO_CONTAS("323", "Pagamento de contas"),
    PROCESS_CREDITO_DIGITAL("325", "Cr\u00e9dito digital"),
    PROCESS_CREDITO_DIGITAL_MULTI_TERMINAL("325", "Cr\u00e9dito digital Multiterminal"),
    PROCESS_CORRESPONDENTE_BANCARIO("328", "Correspondente Banc\u00e1rio"),
    PROCESS_CONSULTA_CHEQUE("329", "Consulta Cheque"),
    PROCESS_CONSULTA_ESTABELECIMENTOS_MULTI_EC("329", "Consulta de Estabelecimentos Comerciais - Multi EC"),
    PROCESS_RESGATE_FACIL("330/331", "Resgate Facil - Compra / Extrato"),
    PROCESS_FIDELIDADE_MILHAS("332/333", "Fidelidade em Milhas"),
    PROCESS_CREDITO_DEBITO4ALL("335/336", "Cr\u00e9dito 4All"),
    PROCESS_CARTAO_PREPAGO_DIGITAL("337/338", "Cart\u00e3o prepago digital"),
    PROCESS_DEPOSITO_CARTAO("340", "Deposito com cartao"),
    PROCESS_EMPRESTIMO("341, 342", "Empresito / Simulacao"),
    PROCESS_VC_MAIS("347", "Pagamento VC Mais"),
    PROCESS_CONSULTA_TELEFONE_CREDITO_DIGITAL("383", "Consulta Telefone Cr\u00e9dito digital"),
    PROCESS_CARGA_TABELA("400", "Carga de tabelas do pinpad"),
    PROCESS_CARGA_TABELA_PREEMPTIVA("400", "Carga preemptiva de tabelas do pinpad"),
    PROCESS_CONFIRMACAO_PRE_AUTORIZACAO("404", "Confirma\u00e7\u00e3o Pr\u00e9-Autoriza\u00e7\u00e3o"),
    PROCESS_CONSULTA_PENDENCIA("407", "Consulta Pendencias"),
    PROCESS_ATIVACAO_SOLUCAO_CERTA("410", "Ativa\u00e7\u00e3o Solu\u00e7\u00e3o Certa"),
    PROCESS_ALTERACAO_PRE_AUTORIZACAO("412", "Altera\u00e7\u00e3o Pr\u00e9-Autoriza\u00e7\u00e3o"),
    PROCESS_DESBLOQUEIO_CARTAO("413", "Desbloqueio de cartao"),
    PROCESS_ADESAO_SEGURO("414", "Adesao Seguro"),
    PROCESS_PAGAMENTO_DINHEIRO_BR_PREMMIA("418", "Gera\u00e7\u00e3o de benef\u00edcio BR Premmia"),
    PROCESS_RESGATE_BR_PREMMIA("419", "Resgate de promo\u00e7\u00e3o com consulta de produtos BR Premmia"),
    PROCESS_QR_CODE_GENERICO("420", "QR Code Gen\u00e9rico"),
    PROCESS_CREDITO_CARTAO_QUALIDADE("421", "Opera\u00e7\u00e3o de Cr\u00e9dito: Cart\u00e3o Qualidade"),
    PROCESS_PIX_PAYMENT("422", "PAGAMENTO PIX"),
    PROCESS_PIX_QUERY("423", "CONSULTA PIX"),
    PROCESS_RECARGA_CARTAO_PRE_PAGO_POSA("424", "OP_RECARGA_CARTAO_PREPAGO_POSA"),
    PROCESS_RESGATE_CARTAO_PRE_PAGO_POSA("425", "OP_RESGATE_CARTAO_PREPAGO_POSA"),
    PROCESS_CANCELAMENTO("444", "Cancelamento gen\u00e9rico"),
    PROCESS_TRANSACOES_GENERICAS("555", "Transa\u00e7\u00f5es gen\u00e9ricas"),
    PROCESS_CONSULTA_AVS("623", "Consulta AVS"),
    PROCESS_CONSULTA_CARTAO("629", "Consulta Cartao"),
    PROCESS_BYPASS("630", "Bypass"),
    PROCESS_CONFIGURAR_TERMINAL("800", "Configuracao do terminal"),
    PROCESS_AUTENTICACAO_TERMINAL("801", "Autentica\u00e7\u00e3o do Terminal"),
    PROCESS_TEF_IPFUNCOES_ADM("900", "TEF-Discado (Menu Administrativo)"),
    PROCESS_TEF_IPOPERACOES_CHEQUE("901", "TEF-Discado (Opera\u00e7\u00e3o Cheque)"),
    PROCESS_TEF_IPVENDA_CARTAO("902", "TEF-Discado (Venda com cart\u00e3o)"),
    PROCESS_TEF_IP_ENVIO_FACIL("903", "TEF-IP (Funcoes Envio Facil)"),
    PROCESS_TEF_IPVENDA_QR_CODE("904", "TEF-Discado (Venda com QR Code)"),
    PROCESS_CAPTURA_DADOS_PINPAD("908", "Captura dado Pinpad"),
    PROCESS_AUTORIZACAO_IATA("AI", "Autoriza\u00e7\u00e3o IATA"),
    PROCESS_BAIXA_TECNICA_MANUAL("BTM", "Baixa T\u00e9cnica Manual"),
    PROCESS_CONSULTA_CDC("CDC", "Consulta CDC"),
    PROCESS_CONFIRMACAO_PRE_AUTORIZACAO_WEB("CPA", "Confirma\u00e7\u00e3o Pr\u00e9-Autoriza\u00e7\u00e3o WEB"),
    PROCESS_CREDITO_PRIVATE_LABEL("CPL", "Cr\u00e9dito Private Label"),
    PROCESS_ECOMMERCE_AUTENTICADO("ECA", "Ecommerce Autenticado"),
    PROCESS_ECO("ECO", "Transa\u00e7\u00e3o ECO"),
    PROCESS_PING("Ping", "Transa\u00e7\u00e3o Ping"),
    PROCESS_PRE_AUTORIZACAO("PRE", "Pr\u00e9-Autoriza\u00e7\u00e3o"),
    PROCESS_PRE_AUTORIZACAO_WEB("PRE", "Pr\u00e9-Autoriza\u00e7\u00e3o WEB"),
    PROCESS_TRANSACOES_SAA("SAA", "Opera\u00e7\u00f5es SAA"),
    PROCESS_TESTE_COMUNICACAO("TESTE_COMUNICACAO", "Transacao Teste de Comunicacao"),
    PROCESS_NAO_MAPEADA("?", "");

    private final String chave;
    private String descricao;

    private ProcessEnum(String chave, String descricao) {
        this.chave = chave;
        this.descricao = descricao;
    }

    public static ProcessEnum of(Class<?> process) {
        String nameEnum = process.getSimpleName().replaceAll("([a-z])([A-Z]+)", "$1_$2").toUpperCase();
        try {
            return ProcessEnum.valueOf(nameEnum);
        }
        catch (Exception exception) {
            return PROCESS_NAO_MAPEADA.atualizaDescricao(process.getSimpleName());
        }
    }

    public String getChave() {
        return this.chave;
    }

    public String getDescricao() {
        return this.descricao;
    }

    private ProcessEnum atualizaDescricao(String descricao) {
        this.descricao = descricao;
        return this;
    }
}

