/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.action;

import com.csi.ctfclient.operacoes.Action;
import com.csi.ctfclient.operacoes.ActionForward;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessConstructorArguments;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicEnvio1FCriptografiaDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicExibeMensagemInjecaoDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicHabilitaCertificadoDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicHabilitaInjetarChaveDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicLeituraCertificadoDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicLeituraInjetarChaveDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicSolicitacaoInjecaoChaveDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificaComunicacaoCTF;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificacaoCriptografiaDUKPT;
import com.csi.ctfclient.operacoes.microoperacoes.MicVerificacaoTentativaInjecao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;

public class ProcessCriptografiaDUKPT
extends Process
implements ICriptografiaDUKPT {
    private String certificadoCriptografico;
    private String identificadorChaveRSA;
    private int tentativaInjecao = 1;

    public ProcessCriptografiaDUKPT(ProcessConstructorArguments args, String tipoOperacao, EntradaCTFClientCtrl entradaIntegracao, int numeroTransacao, OrigemTransacaoEnum codigoOrigemTransacao) {
        super(args);
        Contexto.getContexto().setTipoOperacao(tipoOperacao);
        Contexto.getContexto().setEntradaIntegracao(entradaIntegracao);
        Contexto.getContexto().getEntradaApiTefC().setNumeroTransacao(numeroTransacao);
        Contexto.getContexto().getEntradaApiTefC().setOrigemTransacao(codigoOrigemTransacao);
    }

    @Override
    public void initialize() {
        Action solicita1FCriptografiaDUKPT = new Action("solicita1FCriptografiaDUKPT", MicEnvio1FCriptografiaDUKPT.class);
        solicita1FCriptografiaDUKPT.addActionForward(new ActionForward("SUCESS", "verificaCriptografiaDUKPT"));
        solicita1FCriptografiaDUKPT.addActionForward(new ActionForward("UNECESSARY", "verificaCriptografiaDUKPT"));
        solicita1FCriptografiaDUKPT.addActionForward(new ActionForward("ERRO", "verificaComunicao1F"));
        solicita1FCriptografiaDUKPT.addActionForward(new ActionForward("SOLICITA_CARGA_TABELA", "verificaCriptografiaDUKPT"));
        this.addAction(solicita1FCriptografiaDUKPT);
        Action verificaComunicao1F = new Action("verificaComunicao1F", MicVerificaComunicacaoCTF.class);
        verificaComunicao1F.addActionForward(new ActionForward("SUCESS", 0));
        verificaComunicao1F.addActionForward(new ActionForward("ERRO", 6));
        verificaComunicao1F.addActionForward(new ActionForward("ERRO_RETURN_AC", 6));
        this.addAction(verificaComunicao1F);
        Action verificaCriptografiaDUKPT = new Action("verificaCriptografiaDUKPT", MicVerificacaoCriptografiaDUKPT.class);
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("SUCCESS", 0));
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("SUCCESS_CRIPTOGRAFIA_CONTINGENCIA", 0));
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("SUCCESS_DUKPT", 0));
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("SUCCESS_INJETAR_CHAVE_DUKPT", "habilitaCertificadoDUKPT"));
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("NOT_REQUIRED", 0));
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("NO_PINPAD", 0));
        verificaCriptografiaDUKPT.addActionForward(new ActionForward("ERROR", 1));
        this.addAction(verificaCriptografiaDUKPT);
        Action habilitaCertificadoDUKPT = new Action("habilitaCertificadoDUKPT", MicHabilitaCertificadoDUKPT.class);
        habilitaCertificadoDUKPT.addActionForward(new ActionForward("SUCCESS", "leituraCertificadoDUKPT"));
        habilitaCertificadoDUKPT.addActionForward(new ActionForward("ERROR", 1));
        this.addAction(habilitaCertificadoDUKPT);
        Action leituraCertificadoDUKPT = new Action("leituraCertificadoDUKPT", MicLeituraCertificadoDUKPT.class);
        leituraCertificadoDUKPT.addActionForward(new ActionForward("SUCCESS", "solicitacaoInjecaoChaveDUKPT"));
        leituraCertificadoDUKPT.addActionForward(new ActionForward("ERROR", "verificacaoTentativaInjecao"));
        leituraCertificadoDUKPT.addActionForward(new ActionForward("USER_CANCEL", "solicitacaoInjecaoChaveDUKPT"));
        this.addAction(leituraCertificadoDUKPT);
        Action solicitacaoInjecaoChaveDUKPT = new Action("solicitacaoInjecaoChaveDUKPT", MicSolicitacaoInjecaoChaveDUKPT.class);
        solicitacaoInjecaoChaveDUKPT.addActionForward(new ActionForward("SUCCESS", "habilitaInjetarChaveDUKPT"));
        solicitacaoInjecaoChaveDUKPT.addActionForward(new ActionForward("ERROR", "verificaComunicaoSolicitacao"));
        this.addAction(solicitacaoInjecaoChaveDUKPT);
        Action verificaComunicaoSolicitacao = new Action("verificaComunicaoSolicitacao", MicVerificaComunicacaoCTF.class);
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("SUCESS", 0));
        verificaComunicaoSolicitacao.addActionForward(new ActionForward("ERRO", "verificacaoTentativaInjecao"));
        this.addAction(verificaComunicaoSolicitacao);
        Action habilitaInjetarChaveDUKPT = new Action("habilitaInjetarChaveDUKPT", MicHabilitaInjetarChaveDUKPT.class);
        habilitaInjetarChaveDUKPT.addActionForward(new ActionForward("SUCCESS", "leituraInjetarChaveDUKPT"));
        this.addAction(habilitaInjetarChaveDUKPT);
        Action leituraInjetarChaveDUKPT = new Action("leituraInjetarChaveDUKPT", MicLeituraInjetarChaveDUKPT.class);
        leituraInjetarChaveDUKPT.addActionForward(new ActionForward("SUCCESS", "exibeMensagemInjecaoDUKPT"));
        leituraInjetarChaveDUKPT.addActionForward(new ActionForward("ERROR", "verificacaoTentativaInjecao"));
        leituraInjetarChaveDUKPT.addActionForward(new ActionForward("USER_CANCEL", 3));
        this.addAction(leituraInjetarChaveDUKPT);
        Action verificacaoTentativaInjecao = new Action("verificacaoTentativaInjecao", MicVerificacaoTentativaInjecao.class);
        verificacaoTentativaInjecao.addActionForward(new ActionForward("REFAZER_TENTATIVA_INJECAO", "solicita1FCriptografiaDUKPT"));
        verificacaoTentativaInjecao.addActionForward(new ActionForward("TENTATIVAS_ESGOTADAS", 0));
        this.addAction(verificacaoTentativaInjecao);
        Action exibeMensagemInjecaoDUKPT = new Action("exibeMensagemInjecaoDUKPT", MicExibeMensagemInjecaoDUKPT.class);
        exibeMensagemInjecaoDUKPT.addActionForward(new ActionForward("SUCCESS", 0));
        exibeMensagemInjecaoDUKPT.addActionForward(new ActionForward("ERROR", 0));
        this.addAction(exibeMensagemInjecaoDUKPT);
        this.setStartKeyAction("solicita1FCriptografiaDUKPT");
    }

    @Override
    public String getIdentificadorChaveRSA() {
        return this.identificadorChaveRSA;
    }

    @Override
    public void setIdentificadorChaveRSA(String identificadorChaveRSA) {
        this.identificadorChaveRSA = identificadorChaveRSA;
    }

    @Override
    public String getCertificadoCriptografico() {
        return this.certificadoCriptografico;
    }

    @Override
    public void setCertificadoCriptografico(String certificadoCriptografico) {
        this.certificadoCriptografico = certificadoCriptografico;
    }

    @Override
    public int getNumeroMaximoTentativasInjecaoDUKPT() {
        return 3;
    }

    @Override
    public int getTentativaInjecao() {
        return this.tentativaInjecao;
    }

    @Override
    public void setTentativaInjecao(int tentativaInjecao) {
        this.tentativaInjecao = tentativaInjecao;
    }
}

