/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes;

import br.com.auttar.AuttarLogger;
import br.com.auttar.util.operation.TransactionOperationRules;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.Action;
import com.csi.ctfclient.operacoes.ActionForward;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.domain.CodigoErroIntegracaoEnum;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.OrigemTransacaoEnum;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.ReflectHelp;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;

public class ProcessManager {
    private static final String MSG_OPEUSERCANCEL = "OPERACAO        CANCELADA";
    private static final String MSG_USERCANCEL = "OPERACAO CANCELADA";
    private static ProcessManager processManager;
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ProcessManager.class);
    private final Vector<ExecutableProcess> processListManager = new Vector();

    private ProcessManager() {
        this.logger.info("Inicializando ProcessManager");
    }

    public static ProcessManager getInstance() {
        if (processManager == null) {
            processManager = new ProcessManager();
        }
        return processManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutableProcess findProcess(int idProcess) {
        ExecutableProcess execProcess = null;
        Vector<ExecutableProcess> vector = this.processListManager;
        synchronized (vector) {
            Enumeration<ExecutableProcess> enumerations = this.processListManager.elements();
            while (enumerations.hasMoreElements()) {
                Process process;
                execProcess = enumerations.nextElement();
                if (execProcess.getProcessList() == null || execProcess.getProcessList().isEmpty()) continue;
                Enumeration<Process> enumProcess = execProcess.getProcessList().elements();
                while (enumProcess.hasMoreElements() && (process = enumProcess.nextElement()).getIdProcess() != idProcess) {
                }
            }
        }
        return execProcess;
    }

    private void registyProcess(ExecutableProcess process) {
        this.processListManager.add(process);
    }

    public void process(Process process) {
        ExecutableProcess execProcess = new ExecutableProcess();
        this.registyProcess(execProcess);
        execProcess.execute(process);
        this.processListManager.remove(execProcess);
    }

    public void subProcess(int idParent, Process subProcess) throws ExcecaoNaoLocal {
        ExecutableProcess execProcess = this.findProcess(idParent);
        execProcess.subProcess(idParent, subProcess);
    }

    class ExecutableProcess {
        private Vector<Process> processList = new Vector();

        public int getIdProcess() {
            return this.hashCode();
        }

        public Vector<Process> getProcessList() {
            return this.processList;
        }

        public void setProcessList(Vector<Process> processList) {
            this.processList = processList;
        }

        private Process findProcess(int id) {
            Process process = null;
            Enumeration<Process> enumerations = this.processList.elements();
            while (enumerations.hasMoreElements() && (process = enumerations.nextElement()).getIdProcess() != id) {
            }
            return process;
        }

        public Process subProcess(int idParent, Process subProcess) throws ExcecaoNaoLocal {
            ProcessManager.this.logger.info("Iniciando Sub Processo - [" + subProcess.getKey() + "] - " + subProcess.getDescription());
            Process parentProcess = this.findProcess(idParent);
            subProcess.setPerifericos(parentProcess.getPerifericos());
            subProcess.setApitef(parentProcess.getApitef());
            subProcess.setParent(parentProcess);
            try {
                this.execute(subProcess);
            }
            catch (Throwable e) {
                subProcess.setErro(e);
                if (subProcess.getParent() != null) {
                    subProcess.getParent().setErro(e);
                }
                throw new ExcecaoNaoLocal(e, "PM01");
            }
            ProcessManager.this.logger.info("Fim Sub Processo - [" + subProcess.getKey() + "] - " + subProcess.getDescription());
            return subProcess;
        }

        private void registyProcess(Process process) {
            this.processList.add(process);
        }

        public void execute(Process process) {
            this.registyProcess(process);
            try {
                if (process.getStartKeyAction() != null && !process.getStartKeyAction().equals("")) {
                    ProcessManager.this.logger.info("Iniciando Processo - [" + process.getKey() + "] - " + process.getDescription());
                    process.setState(2);
                    this.executeAction(process.getAction(process.getStartKeyAction()), process);
                    if (process.getEndKeyAction() != null) {
                        int state = process.getState();
                        this.executeAction(process.getAction(process.getEndKeyAction()), process);
                        process.setState(state);
                    }
                    ProcessManager.this.logger.info("Fim Processo - [" + process.getKey() + "] - " + process.getDescription());
                }
            }
            catch (Throwable t) {
                ProcessManager.this.logger.error((Object)("Erro Processo - [" + process.getKey() + "] - " + process.getDescription() + ": " + t.getMessage()), t);
            }
            this.processList.remove(process);
        }

        private void executeAction(Action action, Process process) {
            block34: {
                try {
                    block6: while (action != null) {
                        String resultForward;
                        String nameClass = action.getProcessClass().getName();
                        String simpleName = nameClass.substring(nameClass.lastIndexOf(".") + 1);
                        ProcessManager.this.logger.info("action [" + action.getKey() + "] -> " + simpleName);
                        Class<?> classe = action.getProcessClass();
                        Object instance = classe.newInstance();
                        Method method = ReflectHelp.getMethod(classe, "execute");
                        Object[] object = new Object[]{process};
                        while ((resultForward = (String)method.invoke(instance, object)).equals("RERUN")) {
                        }
                        ActionForward actionForward = action.getActionForward(resultForward);
                        ProcessManager.this.logger.info("action [" + action.getKey() + "] -> " + resultForward);
                        if (actionForward != null) {
                            if (actionForward.getActionKey() == null || actionForward.getActionKey().equals("")) {
                                if (actionForward.getState() == 6) {
                                    action = null;
                                    process.setState(1);
                                } else if (actionForward.getState() == 3) {
                                    if (process.getState() == 3) break;
                                    if (process.isActiveDialogUserCancel()) {
                                        int opt = process.getPerifericos().exibeMenuCancelamento();
                                        switch (opt) {
                                            case 1: {
                                                boolean exibeUserCancelPinpad;
                                                if (Contexto.getContexto().getUserCancelMessage() != null && Contexto.getContexto().getUserCancelMessage().length() > 0) {
                                                    LayoutDisplay layoutDisplay = new LayoutDisplay(Contexto.getContexto().getUserCancelMessage(), ControladorConfCTFClient.TIME_OUT_DELAY);
                                                    process.getPerifericos().imprimeDisplay(layoutDisplay);
                                                    process.getPerifericos().limpaDisplay();
                                                }
                                                LayoutDisplay displayModel = new LayoutDisplay(ProcessManager.MSG_USERCANCEL, ControladorConfCTFClient.TIME_OUT_DELAY);
                                                boolean bl = exibeUserCancelPinpad = Contexto.getContexto().getEntradaIntegracao() == null || Contexto.getContexto().getEntradaIntegracao().getOrigemTransacao() != OrigemTransacaoEnum.TELEFONE;
                                                if (!(Contexto.getContexto().getEntradaIntegracao() == null || Contexto.getContexto().getEntradaIntegracao().getOrigemTransacao() != OrigemTransacaoEnum.MOBILE && Contexto.getContexto().getEntradaIntegracao().getOrigemTransacao() != OrigemTransacaoEnum.POS_TEF && Contexto.getContexto().getEntradaIntegracao().getOrigemTransacao() != OrigemTransacaoEnum.POS_TEF_TERCEIRO || process.getPerifericos().getPinpad() == null || process.getPerifericos().getPinpad().getHabilitado())) {
                                                    exibeUserCancelPinpad = false;
                                                }
                                                if (TransactionOperationRules.isTypedOperation()) {
                                                    exibeUserCancelPinpad = false;
                                                }
                                                ProcessManager.this.logger.info("executeAction :: case[1] :: actionForward[3]:: exibeUserCancelPinpad: " + exibeUserCancelPinpad);
                                                if (exibeUserCancelPinpad) {
                                                    if (process.getPerifericos().perifericoCarregado("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad") && process.getPerifericos().getPinpad() != null) {
                                                        process.getPerifericos().getPinpad().setMsgDisplay(ProcessManager.MSG_OPEUSERCANCEL);
                                                    }
                                                    process.getPerifericos().imprimeDisplay(displayModel);
                                                }
                                                process.setState(actionForward.getState());
                                                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.USERCANCEL, ProcessManager.MSG_USERCANCEL));
                                                process.setState(3);
                                                break;
                                            }
                                            case 2: {
                                                continue block6;
                                            }
                                        }
                                    } else {
                                        process.setState(3);
                                    }
                                } else if (actionForward.getState() == 1) {
                                    process.setState(actionForward.getState());
                                } else if (actionForward.getState() == 4) {
                                    process.setState(actionForward.getState());
                                } else if (actionForward.getState() == 5) {
                                    if (process.getState() == 5) break;
                                    process.getPerifericos().limpaDisplay();
                                    if (Contexto.getContexto().getUserCancelMessage() != null && Contexto.getContexto().getUserCancelMessage().length() > 0) {
                                        LayoutDisplay layoutDisplay = new LayoutDisplay(Contexto.getContexto().getUserCancelMessage(), ControladorConfCTFClient.TIME_OUT_DELAY);
                                        process.getPerifericos().imprimeDisplay(layoutDisplay);
                                        process.getPerifericos().limpaDisplay();
                                    }
                                    LayoutDisplay displayModel = new LayoutDisplay(ProcessManager.MSG_USERCANCEL, ControladorConfCTFClient.TIME_OUT_DELAY);
                                    boolean exibeUserCancelPinpad = Contexto.getContexto().getEntradaIntegracao() == null || Contexto.getContexto().getEntradaIntegracao().getOrigemTransacao() != OrigemTransacaoEnum.TELEFONE;
                                    ProcessManager.this.logger.info("executeAction :: actionForward[5]:: exibeUserCancelPinpad: " + exibeUserCancelPinpad);
                                    if (exibeUserCancelPinpad) {
                                        if (process.getPerifericos().getPinpad() != null) {
                                            process.getPerifericos().getPinpad().setMsgDisplay(ProcessManager.MSG_OPEUSERCANCEL);
                                        }
                                        process.getPerifericos().imprimeDisplay(displayModel);
                                        if (process.getPerifericos().getPinpad() != null) {
                                            process.getPerifericos().getPinpad().setMsgDisplay(process.getPerifericos().getPinpad().getMsgPrompt());
                                        }
                                    }
                                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(CodigoErroIntegracaoEnum.USERCANCEL, ProcessManager.MSG_USERCANCEL));
                                    process.setState(5);
                                } else {
                                    process.setState(0);
                                }
                                action = null;
                                continue;
                            }
                            if (!process.getActions().containsKey(actionForward.getActionKey())) {
                                throw new IllegalStateException("action [\"" + actionForward.getActionKey() + "\"] n\u00e3o encontrado");
                            }
                            action = process.getAction(actionForward.getActionKey());
                            continue;
                        }
                        action = null;
                        process.setState(1);
                    }
                }
                catch (Throwable throwable) {
                    if (throwable instanceof InvocationTargetException) {
                        String exceptionName = throwable.getCause().getClass().getName();
                        ProcessManager.this.logger.fatal((Object)String.format("action [%s] - %s", action.getKey(), exceptionName), throwable.getCause());
                    } else {
                        String exceptionName = throwable.getClass().getName();
                        ProcessManager.this.logger.fatal((Object)String.format("action [%s] - %s", action != null ? action.getKey() : "", exceptionName), throwable);
                    }
                    ProcessManager.this.logger.fatal(String.format("Excecao final: %s", throwable.getClass().getName()));
                    process.setErro(throwable);
                    process.setState(1);
                    if (process.getParent() == null) break block34;
                    process.getParent().setErro(throwable);
                }
            }
        }
    }
}

