/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.websocket;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.model.FormaPagamentoValor;
import com.csi.ctfclient.apitef.model.ProdutoSplitPagamento;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.integracao.GeneralConfigException;
import com.csi.ctfclient.integracao.GeneralConfigHandler;
import com.csi.ctfclient.integracao.GeneralConfigKeys;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.websocket.Draft_17_Auttar;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.EstabelecimentoMultiECResposta;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.servicos.RespostaConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.servicos.SaidaCTFClient;
import com.csi.ctfclient.tools.util.StringUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;
import org.java_websocket.server.WebSocketServer;

public class WebSocketHandler
extends Handler {
    protected static final Logger logger = LogManager.getLogger(CTFClient.class);
    private static GeneralConfigHandler generalConfigHandler;
    private final int port;
    private CtfClientWebSocketServer server;
    private CtfClientWebSocketServer serverConfig;
    private static final Map<String, String> configKeyValues;

    private GeneralConfigHandler getGeneralConfigHandler() {
        if (generalConfigHandler == null) {
            generalConfigHandler = GeneralConfigHandler.getInstance();
        }
        return generalConfigHandler;
    }

    protected String getConfigValue(String key) throws GeneralConfigException {
        if (!configKeyValues.containsKey(key)) {
            configKeyValues.put(key, this.getGeneralConfigHandler().getValue(key));
        }
        return configKeyValues.get(key);
    }

    public WebSocketHandler(String strHost, String port) {
        this.port = Integer.parseInt(port);
    }

    @Override
    public void start() {
        try {
            Draft_17_Auttar draft = new Draft_17_Auttar(operacao -> {
                String comando = "{operacao: " + operacao + "}";
                this.server.onMessage(null, comando);
            });
            this.server = new CtfClientWebSocketServer(this.port, draft);
            this.init();
            this.server.start();
            logger.info("Servidor WebSocket CTFClient aberto.");
            if (this.port != 2500) {
                this.serverConfig = new CtfClientWebSocketServer(2500, draft);
                this.serverConfig.start();
                logger.info("porta de configuracao inicializado.");
            }
        }
        catch (Exception e) {
            logger.fatal("Falha ao iniciar o servidor websocket. " + e.getMessage());
        }
    }

    protected void init() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, GeneralConfigException {
        if (this.port == 4433) {
            String STORETYPE = "JKS";
            String KEYSTORE = "cacerts.jks";
            KeyStore ks = KeyStore.getInstance(STORETYPE);
            File kf = new File(KEYSTORE);
            FileInputStream fis = new FileInputStream(kf);
            ks.load(fis, this.getConfigValue(GeneralConfigKeys.STOREPASSWORD.name()).toCharArray());
            fis.close();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, this.getConfigValue(GeneralConfigKeys.KEYPASSWORD.name()).toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            this.getService().setWebSocketFactory(new DefaultSSLWebSocketServerFactory(sslContext));
            logger.info("SSContext inicializado para WebSocket");
        }
    }

    protected CtfClientWebSocketServer getService() {
        return this.server;
    }

    @Override
    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            logger.error("nao foi possivel finalizar o servico WebSocket", (Throwable)e);
        }
        try {
            if (this.serverConfig != null) {
                this.serverConfig.stop();
            }
        }
        catch (Exception e) {
            logger.error("nao foi possivel finaliza a porta de configuracao", (Throwable)e);
        }
    }

    static {
        configKeyValues = new HashMap<String, String>();
    }

    static class CupomUtil {
        public static final String CLIENTE = "CUPOMCTF.1";
        public static final String ESTABELECIMENTO = "CUPOMCTF.2";
        public static final String REDUZIDO = "REDUZIDO.1";
        public static final String CUPOMS = "CUPOMS.1";

        CupomUtil() {
        }

        public static JsonArray getCupom(String tipoCupom, EntradaCTFClient entrada) {
            JsonArray jsonArray = new JsonArray();
            try {
                String pdv;
                String loja;
                String estabelecimento;
                ControladorConfCTFClient controladorConfCTFClient = ControladorConfCTFClient.getInstance();
                ConfCTFClient config = Objects.requireNonNull(controladorConfCTFClient).getConfig();
                EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                boolean multiEC = config.isMultiEC();
                if (entradaIntegracao != null && multiEC) {
                    IdentTerminal identTerminal = Contexto.getContexto().getEntradaIntegracao().getIdentTerminal();
                    estabelecimento = identTerminal.getEstabelecimento();
                    loja = identTerminal.getLoja();
                    pdv = identTerminal.getTerminal();
                } else {
                    estabelecimento = config.getEstabelecimento();
                    loja = config.getLoja();
                    pdv = config.getTerminal();
                }
                String path = ControladorConfCTFClient.getDiretorioTrabalho();
                path = path + estabelecimento.substring(1) + loja + "." + pdv + File.separator + tipoCupom;
                path = path + StringUtil.completaString(String.valueOf(entrada.getNumeroTransacao()), 2, '0', 3);
                File fileCupom = new File(path);
                if (fileCupom.exists()) {
                    String linha;
                    FileReader fReader = new FileReader(fileCupom);
                    BufferedReader bufReader = new BufferedReader(fReader);
                    while ((linha = bufReader.readLine()) != null) {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("linha", linha);
                        jsonArray.add(jsonObject);
                    }
                    bufReader.close();
                    fReader.close();
                }
            }
            catch (Exception e) {
                logger.error("Falha ao ler o cupom. " + e.getMessage());
            }
            if (jsonArray.size() == 0) {
                return null;
            }
            return jsonArray;
        }
    }

    static class SaidaTypeAdapter
    implements JsonSerializer<SaidaCTFClient> {
        public EntradaCTFClient entrada;

        public SaidaTypeAdapter(EntradaCTFClient entradaCTFClient) {
            this.entrada = entradaCTFClient;
        }

        @Override
        public JsonElement serialize(SaidaCTFClient saida, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("operacao", this.entrada.getOperacao());
            jsonObject.addProperty("retorno", saida.getCodigoRetorno());
            jsonObject.addProperty("codigoErro", saida.getCodigoErro());
            String[] display = saida.getMensagemCTF();
            if (display != null && display.length > 0) {
                JsonArray jsonArray = new JsonArray();
                for (String s : display) {
                    JsonObject jsonMsg = new JsonObject();
                    jsonMsg.addProperty("mensagem", s);
                    jsonArray.add(jsonMsg);
                }
                jsonObject.add("display", jsonArray);
            }
            if (this.isNotNull(saida.getCodigoRespAutorizadora())) {
                jsonObject.addProperty("codigoRespAutorizadora", saida.getCodigoAutorizadora());
            }
            if (this.isNotNull(saida.getCodigoAprovacao())) {
                jsonObject.addProperty("codigoAprovacao", saida.getCodigoAprovacao());
            }
            if (saida.getValorTransacao() != null && saida.getValorTransacao().doubleValue() > 0.0) {
                jsonObject.addProperty("valorTransacao", String.valueOf(saida.getValorTransacao().movePointRight(2)));
            }
            if (saida.getNsuCTF() > 0) {
                jsonObject.addProperty("nsuCTF", saida.getNsuCTF());
            }
            if (saida.getNsuAutorizadora() > 0L) {
                jsonObject.addProperty("nsuAutorizadora", saida.getNsuAutorizadora());
            }
            if (this.isNotNull(saida.getNomeBandeiraProduto())) {
                jsonObject.addProperty("bandeira", saida.getNomeBandeiraProduto());
            }
            if (this.isNotNull(saida.getNomeRedeAdquirente())) {
                jsonObject.addProperty("redeAdquirente", saida.getNomeRedeAdquirente());
            }
            if (this.isNotNull(saida.getNumeroCartao())) {
                jsonObject.addProperty("cartao", saida.getNumeroCartao());
            }
            if (saida.getIdentConsulta() > 0L) {
                jsonObject.addProperty("identConsulta", StringUtil.completaString(String.valueOf(saida.getIdentConsulta()), 19, '0', 3));
            }
            if (this.entrada.getOperacao() == OperationEnum.OP_CONSULTA_ESTABELECIMENTOS_MULTI_EC.getKey().intValue()) {
                RespostaConsultaEstabelecimentosMultiEC respostaMultiEC = saida.getRespostaConsultaEstabelecimentosMultiEC();
                if (respostaMultiEC != null && respostaMultiEC.getListEstabelecimentosComerciais() != null && respostaMultiEC.getListEstabelecimentosComerciais().size() > 0) {
                    List<EstabelecimentoMultiECResposta> listEstabelecimentosComerciais = respostaMultiEC.getListEstabelecimentosComerciais();
                    StringBuilder buffer = new StringBuilder();
                    for (EstabelecimentoMultiECResposta estabelecimentoMultiEC : listEstabelecimentosComerciais) {
                        buffer.append(StringUtil.completaString(estabelecimentoMultiEC.getIdentificadorEstabelecimento(), 14, ' ', 4));
                        buffer.append(StringUtil.completaString(String.valueOf(estabelecimentoMultiEC.getDescricao().length()), 2, '0', 3));
                        buffer.append(estabelecimentoMultiEC.getDescricao());
                    }
                    jsonObject.addProperty("dadosAdicionais", buffer.toString());
                } else {
                    jsonObject.addProperty("dadosAdicionais", "");
                }
            }
            if (saida.getCodigoRetorno() == 0 && this.entrada.getOperacao() != OperationEnum.OP_CONFIRMACAO.getKey().intValue() && this.entrada.getOperacao() != OperationEnum.OP_DESFAZIMENTO.getKey().intValue() && this.entrada.getOperacao() != OperationEnum.OP_DESFAZIMENTO_TODAS_TRANS.getKey().intValue()) {
                JsonArray cupomReduzido;
                JsonArray cupomCliente;
                JsonArray cupomEstab = CupomUtil.getCupom("CUPOMCTF.2", this.entrada);
                if (cupomEstab != null) {
                    jsonObject.add("cupomEstabelecimento", cupomEstab);
                }
                if ((cupomCliente = CupomUtil.getCupom("CUPOMCTF.1", this.entrada)) != null) {
                    jsonObject.add("cupomCliente", cupomCliente);
                }
                if ((cupomReduzido = CupomUtil.getCupom("REDUZIDO.1", this.entrada)) != null) {
                    jsonObject.add("cupomReduzido", cupomReduzido);
                }
            }
            if (null != saida.getSplitPagamentoPaymentID() || null != saida.getSplitPagamentoMktTransactionID()) {
                this.setPaymentSplitData(saida, jsonObject);
            }
            if (saida.getPixTransactionId() != null && saida.getPixReceiverPSP() != null) {
                this.setPixData(saida, jsonObject);
            }
            return jsonObject;
        }

        private void setPixData(SaidaCTFClient saida, JsonObject jsonObject) {
            JsonObject pixData = new JsonObject();
            if (saida.getPixTransactionId() != null) {
                pixData.addProperty("transactionId", saida.getPixTransactionId());
            }
            if (saida.getPixReceiverPSP() != null) {
                pixData.addProperty("receiverPSP", saida.getPixReceiverPSP());
            }
            jsonObject.add("pix", pixData);
        }

        private void setPaymentSplitData(SaidaCTFClient saida, JsonObject jsonObject) {
            JsonObject splitPagamentoData = new JsonObject();
            if (null != saida.getSplitPagamentoMktTransactionID()) {
                splitPagamentoData.addProperty("marketplaceTransactionId", saida.getSplitPagamentoMktTransactionID());
            }
            if (null != saida.getSplitPagamentoPaymentID()) {
                splitPagamentoData.addProperty("paymentId", saida.getSplitPagamentoPaymentID());
            }
            jsonObject.add("splitPagamento", splitPagamentoData);
        }

        private boolean isNotNull(String valor) {
            return !StringUtil.isEmpty(valor) && valor.trim().length() > 0;
        }
    }

    static class EntradaTypeAdapter
    implements JsonDeserializer<EntradaCTFClient> {
        EntradaTypeAdapter() {
        }

        @Override
        public EntradaCTFClient deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            EntradaCTFClient entrada = new EntradaCTFClient();
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                if (this.isNotNull(jsonObject, "documento")) {
                    entrada.setNumeroCupom(jsonObject.get("documento").getAsString());
                }
                if (jsonObject.has("operacao")) {
                    entrada.setOperacao(jsonObject.get("operacao").getAsInt());
                }
                if (this.isNotNull(jsonObject, "numeroTransacao")) {
                    entrada.setNumeroTransacao(jsonObject.get("numeroTransacao").getAsInt());
                }
                if (this.isNotNull(jsonObject, "valorTransacao")) {
                    entrada.setValorTransacao(jsonObject.get("valorTransacao").getAsBigDecimal().movePointLeft(2));
                }
                if (this.isNotNull(jsonObject, "numeroParcelas")) {
                    entrada.setNumeroParcelas(jsonObject.get("numeroParcelas").getAsInt());
                }
                if (this.isNotNull(jsonObject, "nsuCTF")) {
                    entrada.setNsuCTF(jsonObject.get("nsuCTF").getAsInt());
                }
                if (this.isNotNull(jsonObject, "dataTransacao")) {
                    SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
                    try {
                        Date dataTransacao = df.parse(jsonObject.get("dataTransacao").getAsString());
                        entrada.setDataReferencia(dataTransacao);
                    }
                    catch (Exception e) {
                        logger.warn("Falha ao definir a data da transa\u00e7\u00e3o. " + e.getMessage());
                    }
                }
                if (this.isNotNull(jsonObject, "identificadorMultiEC")) {
                    entrada.setIdentificadorMultiEC(jsonObject.get("identificadorMultiEC").getAsString());
                }
                if (this.isNotNull(jsonObject, "consulta")) {
                    entrada.setConsulta(jsonObject.get("consulta").getAsInt() == 1);
                }
                if (this.isNotNull(jsonObject, "identConsulta")) {
                    entrada.setIdentConsulta(jsonObject.get("identConsulta").getAsLong());
                }
                if (this.isNotNull(jsonObject, "codigoTabela")) {
                    entrada.setCodigoTabela(jsonObject.get("codigoTabela").getAsInt());
                }
                if (jsonObject.has("splitPagamento")) {
                    this.getPaymentSplitData(entrada, jsonObject);
                }
                if (jsonObject.has("pix")) {
                    this.getPixData(entrada, jsonObject);
                }
                if (jsonObject.has("formasPagamentoValor")) {
                    entrada.setFormasPagamentoValor(this.getPaymentTypeValueData(jsonObject));
                }
            }
            return entrada;
        }

        private void getPaymentSplitData(EntradaCTFClient entrada, JsonObject jsonObject) {
            JsonObject splitPagamentoData = jsonObject.getAsJsonObject("splitPagamento");
            if (this.isNotNull(splitPagamentoData, "idSeller")) {
                entrada.setProdutoSplitPagamentoSellerId(splitPagamentoData.get("idSeller").getAsString());
            }
            if (this.isNotNull(splitPagamentoData, "idOrder")) {
                entrada.setOrderId(splitPagamentoData.get("idOrder").getAsString());
            }
            if (splitPagamentoData.has("produtos")) {
                entrada.setProdutosSplitPagamento(this.getPaymentSplitProducts(splitPagamentoData));
            }
        }

        private void getPixData(EntradaCTFClient entrada, JsonObject jsonObject) {
            JsonObject pixData = jsonObject.getAsJsonObject("pix");
            if (this.isNotNull(pixData, "transactionId")) {
                entrada.setPixTransactionId(pixData.get("transactionId").getAsString());
            }
            if (this.isNotNull(pixData, "receiverPSP")) {
                entrada.setPixReceiverPSP(pixData.get("receiverPSP").getAsString());
            }
        }

        private List<FormaPagamentoValor> getPaymentTypeValueData(JsonObject jsonObject) {
            ArrayList<FormaPagamentoValor> formasPagamentoValor = new ArrayList<FormaPagamentoValor>();
            JsonArray formasPagamentoValorJa = jsonObject.getAsJsonArray("formasPagamentoValor");
            for (JsonElement formaPagamentoValorJe : formasPagamentoValorJa) {
                FormaPagamentoValor formaPagamentoValor = new FormaPagamentoValor();
                JsonObject formaPagamentoValorJo = formaPagamentoValorJe.getAsJsonObject();
                if (this.isNotNull(formaPagamentoValorJo, "tipo")) {
                    formaPagamentoValor.setTipo(formaPagamentoValorJo.get("tipo").getAsInt());
                }
                if (this.isNotNull(formaPagamentoValorJo, "valor")) {
                    formaPagamentoValor.setValor(formaPagamentoValorJo.get("valor").getAsBigDecimal().movePointLeft(2));
                }
                formasPagamentoValor.add(formaPagamentoValor);
            }
            return formasPagamentoValor;
        }

        private List<ProdutoSplitPagamento> getPaymentSplitProducts(JsonObject splitPagamentoData) {
            ArrayList<ProdutoSplitPagamento> paymentSplitProducts = new ArrayList<ProdutoSplitPagamento>();
            JsonArray productsJsonArray = splitPagamentoData.getAsJsonArray("produtos");
            for (JsonElement productElement : productsJsonArray) {
                ProdutoSplitPagamento paymentSplitProduct = new ProdutoSplitPagamento();
                JsonObject productObject = productElement.getAsJsonObject();
                if (this.isNotNull(productObject, "tipo")) {
                    paymentSplitProduct.setTipoIdentificacao(productObject.get("tipo").getAsInt());
                }
                if (this.isNotNull(productObject, "codigoProduto")) {
                    paymentSplitProduct.setCodigo(productObject.get("codigoProduto").getAsString());
                }
                if (this.isNotNull(productObject, "quantidade")) {
                    paymentSplitProduct.setQuantidade(productObject.get("quantidade").getAsInt());
                }
                if (this.isNotNull(productObject, "valor")) {
                    paymentSplitProduct.setValorUnitario(productObject.get("valor").getAsBigDecimal());
                }
                if (this.isNotNull(productObject, "nomeProduto")) {
                    paymentSplitProduct.setNome(productObject.get("nomeProduto").getAsString());
                }
                if (this.isNotNull(productObject, "idSubSeller")) {
                    paymentSplitProduct.setIdSubseller(productObject.get("idSubSeller").getAsString());
                }
                if (this.isNotNull(productObject, "percentualTaxa")) {
                    paymentSplitProduct.setPorcentagemTaxa(productObject.get("percentualTaxa").getAsBigDecimal());
                }
                if (this.isNotNull(productObject, "valorTaxa")) {
                    paymentSplitProduct.setValorTaxa(productObject.get("valorTaxa").getAsBigDecimal());
                }
                paymentSplitProducts.add(paymentSplitProduct);
            }
            return paymentSplitProducts;
        }

        private boolean isNotNull(JsonObject jsonObject, String parametro) {
            return jsonObject.has(parametro) && !"".equals(jsonObject.get(parametro).getAsString());
        }
    }

    static class CtfClientWebSocketServer
    extends WebSocketServer {
        public CtfClientWebSocketServer(int port, Draft d) {
            super(new InetSocketAddress(port), Collections.singletonList(d));
        }

        @Override
        public void onClose(WebSocket webSocket, int code, String reason, boolean remote) {
        }

        @Override
        public void onError(WebSocket webSocket, Exception ex) {
        }

        @Override
        public void onMessage(WebSocket webSocket, String message) {
            try {
                logger.debug("request: " + message);
                GsonBuilder gsonBuilder = new GsonBuilder();
                gsonBuilder.registerTypeAdapter((Type)((Object)EntradaCTFClient.class), new EntradaTypeAdapter());
                Gson gson = gsonBuilder.create();
                EntradaCTFClient entrada = gson.fromJson(message, EntradaCTFClient.class);
                entrada.setDataAbertura(new Date());
                if (entrada.getNumeroTransacao() == 0) {
                    entrada.setNumeroTransacao(1);
                }
                ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
                IdentTerminal identTerminal = new IdentTerminal();
                identTerminal.setEstabelecimento(confCTFClient.getEstabelecimento());
                identTerminal.setLoja(confCTFClient.getLoja());
                identTerminal.setTerminal(confCTFClient.getTerminal());
                SaidaCTFClient saida = entrada.isConsulta() ? CTFClient.getInstancia().efetuarConsulta(identTerminal, entrada) : (entrada.getIdentConsulta() > 0L ? CTFClient.getInstancia().efetuarTransacao(identTerminal, entrada, entrada.getIdentConsulta()) : CTFClient.getInstancia().efetuarTransacao(identTerminal, entrada));
                gsonBuilder.registerTypeAdapter((Type)((Object)SaidaCTFClient.class), new SaidaTypeAdapter(entrada));
                gson = gsonBuilder.create();
                String resp = gson.toJson(saida);
                logger.debug("respose: " + resp);
                webSocket.send(resp);
                webSocket.close();
            }
            catch (Exception e) {
                logger.error("nao foi possivel processar a requisicao.", (Throwable)e);
            }
        }

        @Override
        public void onOpen(WebSocket webSocket, ClientHandshake handshake) {
            Iterator<String> iterator = handshake.iterateHttpFields();
            while (iterator.hasNext()) {
                String obj = iterator.next();
                logger.debug(obj + " : " + handshake.getFieldValue(obj));
            }
        }
    }
}

