/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.websocket;

import com.csi.ctfclient.integracao.GeneralConfigException;
import com.csi.ctfclient.integracao.GeneralConfigKeys;
import com.csi.ctfclient.integracao.websocket.WebSocketHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.java_websocket.server.DefaultSSLWebSocketServerFactory;

public class SSLWebSocketHandler
extends WebSocketHandler {
    public SSLWebSocketHandler(String strHost, String port) {
        super(strHost, port);
    }

    @Override
    protected void init() {
        SSLContext sslContext = null;
        try {
            String STORETYPE = "JKS";
            String KEYSTORE = "keystore.jks";
            String storePassword = this.getConfigValue(GeneralConfigKeys.STOREPASSWORD.name());
            String keyPassword = this.getConfigValue(GeneralConfigKeys.KEYPASSWORD.name());
            KeyStore ks = KeyStore.getInstance(STORETYPE);
            File kf = new File(KEYSTORE);
            ks.load(new FileInputStream(kf), storePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, keyPassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (FileNotFoundException e) {
            logger.error("keystore nao localizado: ", (Throwable)e);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            logger.error("erro: ", (Throwable)e);
        }
        catch (GeneralConfigException e) {
            logger.error("configura\u00e7\u00e3o geral n\u00e3o localizada: ", (Throwable)e);
        }
        this.getService().setWebSocketFactory(new DefaultSSLWebSocketServerFactory(sslContext));
        logger.info("SSContext inicializado para WebSocket");
    }
}

