/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.FormaPagamentoValor;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.domain.CampoLinha2Enum;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class FormaPagamentoValorParser {
    public static final int TAMANHO_BLOCO_FORMAS_PAGAMENTO_VALOR_STR = 14;
    private final EntradaCTFClient entrada;
    private final String bitFormasPagamentoValor;
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);

    public FormaPagamentoValorParser(EntradaCTFClient entrada) {
        this.entrada = entrada;
        this.bitFormasPagamentoValor = String.valueOf(CampoLinha2Enum.FORMAS_PAGAMENTO_VALOR.getPosLinha1());
    }

    public void parse(String formasPagamentoStr) throws Exception {
        ArrayList<FormaPagamentoValor> listaFormaPgtoValor = new ArrayList<FormaPagamentoValor>();
        if (formasPagamentoStr.length() % 14 != 0) {
            throw new SyntaxError(3, 3);
        }
        for (int i = 0; i < formasPagamentoStr.length() / 14; ++i) {
            String formaPagamentoValorStr = formasPagamentoStr.substring(i * 14, (i + 1) * 14);
            listaFormaPgtoValor.add(new FormaPagamentoValor(this.extraiTipo(formaPagamentoValorStr), this.extraiValor(formaPagamentoValorStr)));
        }
        this.entrada.setFormasPagamentoValor(listaFormaPgtoValor);
    }

    protected int extraiTipo(String formaPagamentoValorStr) throws SyntaxError {
        if (formaPagamentoValorStr.length() != 14) {
            throw new SyntaxError(3, 3);
        }
        try {
            return Integer.parseInt(formaPagamentoValorStr.substring(0, 2));
        }
        catch (NumberFormatException e) {
            logger.error("Erro na captura da forma de pagamento. Campo 'Tipo' possui um caracter inv\u00e1lido. Erro no bit= ".concat(this.bitFormasPagamentoValor));
            throw new SyntaxError(3, 3);
        }
        catch (Exception e) {
            logger.error("Erro no bit= ".concat(this.bitFormasPagamentoValor));
            logger.error(e.getMessage());
            throw e;
        }
    }

    protected BigDecimal extraiValor(String formaPagamentoValorStr) throws SyntaxError {
        if (formaPagamentoValorStr.length() != 14) {
            throw new SyntaxError(3, 3);
        }
        try {
            return new BigDecimal(formaPagamentoValorStr.substring(2, 14).trim()).movePointLeft(2);
        }
        catch (NumberFormatException e) {
            logger.error("Erro na captura do valor da forma de pagamento. Campo 'Valor' possui um caracter inv\u00e1lido. Erro no bit= ".concat(this.bitFormasPagamentoValor));
            throw new SyntaxError(3, 3);
        }
        catch (Exception e) {
            logger.error("Erro no bit= ".concat(this.bitFormasPagamentoValor));
            logger.error(e.getMessage());
            throw e;
        }
    }

    public static String serializa(List<FormaPagamentoValor> formasPagamentoValor) {
        StringBuilder result = new StringBuilder();
        for (FormaPagamentoValor fpv : formasPagamentoValor) {
            int valor = fpv.getValor().movePointRight(2).intValue();
            result.append(String.format("%04d%02d%012d", 14, fpv.getTipo(), valor));
        }
        return result.toString();
    }
}

