/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.integracao.domain.CampoLinha2Enum;
import com.csi.ctfclient.integracao.parser.CSILine2e3;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import java.util.LinkedHashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigParser {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private final IdentTerminal identTerminal;
    private final ConfCTFClient config;
    private final CSILine2e3 csiLine2e3;

    public ConfigParser(IdentTerminal identTerminal, ConfCTFClient config, CSILine2e3 csiLine2e3) {
        this.identTerminal = identTerminal;
        this.config = config;
        this.csiLine2e3 = csiLine2e3;
    }

    protected void parse(String linha2, String linha3) throws SyntaxError {
        this.config.setEstabelecimento(this.identTerminal.getEstabelecimento());
        this.config.setLoja(this.identTerminal.getLoja());
        this.config.setTerminal(this.identTerminal.getTerminal());
        this.fillPortClient(linha2, linha3);
        this.fillIps(linha2, linha3);
        this.fillTeclado(linha2, linha3);
        this.fillDisplayOperador(linha2, linha3);
        this.fillDisplayCliente(linha2, linha3);
        this.fillLeitorCartao(linha2, linha3);
        this.fillParamsLeitorCartao(linha2, linha3);
        this.fillPinPad(linha2, linha3);
        this.fillParamsPinPad(linha2, linha3);
        this.fillScanner(linha2, linha3);
        this.fillLeitorDocumento(linha2, linha3);
        this.fillIntegracaoCriptografada(linha2, linha3);
    }

    protected void fillPortClient(String linha2, String linha3) {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_PORT_CLIENT, linha2)) {
            String hostClient = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_PORT_CLIENT);
            this.config.setHostClient(hostClient);
            hostClient = Integer.valueOf(linha3.substring(this.csiLine2e3.getPosLinha3(), this.csiLine2e3.getPosLinha3() + 5)).toString();
            this.config.setPortClient(hostClient);
            this.csiLine2e3.somaPosicaoLinha3(5);
        }
    }

    protected void fillIps(String linha2, String linha3) throws SyntaxError {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_IPS, linha2)) {
            if (this.getTTTMSGP(linha3) != 0) {
                this.csiLine2e3.somaPosicaoLinha3(3);
            }
            try {
                LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                int colCollection = this.csiLine2e3.getPosLinha3();
                int offset = 0;
                while (!linha3.substring(colCollection, colCollection + 2).equals("00")) {
                    offset = Integer.parseInt(linha3.substring(colCollection, colCollection + 2));
                    String ip = linha3.substring(colCollection += 2, offset + colCollection);
                    String porta = Integer.valueOf(linha3.substring(colCollection += offset, colCollection + 5)).toString();
                    String protocolo = linha3.substring(colCollection += 5, colCollection + 4).trim();
                    colCollection += 4;
                    ips.add(new ServicoCTF(new Host(ip), porta, protocolo));
                }
                this.config.setIps(ips);
                this.csiLine2e3.somaPosicaoLinha3((colCollection += 2) - this.csiLine2e3.getPosLinha3());
            }
            catch (ExcecaoParametroInvalido e) {
                logger.error("Campo ips da terceira linha cont\u00e9m host's ou ip's inv\u00e1lidos");
                throw new SyntaxError(3, 3);
            }
        }
    }

    protected void fillTeclado(String linha2, String linha3) throws SyntaxError {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_TECLADO, linha2)) {
            ConfPeriferico teclado;
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_TECLADO);
            if (dadoString.equalsIgnoreCase("TECLADO_PC")) {
                teclado = new ConfPeriferico("TECLADO_PC");
            } else if (dadoString.equalsIgnoreCase("TECLADO_JAVAPOS")) {
                teclado = new ConfPeriferico("TECLADO_JAVAPOS");
            } else {
                logger.error("Constante para sele\u00e7\u00e3o do driver de teclado n\u00e3o encontrada");
                throw new SyntaxError(3, 3);
            }
            if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_TECLADO_PARAMS, linha2)) {
                dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_TECLADO_PARAMS);
                teclado.setParametros(dadoString.split(","));
            }
            this.config.setTeclado(teclado);
        } else if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_TECLADO_PARAMS, linha2)) {
            this.pulaColunaLinha3(linha3, CampoLinha2Enum.CONFIG_TECLADO_PARAMS);
        }
    }

    protected void fillDisplayOperador(String linha2, String linha3) throws SyntaxError {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_DISPLAY_OPERATOR, linha2)) {
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_DISPLAY_OPERATOR);
            if (!(dadoString.equalsIgnoreCase("DISPLAY_CTFCLIENT") || dadoString.equalsIgnoreCase("DISPLAY_JAVAPOS") || dadoString.equalsIgnoreCase("DISPLAY_AUTTAR") || dadoString.equalsIgnoreCase("DISPLAY_CSI"))) {
                logger.error("Constante para sele\u00e7\u00e3o do driver de display do operador n\u00e3o encontrada");
                throw new SyntaxError(3, 3);
            }
            ConfPeriferico displayOperador = new ConfPeriferico(dadoString);
            if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_DISPLAY_OPERATOR_PARAMS, linha2)) {
                dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_DISPLAY_OPERATOR_PARAMS);
                displayOperador.setParametros(dadoString.split(","));
            }
        } else if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_DISPLAY_OPERATOR_PARAMS, linha2)) {
            this.pulaColunaLinha3(linha3, CampoLinha2Enum.CONFIG_DISPLAY_OPERATOR_PARAMS);
        }
    }

    protected void fillDisplayCliente(String linha2, String linha3) throws SyntaxError {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_DISPLAY_CLIENTE, linha2)) {
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_DISPLAY_CLIENTE);
            if (!(dadoString.equalsIgnoreCase("DISPLAY_CTFCLIENT") || dadoString.equalsIgnoreCase("DISPLAY_JAVAPOS") || dadoString.equalsIgnoreCase("DISPLAY_AUTTAR"))) {
                logger.error("Constante para sele\u00e7\u00e3o do driver de display do cliente n\u00e3o encontrada");
                throw new SyntaxError(3, 3);
            }
            ConfPeriferico displayCliente = new ConfPeriferico(dadoString);
            if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_DISPLAY_CLIENTE_PARAMS, linha2)) {
                dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_DISPLAY_CLIENTE_PARAMS).trim();
                displayCliente.setParametros(dadoString.split(","));
            }
            this.config.setDisplayCliente(displayCliente);
        } else if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_DISPLAY_CLIENTE_PARAMS, linha2)) {
            this.pulaColunaLinha3(linha3, CampoLinha2Enum.CONFIG_DISPLAY_CLIENTE_PARAMS);
        }
    }

    protected void fillLeitorCartao(String linha2, String linha3) throws SyntaxError {
        String dadoString;
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_LEITOR_CARTAO, linha2) && !(dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_LEITOR_CARTAO)).equalsIgnoreCase("LEITOR_CARTAO_BIB_COMPARTILHADA")) {
            logger.error("Constante para sele\u00e7\u00e3o do driver de leitor do cart\u00e3o n\u00e3o encontrada");
            throw new SyntaxError(3, 3);
        }
    }

    protected void fillParamsLeitorCartao(String linha2, String linha3) {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_LEITOR_CARTAO_PARAMS, linha2)) {
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_LEITOR_CARTAO_PARAMS);
            ConfPeriferico configLeitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
            String[] listaParametrosTemp = dadoString.split(",");
            String[] listaParametros = this.removeSpacesArray(listaParametrosTemp);
            configLeitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
            configLeitorCartao.setParametros(listaParametros);
            this.config.setLeitorCartao(configLeitorCartao);
        }
    }

    protected void fillPinPad(String linha2, String linha3) throws SyntaxError {
        String dadoString;
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_PINPAD, linha2) && !(dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_PINPAD).trim()).equalsIgnoreCase("PINPAD_BIB_COMPARTILHADA")) {
            logger.error("Constante para sele\u00e7\u00e3o do driver de pinpad n\u00e3o encontrada");
            throw new SyntaxError(3, 3);
        }
    }

    protected void fillParamsPinPad(String linha2, String linha3) {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_PINPAD_PARAMS, linha2)) {
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_PINPAD_PARAMS);
            ConfPeriferico configPinPad = new ConfPeriferico("PARAMS_PINPAD");
            configPinPad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
            String[] listaParametrosTemp = dadoString.split(",");
            String[] listaParametros = this.removeSpacesArray(listaParametrosTemp);
            configPinPad.setParametros(listaParametros);
            this.config.setPinPad(configPinPad);
        }
    }

    protected void fillScanner(String linha2, String linha3) throws SyntaxError {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_SCANNER, linha2)) {
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_SCANNER).trim();
            if (!dadoString.equalsIgnoreCase("SCANNER_SERIAL") && !dadoString.equalsIgnoreCase("SCANNER_JAVAPOS")) {
                logger.error("Constante para sele\u00e7\u00e3o do driver de scanner n\u00e3o encontrada");
                throw new SyntaxError(3, 3);
            }
            ConfPeriferico scanner = new ConfPeriferico(dadoString);
            if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_SCANNER_PARAMS, linha2)) {
                dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_SCANNER_PARAMS);
                scanner.setParametros(dadoString.split(","));
            }
            this.config.setScanner(scanner);
        } else if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_SCANNER_PARAMS, linha2)) {
            this.pulaColunaLinha3(linha3, CampoLinha2Enum.CONFIG_SCANNER_PARAMS);
        }
    }

    protected void fillLeitorDocumento(String linha2, String linha3) throws SyntaxError {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_LEITOR_DOCUMENTO, linha2)) {
            String dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_LEITOR_DOCUMENTO);
            if (!(dadoString.equalsIgnoreCase("LEITOR_DOCUMENTO_CHRONOS") || dadoString.equalsIgnoreCase("LEITOR_DOCUMENTO_LOGGER2") || dadoString.equalsIgnoreCase("LEITOR_DOCUMENTO_TECPOINTTL840"))) {
                logger.error("Constante para sele\u00e7\u00e3o do driver de leitor de documento n\u00e3o encontrada");
                throw new SyntaxError(3, 3);
            }
            ConfPeriferico leitorDocumento = new ConfPeriferico(dadoString);
            if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_LEITOR_DOCUMENTO_PARAMS, linha2)) {
                dadoString = this.csiLine2e3.capturaString(linha2, linha3, CampoLinha2Enum.CONFIG_LEITOR_DOCUMENTO_PARAMS).trim();
                leitorDocumento.setParametros(dadoString.split(","));
            }
            this.config.setLeitorDocumento(leitorDocumento);
        } else if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_LEITOR_DOCUMENTO_PARAMS, linha2)) {
            this.pulaColunaLinha3(linha3, CampoLinha2Enum.CONFIG_LEITOR_DOCUMENTO_PARAMS);
        }
    }

    protected void fillIntegracaoCriptografada(String linha2, String linha3) {
        if (this.csiLine2e3.isBitLinha2Ativo(CampoLinha2Enum.CONFIG_INTEGRACAO_CRIPTOGRAFADA, linha2)) {
            this.config.setIntegracaoCriptografada(this.csiLine2e3.capturaBoolean(linha2, linha3, CampoLinha2Enum.CONFIG_INTEGRACAO_CRIPTOGRAFADA));
        }
    }

    private int getTTTMSGP(String linha3) {
        return Integer.parseInt(linha3.substring(this.csiLine2e3.getPosLinha3(), this.csiLine2e3.getPosLinha3() + 3));
    }

    private void pulaColunaLinha3(String linha, CampoLinha2Enum campoLinha2Enum) {
        int tam = campoLinha2Enum.getTamanho();
        if (tam >= 0) {
            throw new IllegalArgumentException("O m\u00e9todo apenas poder\u00e1 ser usado para colunas de tamanho vari\u00e1vel");
        }
        int tamVar = Math.abs(tam);
        String tamStr = linha.substring(this.csiLine2e3.getPosLinha3(), this.csiLine2e3.getPosLinha3() + tamVar);
        tam = Integer.parseInt(tamStr);
        this.csiLine2e3.somaPosicaoLinha3(tamVar);
        this.csiLine2e3.somaPosicaoLinha3(tam);
    }

    private String[] removeSpacesArray(String[] arrayOrigem) {
        String[] listaParametros = new String[arrayOrigem.length];
        for (int i = 0; i < arrayOrigem.length; ++i) {
            if (arrayOrigem[i] == null) continue;
            listaParametros[i] = arrayOrigem[i].trim();
        }
        return listaParametros;
    }
}

