/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao.parser;

import br.com.auttar.model.constants.OperationEnum;
import com.csi.ctfclient.apitef.model.ProdutoPromocional;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.integracao.SyntaxError;
import com.csi.ctfclient.servicos.CTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClient;
import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bit62Parser {
    private static final Logger logger = LogManager.getLogger(CTFClient.class);
    private final EntradaCTFClient entrada;
    private int posLinha3;

    public Bit62Parser(EntradaCTFClient entrada) {
        this.entrada = entrada;
    }

    public void parse(String dadoString) throws SyntaxError {
        int operacao = this.entrada.getOperacao();
        if (operacao == OperationEnum.OP_CONSULTA_VALORES_CREDITO_DIGITAL.getKey() || operacao == OperationEnum.OP_COMPRA_CREDITO_DIGITAL.getKey()) {
            this.posLinha3 = 0;
            this.fillCodigoOperadoraTelefonia(dadoString);
            int versaoLayoutCD = this.getVersaoLayoutCD();
            if (versaoLayoutCD == 1 || versaoLayoutCD == 2) {
                this.fillDDDTelefoneLayoutCd10ValoresFixosOrLayoutCdQtdeVariavelValoresFixos(dadoString);
            } else if (versaoLayoutCD == 3) {
                this.fillDDDTelefoneLayoutCdQtdeVariavelValoresVariaveis(dadoString);
            }
            this.fillDigitoVerificadorTelefone(dadoString);
            this.fillCodigoUsuarioPdv(dadoString);
            this.fillTipoCreditoCompra(dadoString);
        } else if (operacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO_COM_CONSULTA.getKey() || operacao == OperationEnum.OP_PGTO_FICHA_COMPENSACAO.getKey() || operacao == OperationEnum.OP_PGTO_CONVENIO_COM_CONSULTA.getKey() || operacao == OperationEnum.OP_PGTO_CONVENIO.getKey() || operacao == OperationEnum.OP_CONSULTA_FICHA_COMPENSACAO.getKey() || operacao == OperationEnum.OP_CONSULTA_CONVENIO.getKey()) {
            boolean modoEntradaSetado = this.fillModoEntradaCodigoBarras(dadoString);
            this.fillCodigoBarras(dadoString, modoEntradaSetado);
            this.fillFormaPagamentoContas(dadoString);
            this.fillCmc7(dadoString);
        } else if (operacao == OperationEnum.OP_CONSULTA_CHEQUE.getKey()) {
            this.fillDDDTelefoneOperacaoConsultaCheque(dadoString);
        } else if (operacao == OperationEnum.OP_CONSULTA_ANALITICA_SPC.getKey()) {
            this.fillCodigoCliente(dadoString);
            this.fillTipoConsultaSpc(dadoString);
            this.fillCodigoUsuarioPdv2(dadoString);
            this.fillNomeCliente(dadoString);
            this.fillDataNascimentoCliente(dadoString);
        } else if (operacao == OperationEnum.OP_CARGA_PRODUTOS_PROMOCIONAIS.getKey()) {
            this.fillTimestampProdutosPromocionais(dadoString);
        } else if (operacao == OperationEnum.OP_DESCONTO_PRODUTOS_PROMOCIONAIS.getKey()) {
            this.fillListProdutosPromocionais(dadoString);
        } else {
            this.entrada.setInfoAdicionais(dadoString);
        }
    }

    protected void fillCodigoOperadoraTelefonia(String dadoString) {
        int tamCampo = 2;
        String operadoraTelefonia = dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo);
        if (operadoraTelefonia.trim().length() > 0) {
            this.entrada.setCodigoOperadoraTelefonia(operadoraTelefonia);
        }
        this.posLinha3 += tamCampo;
    }

    protected void fillDDDTelefoneLayoutCd10ValoresFixosOrLayoutCdQtdeVariavelValoresFixos(String dadoString) throws SyntaxError {
        int tamCampo = 3;
        boolean dddSetado = false;
        boolean telefoneSetado = false;
        String ddd = dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo);
        if (!ddd.trim().equals("") && !ddd.equals("000")) {
            this.entrada.setDdd(ddd.trim());
            dddSetado = true;
        }
        this.posLinha3 += tamCampo;
        tamCampo = 8;
        String telefone = dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo);
        if (!telefone.trim().equals("") && !telefone.equals("00000000")) {
            this.entrada.setTelefone(telefone.trim());
            telefoneSetado = true;
        }
        this.posLinha3 += tamCampo;
        this.validaDddETelefone(dddSetado, telefoneSetado);
    }

    protected void fillDDDTelefoneLayoutCdQtdeVariavelValoresVariaveis(String dadoString) throws SyntaxError {
        String telefone;
        String ddd;
        int tamCampo = 2;
        boolean dddSetado = false;
        boolean telefoneSetado = false;
        int tamDdd = Integer.parseInt(dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo));
        this.posLinha3 += tamCampo;
        if (tamDdd > 0 && !(ddd = dadoString.substring(this.posLinha3, this.posLinha3 + tamDdd)).trim().equals("") && !ddd.equals(StringUtil.completaString("", tamDdd, '0', 3))) {
            this.entrada.setDdd(ddd.trim());
            dddSetado = true;
        }
        this.posLinha3 += tamDdd;
        tamCampo = 2;
        int tamTelefone = Integer.parseInt(dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo));
        this.posLinha3 += tamCampo;
        if (tamTelefone > 0 && !(telefone = dadoString.substring(this.posLinha3, this.posLinha3 + tamTelefone)).trim().equals("") && !telefone.equals(StringUtil.completaString("", tamTelefone, '0', 3))) {
            this.entrada.setTelefone(telefone.trim());
            telefoneSetado = true;
        }
        this.posLinha3 += tamTelefone;
        this.validaDddETelefone(dddSetado, telefoneSetado);
    }

    private void validaDddETelefone(boolean dddSetado, boolean telefoneSetado) throws SyntaxError {
        boolean ambosNaoSetados;
        boolean ambosSetados = dddSetado && telefoneSetado;
        boolean bl = ambosNaoSetados = !dddSetado && !telefoneSetado;
        if (!ambosSetados && !ambosNaoSetados) {
            logger.error("O ddd e o telefone devem ser informados juntos, ou nenhum deles deve ser informado");
            throw new SyntaxError(3, 3);
        }
    }

    protected void fillDigitoVerificadorTelefone(String dadoString) {
        int tamCampo = 2;
        String digVerificador = dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo);
        if (!digVerificador.trim().equals("") && Integer.parseInt(digVerificador.trim()) != 0) {
            this.entrada.setDigitoVerificadorTelefone(Integer.parseInt(digVerificador.trim()));
        }
        this.posLinha3 += tamCampo;
    }

    protected void fillCodigoUsuarioPdv(String dadoString) {
        int tamCampo = 10;
        String codUsuarioPdv = dadoString.substring(this.posLinha3, this.posLinha3 + tamCampo);
        if (!codUsuarioPdv.trim().equals("")) {
            this.entrada.setCodigoUsuarioPdv(codUsuarioPdv.trim());
        }
        this.posLinha3 += tamCampo;
    }

    protected void fillTipoCreditoCompra(String dadoString) {
        String tipoCreditoCompra = dadoString.substring(this.posLinha3, this.posLinha3 + 2);
        if (!tipoCreditoCompra.trim().equals("")) {
            this.entrada.setTipoCreditoCompra(Integer.parseInt(tipoCreditoCompra.trim()));
        }
    }

    protected boolean fillModoEntradaCodigoBarras(String dadoString) {
        int modoEntrada = Integer.parseInt(dadoString.substring(0, 1));
        if (modoEntrada > 0) {
            this.entrada.setModoEntradaCodigoBarras(modoEntrada);
            return true;
        }
        return false;
    }

    protected void fillCodigoBarras(String dadoString, boolean modoEntradaSetado) throws SyntaxError {
        BigDecimal codigoBarras = new BigDecimal(dadoString.substring(1, 49));
        if (codigoBarras.compareTo(BigDecimal.ZERO) > 0) {
            if (modoEntradaSetado) {
                this.entrada.setCodigoBarras(String.valueOf(codigoBarras));
            } else {
                logger.warn("C\u00f3digo de barras informado, mas modo de entrada nulo");
                throw new SyntaxError(3, 1, "CODIGO DE BARRAS INFORMADO, MAS MODO DE ENTRADA NULO");
            }
        }
    }

    protected void fillFormaPagamentoContas(String dadoString) {
        int modalidadePagamento = Integer.parseInt(dadoString.substring(49, 51));
        if (modalidadePagamento > 0) {
            this.entrada.setFormaPagamentoContas(modalidadePagamento);
        }
    }

    protected void fillCmc7(String dadoString) {
        String cmc7 = dadoString.substring(51, 85).trim();
        if (cmc7.length() > 0) {
            this.entrada.setCmc7(cmc7);
        }
    }

    protected void fillDDDTelefoneOperacaoConsultaCheque(String dadoString) throws SyntaxError {
        boolean dddSetado = this.fillDDDOperacaoConsultaCheque(dadoString);
        boolean telefoneSetado = this.fillTelefoneOperacaoConsultaCheque(dadoString);
        this.validaDddETelefone(dddSetado, telefoneSetado);
    }

    private boolean fillTelefoneOperacaoConsultaCheque(String dadoString) {
        boolean telefoneSetado = false;
        String telefone = dadoString.substring(11, 21);
        if (!telefone.trim().equals("") && !telefone.equals("0000000000")) {
            this.entrada.setTelefone(telefone.trim());
            telefoneSetado = true;
        }
        return telefoneSetado;
    }

    private boolean fillDDDOperacaoConsultaCheque(String dadoString) {
        String ddd = dadoString.substring(8, 11);
        if (!ddd.trim().equals("") && !ddd.equals("000")) {
            this.entrada.setDdd(ddd.trim());
            return true;
        }
        return false;
    }

    protected void fillCodigoCliente(String dadoString) {
        String codigoCliente = dadoString.substring(0, 15);
        if (codigoCliente.trim().length() > 0) {
            if (this.validaDadoNumerico(codigoCliente.trim())) {
                this.entrada.setCodigoCliente(Integer.parseInt(codigoCliente));
            } else {
                logger.error("Bit 62: C\u00f3digo do cliente n\u00e3o num\u00e9rico");
                throw new NumberFormatException();
            }
        }
    }

    protected void fillTipoConsultaSpc(String dadoString) {
        String tipoConsulta = dadoString.substring(15, 16);
        if (tipoConsulta.trim().length() > 0) {
            if (this.validaDadoNumerico(tipoConsulta)) {
                this.entrada.setTipoConsultaSpc(Integer.parseInt(tipoConsulta));
            } else {
                logger.error("Bit 62: Tipo da consulta n\u00e3o num\u00e9rico");
                throw new NumberFormatException();
            }
        }
    }

    protected void fillCodigoUsuarioPdv2(String dadoString) {
        String codigoUsuario = dadoString.substring(16, 26);
        if (!codigoUsuario.trim().equals("")) {
            if (this.validaDadoNumerico(codigoUsuario)) {
                this.entrada.setCodigoUsuarioPdv(codigoUsuario);
            } else {
                logger.error("Bit 62: C\u00f3digo do usu\u00e1rio n\u00e3o num\u00e9rico");
                throw new NumberFormatException();
            }
        }
    }

    protected void fillNomeCliente(String dadoString) {
        String nomeCliente = dadoString.substring(26, 66);
        if (nomeCliente.trim().length() > 0) {
            this.entrada.setNomeCliente(nomeCliente.trim());
        }
    }

    protected void fillDataNascimentoCliente(String dadoString) {
        String dataNascimento = dadoString.substring(66, 74);
        if (dataNascimento.trim().length() > 0) {
            try {
                this.entrada.setDataNascimentoCliente(new SimpleDateFormat("ddMMyyyy").parse(dataNascimento));
            }
            catch (ParseException e) {
                logger.error("Bit 62: Data inv\u00e1lida");
            }
        }
    }

    protected void fillTimestampProdutosPromocionais(String dadoString) {
        if (dadoString.length() < 14) {
            logger.error("Bit 62: Timestamp dos produtos promocionais n\u00e3o preenchido");
            throw new NumberFormatException();
        }
        String timestamp = dadoString.substring(0, 14);
        try {
            Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            logger.error("Bit 62: Timestamp dos produtos promocionais n\u00e3o num\u00e9rico");
            throw new NumberFormatException();
        }
        this.entrada.setTimestampProdutosPromocionais(timestamp);
    }

    protected void fillListProdutosPromocionais(String dadoString) {
        int tamanhoRegistro = 30;
        ArrayList<ProdutoPromocional> listProdutos = new ArrayList<ProdutoPromocional>();
        for (int i = 0; i < dadoString.length() / tamanhoRegistro; ++i) {
            int offset = i * tamanhoRegistro;
            String bufferProduto = dadoString.substring(offset, offset + 30);
            ProdutoPromocional produto = new ProdutoPromocional();
            produto.setCodigoEAN(bufferProduto.substring(0, 20));
            produto.setQuantidade(Integer.parseInt(bufferProduto.substring(20, 23)));
            produto.setValorProduto(new BigDecimal(bufferProduto.substring(23, 30)).movePointLeft(2));
            listProdutos.add(produto);
        }
        this.entrada.setListProdutosPromocionais(listProdutos);
    }

    protected int getVersaoLayoutCD() {
        int versaoLayoutCD = 1;
        try {
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            versaoLayoutCD = confCTFClient.getVersaoLayoutCD();
            if (versaoLayoutCD != 1 && versaoLayoutCD != 2 && versaoLayoutCD != 3) {
                versaoLayoutCD = 1;
            }
        }
        catch (ExcecaoApiAc e) {
            logger.error("Erro ao utlizar o arquivo de configura\u00e7\u00e3o. " + e.getMessage());
        }
        return versaoLayoutCD;
    }

    protected boolean validaDadoNumerico(String dado) {
        try {
            Integer.parseInt(dado);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public int getPosLinha3() {
        return this.posLinha3;
    }

    public void initPosLinha3(int posLinha3) {
        this.posLinha3 = posLinha3;
    }
}

