/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.integracao.InexistentTeminalException;
import com.csi.ctfclient.integracao.RunnableTimeOut;
import com.csi.ctfclient.integracao.Terminal;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTransacoes;
import com.csi.ctfclient.servicos.TerminalTransacoes;
import com.csi.ctfclient.tools.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TerminalManager {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(TerminalManager.class);
    private static TerminalManager terminalManager = null;
    private static List<Terminal> terminaisDisponiveis = null;
    private static List<Terminal> terminaisAtivos = null;
    private static Map<IdentTransacoes, TerminalTransacoes> aguardandoConfimacao = null;
    private static RunnableTimeOut runnableTimeOut = null;

    private TerminalManager() {
    }

    public static synchronized TerminalManager getInstance() {
        if (terminalManager == null) {
            terminalManager = new TerminalManager();
            ControladorConfCTFClient confCTFClient = null;
            try {
                confCTFClient = ControladorConfCTFClient.getInstance();
                if (confCTFClient.getConfig().isIntegracaoWeb()) {
                    logger.info("CTFClient configurado para realizar transa\u00e7\u00e3o com multiplos terminais.");
                    terminaisAtivos = new ArrayList<Terminal>();
                    terminaisDisponiveis = new ArrayList<Terminal>();
                    aguardandoConfimacao = new HashMap<IdentTransacoes, TerminalTransacoes>();
                    String range = confCTFClient.getConfig().getFilaTerminais();
                    String[] arrayRange = range.split(":");
                    int init = Integer.valueOf(arrayRange[0]);
                    int end = Integer.valueOf(arrayRange[1]);
                    logger.info("range de terminais configurado de -> " + init + " \u00e0 " + end);
                    String estab = confCTFClient.getConfig().getEstabelecimento();
                    String loja = confCTFClient.getConfig().getLoja();
                    for (int i = init; i <= end; ++i) {
                        String terminal = StringUtil.completaString(String.valueOf(i), 3, '0', 3);
                        terminaisDisponiveis.add(new Terminal(estab, loja, terminal));
                        logger.info("terminal " + terminal + " inicializado.");
                    }
                    terminaisAtivos = Collections.synchronizedList(terminaisAtivos);
                    terminaisDisponiveis = Collections.synchronizedList(terminaisDisponiveis);
                    aguardandoConfimacao = Collections.synchronizedMap(aguardandoConfimacao);
                    runnableTimeOut = new RunnableTimeOut(confCTFClient.getConfig().getTimeOutConfirmacao());
                    Thread t = new Thread(runnableTimeOut);
                    t.start();
                } else {
                    logger.error("CTFClient n\u00e3o foi configurado para realizar multiplas transa\u00e7\u00f5es");
                }
            }
            catch (Exception e) {
                logger.error("N\u00e3o foi poss\u00edvel recuperar o range de terminais permitidos");
            }
        }
        return terminalManager;
    }

    public synchronized Terminal getTerminalDisponivel() throws InexistentTeminalException {
        try {
            Terminal terminal = null;
            List<Terminal> list = terminaisDisponiveis;
            synchronized (list) {
                terminal = terminaisDisponiveis.remove(0);
                List<Terminal> list2 = terminaisAtivos;
                synchronized (list2) {
                    if (!terminaisAtivos.contains(terminal)) {
                        terminaisAtivos.add(terminal);
                        terminal.setStatus(1);
                        logger.info("terminal " + terminal + " configurado para n\u00e3o dispon\u00edvel.");
                        return terminal;
                    }
                    terminaisDisponiveis.add(terminal);
                    throw new InexistentTeminalException("terminal invalido. terminal ja disponivel na lista de ativos: " + terminal);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new InexistentTeminalException("n\u00e3o foi poss\u00edvel atender a solicita\u00e7\u00e3o por falta de terminal dispon\u00edvel.");
        }
    }

    public TerminalTransacoes getTerminalAtivo(IdentTransacoes key) throws InexistentTeminalException {
        return this.getTerminalAtivo(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalTransacoes getTerminalAtivo(IdentTransacoes key, boolean removerFilaConfirmacao) throws InexistentTeminalException {
        TerminalTransacoes terminalTransacoes = null;
        Map<IdentTransacoes, TerminalTransacoes> map = aguardandoConfimacao;
        synchronized (map) {
            terminalTransacoes = aguardandoConfimacao.get(key);
            if (terminalTransacoes != null) {
                if (removerFilaConfirmacao) {
                    terminalTransacoes.setNumeroTransacoes(terminalTransacoes.getNumeroTransacoes() - 1);
                    if (terminalTransacoes.getNumeroTransacoes() > 0) {
                        aguardandoConfimacao.put(key, terminalTransacoes);
                    } else {
                        aguardandoConfimacao.remove(key);
                    }
                }
            } else {
                throw new InexistentTeminalException("N\u00e3o foi encontrado terminal dispon\u00edvel: Estab:" + key.getIdentTerminal().getEstabelecimento() + ", Loja: " + key.getIdentTerminal().getLoja() + ", Fila: " + key.getIdentTerminal().getTerminal() + " para o nsu " + key.getNsu() + ".");
            }
        }
        return terminalTransacoes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void liberaTerminal(Terminal terminal) {
        boolean liberaOK = false;
        List<Terminal> list = terminaisAtivos;
        synchronized (list) {
            if (terminaisAtivos.contains(terminal)) {
                terminaisAtivos.remove(terminal);
                liberaOK = true;
                logger.info("terminal " + terminal + " removido da lista de ativos.");
            } else {
                logger.error("terminal nao encontrado na lista de ativos: " + terminal);
            }
        }
        if (liberaOK) {
            list = terminaisDisponiveis;
            synchronized (list) {
                if (!terminaisDisponiveis.contains(terminal)) {
                    terminaisDisponiveis.add(terminal);
                    terminal.setStatus(0);
                    logger.info("terminal " + terminal + " liberado para dispon\u00edvel.");
                } else {
                    logger.error("erro no gerenciamento dos terminais. terminal invalido na lista de disponiveis: " + terminal);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aguardandoConfirmacao(IdentTransacoes key, Terminal terminal) {
        Map<IdentTransacoes, TerminalTransacoes> map = aguardandoConfimacao;
        synchronized (map) {
            int numeroTransacoes;
            TerminalTransacoes terminalTransacoes = aguardandoConfimacao.get(key);
            if (terminalTransacoes == null) {
                terminalTransacoes = new TerminalTransacoes(terminal);
                numeroTransacoes = 1;
            } else {
                numeroTransacoes = terminalTransacoes.getNumeroTransacoes() + 1;
            }
            terminalTransacoes.setNumeroTransacoes(numeroTransacoes);
            aguardandoConfimacao.put(key, terminalTransacoes);
            terminal.setStatus(2);
            logger.info("terminal " + terminal + " entrando em estado de aguardando confirma\u00e7\u00e3o.");
        }
    }

    protected Map<IdentTransacoes, TerminalTransacoes> getAguardandoConfirmacao() {
        return aguardandoConfimacao;
    }
}

