/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.SocketHandler;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.communication.access.Conector;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoNaoEstabelecida;
import com.csi.ctfclient.tools.devices.Periferico;
import java.io.InputStream;
import java.io.OutputStream;

public class SocketGetData
implements Runnable {
    private final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(Periferico.class);
    private final Conector conexao;
    private final Object source;
    private InputStream inputStream;
    private OutputStream outputStream;

    private SocketGetData(Object source, Conector conexao) {
        this.source = source;
        this.conexao = conexao;
    }

    public static SocketGetData getInstance(Object source, Conector conexao) {
        return new SocketGetData(source, conexao);
    }

    @Override
    public void run() {
        try {
            try {
                this.inputStream = this.conexao.getFluxoEntrada();
                this.outputStream = this.conexao.getFluxoSaida();
            }
            catch (ExcecaoConexaoNaoEstabelecida e) {
                this.logger.error("Erro de conexao: " + e.getMessage());
                return;
            }
            ((SocketHandler)this.source).fireReadInputStream(this.inputStream, this.outputStream);
            try {
                this.conexao.fechaConexao();
            }
            catch (ExcecaoConexaoNaoEstabelecida e) {
                this.logger.error("Erro no fechamento da conexao: " + e.getMessage());
            }
        }
        catch (Throwable e) {
            this.logger.error(e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setTimeout(int timeout) {
        try {
            this.conexao.setTimeout(timeout);
        }
        catch (ExcecaoParametroInvalido e) {
            this.logger.error("Erro na definicao do timeout: " + e.getMessage());
        }
    }
}

