/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.integracao.TerminalManager;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.servicos.IdentTransacoes;
import com.csi.ctfclient.servicos.TerminalTransacoes;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class RunnableTimeOut
implements Runnable {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    TerminalManager terminalManager = null;
    long timeout = 0L;

    public RunnableTimeOut(int timeout) {
        this.timeout = timeout * 1000;
        this.terminalManager = TerminalManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info("controlador de timeout inicializado com valor = " + this.timeout / 1000L);
        while (true) {
            Map<IdentTransacoes, TerminalTransacoes> aguardandoConfirmacao = this.terminalManager.getAguardandoConfirmacao();
            Set<IdentTransacoes> terminais = aguardandoConfirmacao.keySet();
            ArrayList<IdentTransacoes> keys = new ArrayList<IdentTransacoes>();
            if (terminais != null && !terminais.isEmpty()) {
                Map<IdentTransacoes, TerminalTransacoes> map = aguardandoConfirmacao;
                synchronized (map) {
                    Date nowDate = new Date();
                    for (IdentTransacoes identTransacoes : terminais) {
                        TerminalTransacoes terminalTransacoes = aguardandoConfirmacao.get(identTransacoes);
                        if (nowDate.getTime() - terminalTransacoes.getTerminal().getTimeStamp().getTime() <= this.timeout) continue;
                        this.terminalManager.liberaTerminal(terminalTransacoes.getTerminal());
                        keys.add(identTransacoes);
                        logger.info("terminal " + terminalTransacoes.getTerminal().getTerminal() + " liberado por timeout.");
                    }
                    Map<IdentTransacoes, TerminalTransacoes> map2 = aguardandoConfirmacao;
                    synchronized (map2) {
                        for (IdentTransacoes identTransacoes : keys) {
                            aguardandoConfirmacao.remove(identTransacoes);
                        }
                    }
                }
            }
            try {
                Thread.sleep(this.timeout);
                continue;
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage());
                continue;
            }
            break;
        }
    }
}

