/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.httpserver.HttpServerManager;
import com.csi.ctfclient.integracao.ConfiguracaoException;
import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.HandlerManager;
import com.csi.ctfclient.servicos.CTFClient;
import java.lang.management.ManagementFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegradorMain {
    private static final Logger logger = LogManager.getLogger(IntegradorMain.class);
    private static final int HTTP_SERVER_PORT = 2580;

    public IntegradorMain() throws ExcecaoApiAc {
        try {
            logger.info("Java Version: " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor"));
            logger.info("Abrindo servidor CTFClient...");
            logger.info("PID " + ManagementFactory.getRuntimeMXBean().getName());
            try {
                logger.info("inicializando instancia do CTFClient...");
                CTFClient.getInstancia();
                logger.info("instancia do CTFClient inicializada.");
                ConfiguracaoIntegrador configuracao = ConfiguracaoIntegrador.newInstanceBuild();
                Handler handler = configuracao.getHandlerStream();
                handler.addHandlerListener(new HandlerManager(configuracao));
                handler.start();
            }
            catch (ExcecaoApiAc e) {
                e.printStackTrace();
                logger.error("Erro ao inicializar CTFClient.", (Throwable)e);
                System.exit(1);
            }
            try {
                logger.info("inicializando servidor HTTP");
                HttpServerManager.getInstance().start(2580);
                logger.info("HTTP Server inicializado");
            }
            catch (Exception e) {
                logger.error("Erro ao inicializar o HTTPServer: " + e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        catch (ConfiguracaoException e) {
            logger.error("Erro no arquivo de configuracao do Integrador", (Throwable)e);
            System.exit(1);
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            if (args[0].equalsIgnoreCase("-versao") || args[0].equalsIgnoreCase("/versao")) {
                IntegradorMain.exibeVersao();
            } else {
                IntegradorMain.exibeHelp();
            }
        } else {
            try {
                new IntegradorMain();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void exibeVersao() {
        IntegradorMain.exibeHeader();
        System.out.println("CTFClient versao      -> " + ControladorConfCTFClient.VERSAO_CLIENT);
        System.out.println("Certificacao Cielo    -> C0409");
        System.out.println("Certificacao Redecard -> C0138");
        System.out.println("");
    }

    private static void exibeHelp() {
        IntegradorMain.exibeHeader();
        System.out.println("Uso: java -jar CTFClient.jar <opcao>");
        System.out.println("  Onde <opcao> pode ser:");
        System.out.println("  -versao        Exibe a versao do CTFClient");
        System.out.println("");
    }

    private static void exibeHeader() {
        System.out.println("");
        System.out.println("Auttar - Processamento de Dados LTDA");
        System.out.println("");
    }
}

