/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.integracao.GeneralConfigException;
import com.csi.ctfclient.tools.util.CSILibErrorCode;
import com.csi.ctfclient.tools.util.CSISecurityJNA;
import com.csi.ctfclient.tools.util.ResourceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GeneralConfigHandler {
    private static GeneralConfigHandler instance;
    public static final int BUFF_SIZE = 5000;
    static final String FILENAME = "configCTFClientGeral.dat";
    static final String JAR_RESOURCE_PATH = "/META-INF/configCTFClientGeral.dat";
    private final CSISecurityJNA securityJNA;
    private static String fullFileName;
    private static String encryptedContent;
    protected static final Logger logger;

    public static GeneralConfigHandler getInstance() {
        if (instance == null) {
            instance = new GeneralConfigHandler();
        }
        return instance;
    }

    private GeneralConfigHandler() {
        this(CSISecurityJNA.getInstance());
    }

    private GeneralConfigHandler(CSISecurityJNA csiSecurityJNA) {
        this.securityJNA = csiSecurityJNA;
    }

    private String getConfigCTFClientGeralByStream() {
        URL urlResourceJar = ResourceUtil.fetchURL(JAR_RESOURCE_PATH);
        if (urlResourceJar != null) {
            logger.debug("getConfigCTFClientGeralByStream - res.protocolo={}", (Object)urlResourceJar.getProtocol());
            InputStream in = ResourceUtil.fetchStream(JAR_RESOURCE_PATH);
            logger.debug("getConfigCTFClientGeralByStream - stream OK={}", (Object)(in != null ? 1 : 0));
            if (in != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                return reader.lines().collect(Collectors.joining());
            }
        }
        return null;
    }

    private String getFileContent(String keyWord) throws GeneralConfigException {
        byte[] content = new byte[5000];
        if (encryptedContent == null && (encryptedContent = this.getConfigCTFClientGeralByStream()) == null) {
            File file = new File(this.getFullFilename());
            logger.warn("Procurando o configCTFClientGeral.dat no CTFCLIENT_HOME ou na pasta atual");
            try {
                encryptedContent = FileUtils.readFileToString(file, "UTF-8").trim();
            }
            catch (IOException e) {
                throw new GeneralConfigException("Falha na leitura do arquivo de configura\u00e7\u00f5es gerais", e);
            }
        }
        int rtn = this.securityJNA.getBuffDecrypted(encryptedContent, content, 16, keyWord);
        logger.debug("Retorno da leitura de buffer={}", (Object)rtn);
        if (rtn >= 0) {
            return new String(content);
        }
        throw new GeneralConfigException("Falha na leitura de configura\u00e7\u00f5es gerais direto - " + (Object)((Object)CSILibErrorCode.getByErrorCode(rtn)));
    }

    public String getValue(String key) throws GeneralConfigException {
        try {
            for (String line : this.getFileContent(this.securityJNA.createCode()).split("\n")) {
                String[] parts = line.split("=");
                if (parts.length < 2 || !parts[0].trim().equals(key)) continue;
                return line.substring(line.indexOf("=") + 1).trim();
            }
            throw new GeneralConfigException(String.format("N\u00e3o foi poss\u00edvel encontrar %s nas configura\u00e7\u00f5es gerais", key));
        }
        catch (Exception e) {
            throw new GeneralConfigException(String.format("N\u00e3o foi poss\u00edvel encontrar %s nas configura\u00e7\u00f5es gerais", key), e);
        }
    }

    String getFullFilename() {
        if (fullFileName == null) {
            Path filePath = Paths.get(FILENAME, new String[0]);
            try {
                ControladorConfCTFClient.getInstance();
                if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                    filePath = Paths.get(ControladorConfCTFClient.getDiretorioTrabalho(), FILENAME);
                }
            }
            catch (ExcecaoNaoLocal excecaoNaoLocal) {
                logger.warn("N\u00e3o foi possivel obter o diret\u00f3rio para o arquivo de configura\u00e7\u00e3o geral, atribuindo a ele o working directory", (Throwable)excecaoNaoLocal);
            }
            fullFileName = filePath.toFile().getAbsolutePath();
        }
        return fullFileName;
    }

    static {
        logger = LogManager.getLogger(GeneralConfigHandler.class);
    }
}

