/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.integracao;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.integracao.ConfiguracaoException;
import com.csi.ctfclient.integracao.ConfiguracaoIntegrador;
import com.csi.ctfclient.integracao.Handler;
import com.csi.ctfclient.integracao.parser.ParserInput;
import com.csi.ctfclient.integracao.parser.ParserInputCSI;
import com.csi.ctfclient.integracao.parser.ParserOutput;
import com.csi.ctfclient.integracao.parser.ParserOutputCSI;
import java.lang.reflect.Constructor;

public class ConfiguracaoIntegradorConfCTF
extends ConfiguracaoIntegrador {
    private Handler handler;

    public ConfiguracaoIntegradorConfCTF() throws ConfiguracaoException {
        this.buildData();
    }

    private void buildData() throws ConfiguracaoException {
        try {
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            Class<?> objectClass = Class.forName(confCTFClient.getHandler());
            Constructor<?> constructor = objectClass.getConstructor(String.class, String.class);
            this.handler = (Handler)constructor.newInstance(confCTFClient.getHostClient(), confCTFClient.getPortClient());
        }
        catch (Exception e) {
            throw new ConfiguracaoException("Erro ao gerar dados de configuracao: " + e.getMessage());
        }
    }

    @Override
    public ParserInput createParserInput() {
        return new ParserInputCSI();
    }

    @Override
    public ParserOutput createParserOut() {
        return new ParserOutputCSI();
    }

    @Override
    public Handler getHandlerStream() {
        return this.handler;
    }
}

