/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.info.constantes;

import com.csi.ctfclient.excecoes.ErroApiAc;
import com.csi.ctfclient.excecoes.ExcecaoObjetoInexistente;
import com.csi.ctfclient.info.constantes.Constante;
import com.csi.ctfclient.info.constantes.ConstantesConfiguracao;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;

public class Mensagens
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NOMEARQUIVO = "mensagens";
    private static Hashtable<String, ConstantesConfiguracao> tabela = new Hashtable();
    private static Locale localPadrao = Locale.getDefault();

    private Mensagens() {
    }

    public static boolean existeConstante(String codigo) {
        ConstantesConfiguracao c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(Mensagens.getLocalPadrao());
            c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        }
        return c.existeConstante(codigo);
    }

    public static boolean existeConstante(String codigo, Locale loc) {
        ConstantesConfiguracao c = tabela.get(loc.getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(loc);
            c = tabela.get(loc.getLanguage());
        }
        return c.existeConstante(codigo);
    }

    public static Constante getConstante(String codigo) {
        ConstantesConfiguracao c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(Mensagens.getLocalPadrao());
            c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        }
        try {
            return c.getConstante(codigo);
        }
        catch (ExcecaoObjetoInexistente e) {
            return new Constante(codigo, "MsgNotFound:" + codigo);
        }
    }

    public static Constante getConstante(String codigo, Locale loc) {
        ConstantesConfiguracao c = tabela.get(loc.getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(loc);
            c = tabela.get(loc.getLanguage());
        }
        try {
            return c.getConstante(codigo);
        }
        catch (ExcecaoObjetoInexistente e) {
            return new Constante(codigo, "MsgNotFound:" + codigo);
        }
    }

    public static Constante[] getConstantes() {
        ConstantesConfiguracao c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(Mensagens.getLocalPadrao());
            c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        }
        return c.getConstantes();
    }

    public static Constante[] getConstantes(Locale loc) {
        ConstantesConfiguracao c = tabela.get(loc.getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(loc);
            c = tabela.get(loc.getLanguage());
        }
        return c.getConstantes();
    }

    public static String getDescricao(String codigo) {
        ConstantesConfiguracao c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(Mensagens.getLocalPadrao());
            c = tabela.get(Mensagens.getLocalPadrao().getLanguage());
        }
        try {
            return c.getDescricao(codigo);
        }
        catch (ExcecaoObjetoInexistente e) {
            String descricao = "MsgNotFound:" + codigo;
            return descricao;
        }
    }

    public static String getDescricao(String codigo, Locale loc) {
        ConstantesConfiguracao c = tabela.get(loc.getLanguage());
        if (c == null) {
            Mensagens.inicializaConstantes(loc);
            c = tabela.get(loc.getLanguage());
        }
        try {
            return c.getDescricao(codigo);
        }
        catch (ExcecaoObjetoInexistente e) {
            String descricao = "MsgNotFound:" + codigo;
            return descricao;
        }
    }

    public static Locale getLocalPadrao() {
        return localPadrao;
    }

    public static void setLocalPadrao(Locale local) {
        localPadrao = local;
    }

    private static void inicializaConstantes(Locale loc) {
        try {
            tabela.put(loc.getLanguage(), new ConstantesConfiguracao(NOMEARQUIVO, loc));
        }
        catch (Exception e) {
            throw new ErroApiAc("File Messages for Client SP not found");
        }
    }
}

