/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.info.constantes;

import com.csi.ctfclient.excecoes.ErroApiAc;
import com.csi.ctfclient.excecoes.ExcecaoObjetoInexistente;
import com.csi.ctfclient.info.constantes.Constante;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class ConstantesConfiguracao {
    private ResourceBundle bundle;

    public ConstantesConfiguracao(String nomeBundle) {
        try {
            this.bundle = ResourceBundle.getBundle(nomeBundle);
        }
        catch (MissingResourceException e) {
            throw new ErroApiAc("EX17", nomeBundle + ".properties");
        }
    }

    public ConstantesConfiguracao(String nomeBundle, Locale loc) {
        try {
            this.bundle = ResourceBundle.getBundle(nomeBundle, loc);
        }
        catch (MissingResourceException e) {
            throw new ErroApiAc("EX17", nomeBundle + "_" + loc.toString() + ".properties");
        }
    }

    public boolean existeConstante(String codigo) {
        boolean result = true;
        if (codigo == null || codigo.equals("")) {
            return false;
        }
        try {
            this.bundle.getString(codigo);
        }
        catch (MissingResourceException e) {
            result = false;
        }
        return result;
    }

    public Constante getConstante(String codigo) throws ExcecaoObjetoInexistente {
        Constante result = new Constante(codigo, this.getDescricao(codigo));
        return result;
    }

    public Constante[] getConstantes() {
        Vector<Constante> aux = new Vector<Constante>();
        Enumeration<String> enumeration = this.bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String cod = enumeration.nextElement();
            aux.addElement(new Constante(cod, this.bundle.getString(cod)));
        }
        Constante[] result = new Constante[aux.size()];
        for (int i = 0; i < aux.size(); ++i) {
            result[i] = (Constante)aux.elementAt(i);
        }
        return result;
    }

    public String getDescricao(String codigo) throws ExcecaoObjetoInexistente {
        String desc = "";
        try {
            desc = this.bundle.getString(codigo);
        }
        catch (MissingResourceException e) {
            throw new ExcecaoObjetoInexistente(codigo);
        }
        return desc;
    }
}

