/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.httpserver.handlers;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CTFClientApiUpdateHandler
implements HttpHandler {
    private static final AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ControladorConfCTFClient.class);
    private static final String BODY_METHOD_NOT_ALLOWED = "<html><body><h1>405 - Method Not Allowed</h1></body><html>";
    private static final String RDS7_CONNECTION_TYPE = "RDS7_TYPE_COMM_WIFI";
    private static final String RDS7_TERMINAL_MODEL = "WINDOWS";
    private static final String RDS7_TERMINAL_NETWORK = "0004";
    private static final String RDS7_SERVER_IP = "201.87.163.85";
    private static final String RDS7_SERVER_PORT = "8000";
    private static final String SKIP_UPDATE_RESPONSE = "";

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        logger.info("Recebendo requisicao HTTP: " + httpExchange.getRequestMethod() + " " + httpExchange.getRequestURI().toString());
        String httpResponse = "GET".equals(httpExchange.getRequestMethod()) ? this.handleGETRequest(httpExchange) : this.handleNotImplemented(httpExchange);
        OutputStream outputStream = httpExchange.getResponseBody();
        if (httpResponse != null) {
            outputStream.write(httpResponse.getBytes());
        } else {
            outputStream.write(0);
        }
        logger.info("Resposta HTTP: " + httpExchange.getResponseCode());
        logger.debug("Corpo da Resposta HTTP: " + httpResponse);
        outputStream.flush();
        outputStream.close();
    }

    private String handleNotImplemented(HttpExchange httpExchange) throws IOException {
        httpExchange.sendResponseHeaders(405, BODY_METHOD_NOT_ALLOWED.length());
        return BODY_METHOD_NOT_ALLOWED;
    }

    private String handleGETRequest(HttpExchange httpExchange) throws IOException {
        ConfCTFClient confCTFClient = null;
        try {
            confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        }
        catch (ExcecaoNaoLocal excecaoNaoLocal) {
            logger.warn("N\u00e3o foi poss\u00edvel carregar as configura\u00e7\u00f5es do CTFClient.");
        }
        if (confCTFClient != null && !confCTFClient.isHabilitaAtualizador()) {
            logger.info("Atualizador desabilitado por configura\u00e7\u00e3o. Pulando busca por atualiza\u00e7\u00f5es");
            httpExchange.sendResponseHeaders(202, SKIP_UPDATE_RESPONSE.length());
            return SKIP_UPDATE_RESPONSE;
        }
        String response = "{}";
        try {
            HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
            dataMap.put("data", this.buildUpdateInfo());
            Gson gson = new Gson();
            response = gson.toJson(dataMap);
        }
        catch (Exception e) {
            httpExchange.getResponseHeaders().set("Content-Type", "application/json");
            httpExchange.sendResponseHeaders(500, 0L);
            return response;
        }
        httpExchange.getResponseHeaders().set("Content-Type", "application/json");
        httpExchange.sendResponseHeaders(200, response.length());
        return response;
    }

    private Map<String, Object> buildUpdateInfo() throws ExcecaoApiAc {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("ctfclient", this.buildCTFClientInfo());
        resultMap.put("rds7", this.buildRds7Info());
        return resultMap;
    }

    private Map<String, Object> buildCTFClientInfo() throws ExcecaoApiAc {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("version", ControladorConfCTFClient.VERSAO_CLIENT_FULL);
        ConfCTFClient confCTFClient = Objects.requireNonNull(ControladorConfCTFClient.getInstance()).getConfig();
        resultMap.put("terminal", confCTFClient.getFullTerminal());
        return resultMap;
    }

    private Map<String, Object> buildRds7Info() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("connectionType", RDS7_CONNECTION_TYPE);
        resultMap.put("terminalModel", RDS7_TERMINAL_MODEL);
        resultMap.put("terminalNetwork", RDS7_TERMINAL_NETWORK);
        resultMap.put("serverIp", RDS7_SERVER_IP);
        resultMap.put("serverPort", RDS7_SERVER_PORT);
        return resultMap;
    }
}

