/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.httpserver;

import com.csi.ctfclient.httpserver.handlers.CTFClientApiUpdateHandler;
import com.csi.ctfclient.httpserver.handlers.DefaultHttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public final class HttpServerManager {
    private static final HttpServerManager INSTANCE = new HttpServerManager();
    private HttpServer httpServer;

    private HttpServerManager() {
    }

    public static HttpServerManager getInstance() {
        return INSTANCE;
    }

    public void start(int port) throws IOException {
        this.stop();
        this.httpServer = HttpServer.create(this.getLocalInetSocketAddress(port), 0);
        this.httpServer.createContext("/", new DefaultHttpHandler());
        this.httpServer.createContext("/api/v1/update", new CTFClientApiUpdateHandler());
        this.httpServer.setExecutor(this.getThreadPoolExecutor());
        this.httpServer.start();
    }

    public void stop() {
        if (this.httpServer != null) {
            this.httpServer.stop(1);
            this.httpServer = null;
        }
    }

    private InetSocketAddress getLocalInetSocketAddress(int port) {
        InetAddress localHost = InetAddress.getLoopbackAddress();
        return new InetSocketAddress(localHost, port);
    }

    private ThreadPoolExecutor getThreadPoolExecutor() {
        return (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
    }
}

