/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.gui;

import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.gui.JPanelImage;
import com.csi.ctfclient.tools.devices.generic.JPanelDisplay;
import com.csi.ctfclient.tools.util.JavaUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Robot;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.JavaVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TelaPrincipal
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(TelaPrincipal.class);
    private static TelaPrincipal instancia;
    static final Object lockDisplay;
    private JPanelDisplay display;
    private JPanelImage imagepanel;
    private String PATH_IMG_BACKGROUND = "imagens/background4.png";
    private RecuperaFocoListener recuperaFocoListener = null;

    public static synchronized TelaPrincipal getInstancia() {
        if (instancia == null) {
            instancia = new TelaPrincipal();
        }
        return instancia;
    }

    private TelaPrincipal() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Container container = this.getContentPane();
        container.setLayout(null);
        container.add(this.getImagePanel());
        this.setSize(305, 410);
        this.setTitle("Auttar - CTF Client - " + ControladorConfCTFClient.VERSAO_CLIENT);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setFocusable(true);
        Class[] mytypes = new Class[]{Boolean.TYPE};
        try {
            if (JavaUtil.compareJavaVersionTo(JavaVersion.JAVA_1_5) >= 0) {
                logger.info("M\u00e1quina virtual 1.5 ou superior detectada, solicitando foco...");
                Method metodo = this.getClass().getMethod("setAlwaysOnTop", mytypes);
                Object[] meusObjetos = new Object[]{Boolean.TRUE};
                metodo.invoke((Object)this, meusObjetos);
                this.recuperaFocoListener = new RecuperaFocoListener();
                this.addWindowListener(this.recuperaFocoListener);
            } else {
                logger.warn("M\u00e1quina virtual menor que vers\u00e3o 1.5. N\u00e3o foi possivel criar listener de recupera\u00e7\u00e3o de foco");
            }
        }
        catch (Exception e) {
            logger.warn("Exception ao tentar invocar o AlwaysOnTop da m\u00e1quina virtual superior a 1.4. Error: " + e.getMessage());
        }
    }

    private JPanelImage getImagePanel() {
        if (this.imagepanel == null) {
            this.imagepanel = new JPanelImage();
            ImageIcon icon = new ImageIcon(this.PATH_IMG_BACKGROUND);
            this.imagepanel.setIcon(icon);
            this.imagepanel.setLayout(null);
            this.imagepanel.setStretch(true);
            this.imagepanel.setBounds(0, 0, 300, 385);
        }
        return this.imagepanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplay(JPanelDisplay display) {
        logger.trace("SetDisplay Display Panel");
        Object object = lockDisplay;
        synchronized (object) {
            Runnable update = () -> {
                logger.trace("Runnable: SetDisplay Display Panel");
                if (this.display != null) {
                    this.getImagePanel().remove(this.display);
                }
                this.display = display;
                this.display.setLocation(30, 45);
                logger.trace("Antes do: setLocation");
                this.display.setSize(600, 420);
                this.display.setBackground(new Color(193, 193, 193));
                this.display.setFocusable(true);
                logger.trace("Antes do: getImagePanel().add");
                this.getImagePanel().add(this.display);
            };
            if (SwingUtilities.isEventDispatchThread()) {
                update.run();
            } else {
                SwingUtilities.invokeLater(update);
            }
        }
    }

    @Override
    public void addMouseListener(MouseListener listener) {
        super.addMouseListener(listener);
        this.getImagePanel().addMouseListener(listener);
    }

    public void removeRecuperaFocoListener() {
        if (this.recuperaFocoListener != null) {
            this.removeWindowListener(this.recuperaFocoListener);
        }
    }

    static {
        lockDisplay = new Object();
    }

    class RecuperaFocoListener
    implements WindowListener {
        RecuperaFocoListener() {
        }

        private void windowSelect() {
            try {
                logger.info("iniciando processo de recupera\u00e7\u00e3o de foco");
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                Point point = pointerInfo.getLocation();
                int x = (int)point.getX();
                int y = (int)point.getY();
                Robot rb = new Robot();
                rb.mouseMove(TelaPrincipal.this.getX() + 100, TelaPrincipal.this.getY() + 50);
                rb.mousePress(16);
                rb.mouseRelease(16);
                rb.mouseMove(x, y);
                logger.info("foco obtido com sucesso");
            }
            catch (Exception e) {
                logger.error("ERRO RecuperaFocoListener", (Throwable)e);
            }
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
            this.windowSelect();
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
            logger.info("foco perdido");
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
            this.windowSelect();
        }
    }
}

