/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.model.OperadoraTelefonia;
import com.csi.ctfclient.config.ConfCreditoDigital;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.xml.Config;
import com.csi.ctfclient.tools.util.xml.ParameterSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedHashSet;
import java.util.List;

public class ControladorConfCreditoDigital {
    private static AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
    private static ConfCreditoDigital confCreditoDigital;
    private static ControladorConfCreditoDigital readerConfCreditoDigital;
    private final String FILE_CONFIG = "configCreditoDigital.xml";

    private ControladorConfCreditoDigital() {
    }

    public static synchronized ControladorConfCreditoDigital getInstance() throws ExcecaoNaoLocal {
        if (readerConfCreditoDigital == null) {
            logger.info("Inicializando controlador de configura\u00e7\u00f5es de cr\u00e9dito digital...");
            readerConfCreditoDigital = new ControladorConfCreditoDigital();
            confCreditoDigital = readerConfCreditoDigital.read();
        }
        return readerConfCreditoDigital;
    }

    public ConfCreditoDigital getConfig() {
        return confCreditoDigital;
    }

    private ConfCreditoDigital read() throws ExcecaoNaoLocal {
        logger.info("Inicializando carga dos parametros de configura\u00e7\u00e3o...");
        ConfCreditoDigital confCreditoDigital = new ConfCreditoDigital();
        try {
            LinkedHashSet<OperadoraTelefonia> operadorasTelefonia;
            Config config;
            logger.info("Inicializando leitura do arquivo de configura\u00e7\u00f5es");
            if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
                if (!new File(ControladorConfCTFClient.getDiretorioTrabalho() + "configCreditoDigital.xml").exists()) {
                    logger.error("Arquivo " + ControladorConfCTFClient.getDiretorioTrabalho() + "configCreditoDigital.xml" + " nao existe !");
                    throw new FileNotFoundException(ControladorConfCTFClient.getDiretorioTrabalho() + "configCreditoDigital.xml");
                }
                config = Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + "configCreditoDigital.xml");
            } else {
                config = Config.getConfig("configCreditoDigital.xml");
            }
            logger.info("Arquivo de configura\u00e7\u00e3o carregado...");
            ParameterSet root = config.getParameterSet("configCreditoDigital");
            ParameterSet ipsParameter = root.getParameterSet("operadoras");
            if (ipsParameter != null && ipsParameter.getParameterSets("operadora") != null && ipsParameter.getParameterSets("operadora").size() > 0) {
                operadorasTelefonia = new LinkedHashSet<OperadoraTelefonia>();
                List<ParameterSet> listaOperadora = ipsParameter.getParameterSets("operadora");
                for (ParameterSet paramOperadora : listaOperadora) {
                    String codigo = paramOperadora.getParameter("codigo").getContent();
                    if (codigo == null || codigo.equals("")) {
                        logger.error("valor de parametro invalido ==> operadora = codigo");
                        throw new IllegalArgumentException("codigo");
                    }
                    String nome = paramOperadora.getParameter("nome").getContent();
                    if (nome == null || nome.equals("")) {
                        logger.error("valor de parametro invalido ==> operadora = nome");
                        throw new IllegalArgumentException("nome");
                    }
                    String digito = paramOperadora.getParameter("digito").getContent();
                    if (digito == null || digito.equals("")) {
                        logger.error("valor de parametro invalido ==> operadora = digito");
                        throw new IllegalArgumentException("digito");
                    }
                    int digitoInt = Integer.parseInt(digito);
                    OperadoraTelefonia operadora = new OperadoraTelefonia();
                    operadora.setAutorizadora(codigo);
                    operadora.setNome(nome);
                    operadora.setDigito(digitoInt == 1);
                    operadorasTelefonia.add(operadora);
                }
            } else {
                throw new IllegalArgumentException("operadora");
            }
            confCreditoDigital.setOperadorasTelefonia(operadorasTelefonia);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new ExcecaoNaoLocal(e, "CCCD07", "Erro ao ler arquivo de credito digital");
        }
        return confCreditoDigital;
    }
}

