/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import com.csi.ctfclient.tools.util.xml.ConfigConstants;
import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigCTFClientSAXHandler
extends DefaultHandler
implements ConfigConstants {
    private static final String STR_OPEN_CLOSE_TAG = "</";
    private static final String STR_OPEN_OPEN_TAG = "<";
    private static final String STR_CLOSE_OPEN_TAG = ">";
    private static final String ATTR_NAME = "name";
    private static final String TAB_SPACE = "    ";
    private StringBuilder xmlOutput;
    private StringBuilder elementValue;
    private Stack<String> elementsStack;

    ConfigCTFClientSAXHandler() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elementValue == null) {
            this.elementValue = new StringBuilder();
        } else {
            this.elementValue = new StringBuilder();
            this.elementValue.append(ch, start, length);
        }
    }

    @Override
    public void startDocument() {
        this.xmlOutput = new StringBuilder();
        this.elementsStack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        for (int i = 0; i < this.elementsStack.size(); ++i) {
            this.xmlOutput.append(TAB_SPACE);
        }
        switch (qName) {
            case "Parameter": 
            case "ParameterSet": {
                this.xmlOutput.append(STR_OPEN_OPEN_TAG).append(attributes.getValue(ATTR_NAME)).append(STR_CLOSE_OPEN_TAG).append(System.lineSeparator());
                this.elementsStack.push(attributes.getValue(ATTR_NAME));
                break;
            }
            case "configuration_file": {
                this.xmlOutput.append(STR_OPEN_OPEN_TAG).append(qName).append(STR_CLOSE_OPEN_TAG).append(System.lineSeparator());
                this.elementsStack.push(qName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("Parameter")) {
            if (this.elementValue.toString().trim().length() > 0) {
                this.xmlOutput.append((CharSequence)this.elementValue);
            }
        } else {
            for (int i = 0; i < this.elementsStack.size() - 1; ++i) {
                this.xmlOutput.append(TAB_SPACE);
            }
        }
        if (this.elementsStack.size() > 0) {
            this.xmlOutput.append(STR_OPEN_CLOSE_TAG).append(this.elementsStack.pop()).append(STR_CLOSE_OPEN_TAG).append(System.lineSeparator());
        }
    }

    public String getXmlOutput() {
        return this.xmlOutput.toString();
    }

    public static String parseAndOutputNewXML(String fileFullPath) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            ConfigCTFClientSAXHandler handler = new ConfigCTFClientSAXHandler();
            saxParser.parse(fileFullPath, (DefaultHandler)handler);
            return handler.getXmlOutput();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        String fileFullPath = "..\\build\\bin\\configCTFClient.xml";
        System.out.println(ConfigCTFClientSAXHandler.parseAndOutputNewXML(fileFullPath));
    }
}

