/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.config;

import br.com.auttar.util.thread.ThreadCatcher;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfCTFClientHandler;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ConfContingenciaConexao;
import com.csi.ctfclient.config.ConfPOSTef;
import com.csi.ctfclient.config.ConfTimeoutPin;
import com.csi.ctfclient.config.ConfTraceApiwebctf;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.servicos.TipoIntegracaoEnum;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.ServicoCTF;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.util.JavaUtil;
import com.csi.ctfclient.tools.util.ObjectUtil;
import com.csi.ctfclient.tools.util.ReflectHelp;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.xml.Config;
import com.csi.ctfclient.tools.util.xml.InterfaceParameter;
import com.csi.ctfclient.tools.util.xml.MultipleNamesFoundException;
import com.csi.ctfclient.tools.util.xml.NoSuchParameterException;
import com.csi.ctfclient.tools.util.xml.Parameter;
import com.csi.ctfclient.tools.util.xml.ParameterSet;
import com.csi.ctfclient.tools.util.xml.ParseConfigException;
import com.csi.ctfclient.tools.util.xml.StructureConfigException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfCTFClientDefaultHandler
extends ConfCTFClientHandler {
    private static final Logger logger = LogManager.getLogger(ConfCTFClientDefaultHandler.class);
    private static String CTFCLIENT_HOME_VALUE = null;

    @Override
    public String getDiretorioTrabalho() {
        if (CTFCLIENT_HOME_VALUE == null) {
            String ctfclient_home = "";
            try {
                if (JavaUtil.compareJavaVersionTo(JavaVersion.JAVA_1_5) > -1) {
                    ctfclient_home = System.getenv("CTFCLIENT_HOME");
                } else {
                    logger.warn("N\u00e3o foi possivel obter o ctfclient_home a partir da variavel de ambiente CTFCLIENT_HOME");
                }
            }
            catch (ParseException e) {
                logger.error("N\u00e3o foi possivel obter o ctfclient_home a partir da variavel de ambiente CTFCLIENT_HOME", (Throwable)e);
            }
            if (ctfclient_home != null) {
                ctfclient_home = ctfclient_home.trim();
                if (!(ctfclient_home = ctfclient_home + File.separator + "bin").endsWith("\\") && !ctfclient_home.endsWith("/")) {
                    ctfclient_home = ctfclient_home + File.separator;
                }
                CTFCLIENT_HOME_VALUE = ctfclient_home;
            }
        }
        return CTFCLIENT_HOME_VALUE;
    }

    private static void insertAttributeValue(Object objeto, String atributo, Object value) throws IllegalAccessException, NoSuchMethodException, NoSuchFieldException, InvocationTargetException {
        try {
            ReflectHelp.setField(objeto, atributo, value);
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            ReflectHelp.invokeMethod(objeto, atributo, value);
        }
    }

    private void insertValueParameter(String nomeParametroXml, ParameterSet root, Object valorDefautParameter, boolean isSetaValorDefaultException, Object objetoConfig, String nomeDoAtributoNoObjetoConfig, Config config, boolean isExibeLog) throws RuntimeException, ExcecaoApiAc, NoSuchFieldException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        this.insertValueParameter(nomeParametroXml, root, valorDefautParameter, isSetaValorDefaultException, objetoConfig, "", nomeDoAtributoNoObjetoConfig, null, false, config, isExibeLog);
    }

    private void insertValueParameter(String nomeParametroXml, ParameterSet root, Object objetoConfig, String nomeDoAtributoNoObjetoConfig, ExcecaoApiAc excecaoApiAc, Config config) throws RuntimeException, ExcecaoApiAc, NoSuchFieldException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        this.insertValueParameter(nomeParametroXml, root, null, false, objetoConfig, "", nomeDoAtributoNoObjetoConfig, excecaoApiAc, false, config, true);
    }

    private void insertValueParameter(String nomeParametroXml, ParameterSet root, Object valorDefautParameter, boolean isSetaValorDefaultException, Object objetoConfig, String labelObjetoConfig, String nomeDoAtributoNoObjetoConfig, ExcecaoApiAc excecaoApiAc, boolean isCriaParametroCasoNaoExista, Config config, boolean isExibeLog) throws RuntimeException, ExcecaoApiAc, NoSuchFieldException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        block12: {
            Parameter parameter = null;
            try {
                parameter = root.getParameter(nomeParametroXml);
                Object value = parameter.getContent();
                if (Objects.isNull(value) || StringUtils.isBlank(String.valueOf(value))) {
                    if (excecaoApiAc != null) {
                        if (isExibeLog) {
                            logger.error("Valor de par\u00e2metro inv\u00e1lido: {}", (Object)nomeParametroXml);
                        }
                        throw excecaoApiAc;
                    }
                    if (isExibeLog) {
                        logger.debug("Definindo valor: {} Parametro: {}.{}", valorDefautParameter, (Object)labelObjetoConfig, (Object)nomeParametroXml);
                    }
                    value = valorDefautParameter;
                }
                value = this.trataValorParametro(nomeParametroXml, value, valorDefautParameter, objetoConfig, excecaoApiAc);
                ConfCTFClientDefaultHandler.insertAttributeValue(objetoConfig, nomeDoAtributoNoObjetoConfig, value);
                if (isExibeLog) {
                    logger.info("Par\u00e2metro {}.{} = {}", (Object)labelObjetoConfig, (Object)nomeParametroXml, value);
                }
            }
            catch (MultipleNamesFoundException | NoSuchParameterException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | NoSuchElementException e) {
                if (isSetaValorDefaultException) {
                    if (isCriaParametroCasoNaoExista) {
                        this.insereCriaAtualizaValorParametroDefault(nomeParametroXml, ObjectUtils.defaultIfNull(parameter, new Parameter(nomeParametroXml)), valorDefautParameter, root, config);
                    }
                    valorDefautParameter = this.trataValorParametro(nomeParametroXml, valorDefautParameter, valorDefautParameter, objetoConfig, excecaoApiAc);
                    if (isExibeLog) {
                        logger.warn("Par\u00e2metro '{}.{}' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)labelObjetoConfig, (Object)nomeParametroXml, valorDefautParameter);
                    }
                    ConfCTFClientDefaultHandler.insertAttributeValue(objetoConfig, nomeDoAtributoNoObjetoConfig, valorDefautParameter);
                }
                if (isExibeLog) {
                    logger.error("Erro {} / Parametro {}.{} Invalido ", (Object)e.getClass().getSimpleName(), (Object)labelObjetoConfig, (Object)nomeParametroXml);
                }
                throw new RuntimeException("Parametro Invalido " + nomeParametroXml, e);
            }
            catch (ExcecaoParametroInvalido | NoSuchFieldException | NullPointerException e) {
                if (!isExibeLog) break block12;
                logger.error("Erro {} / Field parametro '{}.{}'", (Object)e.getClass().getSimpleName(), (Object)labelObjetoConfig, (Object)nomeParametroXml);
            }
        }
    }

    Object trataValorParametro(String nomeParametroXml, Object valueParameter, Object valorDefautParameter, Object objectConfig, ExcecaoApiAc excecaoParameterInvalido) throws ExcecaoApiAc, IllegalArgumentException {
        boolean isValorDiferenteDeBoolean = !Objects.equals(valueParameter, "true") && !Objects.equals(valueParameter, "false") && !Objects.equals(valueParameter, Boolean.TRUE) && !Objects.equals(valueParameter, Boolean.FALSE);
        String[] originalValueParameter = valueParameter;
        valueParameter = ObjectUtil.objectTypeReturn(valueParameter);
        switch (nomeParametroXml) {
            case "tipointegracao": {
                valueParameter = TipoIntegracaoEnum.getObterEnumPorChave(String.valueOf(valueParameter)).getId();
                break;
            }
            case "versaoAC": {
                if (!Objects.nonNull(originalValueParameter)) break;
                valueParameter = originalValueParameter;
                break;
            }
            case "cnpj": 
            case "portclient": 
            case "port": {
                if (!Objects.nonNull(valueParameter)) break;
                if (StringUtils.isNotBlank(valueParameter.toString()) && !StringUtils.isNumeric(valueParameter.toString())) {
                    throw new IllegalArgumentException("Par\u00e2metro " + nomeParametroXml + " com valor inv\u00e1lido");
                }
                valueParameter = valueParameter.toString();
                break;
            }
            case "intertef": 
            case "confirmacaoMultiTerminal": {
                if (Integer.parseInt(String.valueOf(valueParameter)) != 0) break;
                throw new RuntimeException(Objects.requireNonNull(excecaoParameterInvalido));
            }
            case "capturaTelefonePinpad": 
            case "capturaTelefoneDuplaCaptura": 
            case "permiteValoresVariaveis": {
                if (!isValorDiferenteDeBoolean) break;
                valueParameter = valorDefautParameter;
                break;
            }
            case "capturaTelefoneDoisDisplay": 
            case "confirmaDddTelefone": {
                if (!isValorDiferenteDeBoolean) break;
                throw new RuntimeException(Objects.requireNonNull(excecaoParameterInvalido));
            }
            case "handler": {
                valueParameter = ((ConfCTFClient)objectConfig).getTipoIntegracaoEnum().getHandler();
                break;
            }
            case "params": {
                if (!Objects.nonNull(valueParameter)) break;
                valueParameter = String.valueOf(valueParameter).split(",");
                break;
            }
            case "host": {
                if (!Objects.nonNull(valueParameter)) break;
                valueParameter = new Host(String.valueOf(valueParameter));
                break;
            }
            case "habilitaThreadCatcher": {
                ThreadCatcher.setHabilitado(Boolean.valueOf(String.valueOf(valueParameter)));
                valueParameter = ObjectUtil.objectTypeReturn(valueParameter);
                break;
            }
            case "estabelecimento": {
                if (!Objects.nonNull(originalValueParameter)) break;
                if (!this.validaEstabelecimento(String.valueOf(originalValueParameter))) {
                    throw new IllegalArgumentException("Par\u00e2metro " + nomeParametroXml + " com valor inv\u00e1lido");
                }
                valueParameter = originalValueParameter;
                break;
            }
            case "loja": {
                if (!Objects.nonNull(originalValueParameter)) break;
                if (!this.validaLoja(String.valueOf(originalValueParameter))) {
                    throw new IllegalArgumentException("Par\u00e2metro " + nomeParametroXml + " com valor inv\u00e1lido");
                }
                valueParameter = originalValueParameter;
                break;
            }
            case "terminal": {
                if (!Objects.nonNull(originalValueParameter)) break;
                if (!this.validaTerminal(String.valueOf(originalValueParameter))) {
                    throw new IllegalArgumentException("Par\u00e2metro " + nomeParametroXml + " com valor inv\u00e1lido");
                }
                valueParameter = originalValueParameter;
            }
        }
        return valueParameter;
    }

    private void insertValueParameterSet(String nomeParameterSet, Object objetoParameterSet, Object objetoConfig, String nomeObjetoParameterSet, ParameterSet root, String[] nomesParameter, Object[] valoresDefautParameter, boolean[] isSetaValoresDefaultsException, String[] nomesReaisAtributosObjectConfig, Config config, boolean[] isExibeLog) throws ExcecaoApiAc {
        this.insertValueParameterSet(nomeParameterSet, objetoParameterSet, objetoConfig, nomeObjetoParameterSet, null, root, false, nomesParameter, valoresDefautParameter, isSetaValoresDefaultsException, nomesReaisAtributosObjectConfig, new ExcecaoApiAc[nomesParameter.length], new boolean[nomesParameter.length], config, isExibeLog);
    }

    private void insertValueParameterSet(String nomeParameterSet, Object objetoParameterSet, Object objetoConfig, ParameterSet root, String[] nomesParameter, Object[] valoresDefautParameter, boolean[] isSetaValoresDefaultsException, String[] nomesReaisAtributosObjectConfig, Config config, boolean[] isExibeLog) throws ExcecaoApiAc {
        this.insertValueParameterSet(nomeParameterSet, objetoParameterSet, objetoConfig, null, null, root, false, nomesParameter, valoresDefautParameter, isSetaValoresDefaultsException, nomesReaisAtributosObjectConfig, new ExcecaoApiAc[nomesParameter.length], new boolean[nomesParameter.length], config, isExibeLog);
    }

    private void insertValueParameterSet(String nomeParameterSet, Object objetoParameterSet, Object objetoConfig, String nomeObjetoParameterSet, ExcecaoApiAc excecaoParamterSetInvalido, ParameterSet root, boolean isCriaParameterSet, String[] nomesParameter, Object[] valoresDefautParameter, boolean[] isSetaValoresDefaultsException, String[] nomesReaisAtributosObjectConfig, ExcecaoApiAc[] excecoesApiAc, boolean[] isCriaParametrosCasoNaoExistam, Config config, boolean[] isExibeLog) throws ExcecaoApiAc, RuntimeException {
        ParameterSet parameterSet = null;
        try {
            parameterSet = root.getParameterSet(nomeParameterSet);
            if (parameterSet != null) {
                logger.debug("ParametroSet {} Inicio", (Object)parameterSet.getName());
                for (int i = 0; i < nomesParameter.length; ++i) {
                    this.insertValueParameter(nomesParameter[i], parameterSet, valoresDefautParameter[i], isSetaValoresDefaultsException[i], objetoParameterSet, parameterSet.getName(), nomesReaisAtributosObjectConfig[i], excecoesApiAc[i], isCriaParametrosCasoNaoExistam[i], config, isExibeLog[i]);
                }
                if (ObjectUtils.notEqual(objetoConfig, objetoParameterSet) && StringUtils.isNotBlank(nomeObjetoParameterSet)) {
                    objetoParameterSet = this.trataValorParameterSet(nomeParameterSet, objetoParameterSet, excecaoParamterSetInvalido);
                    ConfCTFClientDefaultHandler.insertAttributeValue(objetoConfig, nomeObjetoParameterSet, objetoParameterSet);
                }
                logger.debug("ParametroSet {} Fim", (Object)parameterSet.getName());
            } else {
                if (excecaoParamterSetInvalido != null) {
                    logger.error("Valor de ParameterSet inv\u00e1lido: {}", (Object)nomeParameterSet);
                    throw excecaoParamterSetInvalido;
                }
                logger.warn("ParameterSet {} Invalido", (Object)nomeParameterSet);
            }
        }
        catch (RuntimeException e) {
            logger.error("RuntimeException: {}", (Object)e.getMessage());
            throw e;
        }
        catch (MultipleNamesFoundException | NoSuchParameterException | IllegalAccessException | NoSuchFieldException e) {
            if (isCriaParameterSet) {
                this.insereCriaAtualizaValorParametroDefault(nomeParameterSet, ObjectUtils.defaultIfNull(parameterSet, new ParameterSet(nomeParameterSet)), null, root, config);
                logger.warn("Par\u00e2metroSet '{}' n\u00e3o encontrado ou inv\u00e1lido. Tag ParameterSet criada", (Object)nomeParameterSet);
                this.insertValueParameterSet(nomeParameterSet, objetoParameterSet, objetoConfig, nomeObjetoParameterSet, excecaoParamterSetInvalido, root, false, nomesParameter, valoresDefautParameter, isSetaValoresDefaultsException, nomesReaisAtributosObjectConfig, excecoesApiAc, isCriaParametrosCasoNaoExistam, config, isExibeLog);
            } else {
                logger.warn("Par\u00e2metroSet '{}' n\u00e3o encontrado ou inv\u00e1lido. Value '{}' aplicado", (Object)nomeParameterSet, (Object)null);
            }
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            logger.error("Erro: {} / ParametroSet", (Object)e.getClass().getSimpleName());
            throw new RuntimeException(e);
        }
    }

    private Object trataValorParameterSet(String nameParameterSet, Object objectParameterSet, ExcecaoApiAc excecaoParameterInvalido) throws ExcecaoApiAc {
        switch (nameParameterSet) {
            case "DRIVER_TECLADO": {
                ConfPeriferico teclado = (ConfPeriferico)objectParameterSet;
                String tipo = teclado.getNomeLogico();
                if ("TECLADO_PC".equalsIgnoreCase(tipo)) {
                    teclado = new ConfPeriferico("TECLADO_PC");
                    teclado.setNomeClasse("com.csi.ctfclient.tools.devices.generic.TecladoPC");
                } else if ("TECLADO_JAVAPOS".equalsIgnoreCase(tipo)) {
                    teclado = new ConfPeriferico("TECLADO_JAVAPOS");
                    teclado.setNomeClasse("com.csi.ctfclient.tools.devices.javapos.TecladoJavaPOS");
                } else if ("TECLADO_TOUCH_LINX".equalsIgnoreCase(tipo)) {
                    teclado = new ConfPeriferico("TECLADO_TOUCH_LINX");
                    teclado.setNomeClasse("br.com.auttar.ctfclient.tools.devices.touchkeyboard.TecladoTouchLinx");
                } else if ("TECLADO_TOUCH".equalsIgnoreCase(tipo)) {
                    teclado = new ConfPeriferico("TECLADO_TOUCH");
                    teclado.setNomeClasse("br.com.auttar.ctfclient.tools.devices.touchkeyboard.TecladoTouch");
                } else {
                    throw excecaoParameterInvalido;
                }
                objectParameterSet = teclado;
                break;
            }
            case "DRIVER_DISPLAY_OPERADOR": {
                ConfPeriferico displayOperador = (ConfPeriferico)objectParameterSet;
                String tipo = displayOperador.getNomeLogico();
                if (StringUtils.isNotBlank(tipo)) {
                    if ("DISPLAY_OPERADOR".equalsIgnoreCase(tipo)) {
                        displayOperador = new ConfPeriferico("DISPLAY_OPERADOR");
                        displayOperador.setNomeClasse("com.csi.ctfclient.tools.devices.generic.JPanelDisplay");
                    } else if ("DISPLAY_AUTTAR".equalsIgnoreCase(tipo)) {
                        displayOperador = new ConfPeriferico("DISPLAY_AUTTAR");
                        displayOperador.setNomeClasse("com.csi.ctfclient.tools.devices.generic.DisplayFisicoAuttar");
                    }
                    objectParameterSet = displayOperador;
                    break;
                }
                objectParameterSet = null;
                break;
            }
            case "DRIVER_SCANNER": {
                ConfPeriferico scanner = (ConfPeriferico)objectParameterSet;
                String tipo = scanner.getNomeLogico();
                if (StringUtils.isNotBlank(tipo)) {
                    if ("SCANNER_SERIAL".equalsIgnoreCase(tipo)) {
                        scanner = new ConfPeriferico("SCANNER_SERIAL");
                        scanner.setNomeClasse("com.csi.ctfclient.tools.devices.generic.ScannerSerial");
                    } else if ("SCANNER_JAVAPOS".equalsIgnoreCase(tipo)) {
                        scanner = new ConfPeriferico("SCANNER_JAVAPOS");
                        scanner.setNomeClasse("com.csi.ctfclient.tools.devices.javapos.ScannerJavaPOS");
                    }
                    objectParameterSet = scanner;
                    break;
                }
                objectParameterSet = null;
                break;
            }
            case "DRIVER_LEITOR_DOCUMENTO": {
                ConfPeriferico leitorDocumento = (ConfPeriferico)objectParameterSet;
                String tipo = leitorDocumento.getNomeLogico();
                if (StringUtils.isNotBlank(tipo)) {
                    if ("LEITOR_DOCUMENTO_CHRONOS".equalsIgnoreCase(tipo)) {
                        leitorDocumento = new ConfPeriferico("LEITOR_DOCUMENTO_CHRONOS");
                        leitorDocumento.setNomeClasse("com.csi.ctfclient.tools.devices.chronos.LeitorDocumentoChronos");
                    } else if ("LEITOR_DOCUMENTO_LOGGER2".equalsIgnoreCase(tipo)) {
                        leitorDocumento = new ConfPeriferico("LEITOR_DOCUMENTO_CHRONOS");
                        leitorDocumento.setNomeClasse("com.csi.ctfclient.tools.devices.urano.LeitorDocumentoUranoLogger2");
                    } else if ("LEITOR_DOCUMENTO_TECPOINTTL840".equalsIgnoreCase(tipo)) {
                        leitorDocumento = new ConfPeriferico("LEITOR_DOCUMENTO_TECPOINTTL840");
                        leitorDocumento.setNomeClasse("com.csi.ctfclient.tools.devices.tecpoint.LeitorDocumentoTecpointTL840");
                    }
                    objectParameterSet = leitorDocumento;
                    break;
                }
                objectParameterSet = null;
            }
        }
        return objectParameterSet;
    }

    private void insereCriaAtualizaValorParametroDefault(String nameParameter, InterfaceParameter parameter, Object valueDefautParameter, ParameterSet root, Config config) {
        if (Objects.nonNull(parameter) && this.isConfigurado(root, nameParameter)) {
            parameter.detach();
            logger.debug("Parametro {} removido", (Object)nameParameter);
        }
        parameter.setContent(valueDefautParameter == null ? "" : String.valueOf(valueDefautParameter));
        root.attachParameter(parameter);
        logger.debug("Parametro {} criado", (Object)nameParameter);
        try {
            logger.debug("Atualizando arquivo com novo parametro {}", (Object)nameParameter);
            config.save();
            logger.debug("Arquivo atualizado com novo parametro {}", (Object)nameParameter);
        }
        catch (IOException ex) {
            logger.warn("N\u00e3o foi possivel atualizar *.xml configura\u00e7\u00e3o {}", (Object)ex.getMessage());
        }
    }

    @Override
    public void reader() throws ExcecaoApiAc {
        ConfCTFClient confCTFClient = new ConfCTFClient();
        try {
            Config config = ConfCTFClientDefaultHandler.getConfig();
            ParameterSet root = config.getParameterSet("configCTFClient");
            try {
                Parameter intTranslatorParameter = root.getParameter("integracaoTranslator");
                intTranslatorParameter.detach();
                logger.warn("parametro integracaoTranslator removido com sucesso.");
            }
            catch (Exception intTranslatorParameter) {
                // empty catch block
            }
            try {
                this.insertValueParameter("tipointegracao", root, (Object)TipoIntegracaoEnum.DLL, false, confCTFClient, "tipoIntegracao", config, true);
            }
            catch (Exception e) {
                this.trataExcecaoParametro("tipointegracao", root, confCTFClient);
            }
            this.insertValueParameter("suporteHttps", root, false, true, confCTFClient, "", "suporteHttps", null, true, config, true);
            this.insertValueParameter("homologacao", root, false, true, confCTFClient, "homologacao", config, this.isConfigurado(root, "homologacao"));
            this.insertValueParameter("forcarUsoApitefjni", root, false, true, confCTFClient, "forcarUsoApitefjni", config, this.isConfigurado(root, "forcarUsoApitefjni"));
            this.insertValueParameter("habilitaThreadCatcher", root, false, true, confCTFClient, "habilitaThreadCatcher", config, true);
            try {
                this.insertValueParameter("versaoPathTerminal", root, null, false, confCTFClient, "versaoPathTerminal", config, true);
            }
            catch (Exception e) {
                this.trataExcecaoParametro("versaoPathTerminal", root, confCTFClient);
            }
            this.insertValueParameter("cnpj", root, null, true, confCTFClient, "", "cnpj", null, true, config, true);
            this.insertValueParameter("estabelecimento", root, null, true, confCTFClient, "", "estabelecimento", null, true, config, true);
            this.insertValueParameter("loja", root, null, true, confCTFClient, "", "loja", null, true, config, true);
            this.insertValueParameter("terminal", root, null, true, confCTFClient, "", "terminal", null, true, config, true);
            this.insertValueParameter("confirmardesfazimento", root, false, true, confCTFClient, "confirmarDesfazimento", config, true);
            this.insertValueParameter("permitePagarSaldoVoucher", root, confCTFClient, "permitePagarSaldoVoucher", new ExcecaoApiAc("CCCDH01", "Erro de parametro no controlador de configuracoes", "permitePagarSaldoVoucher"), config);
            this.insertValueParameter("rotearPrivateLabel", root, confCTFClient, "rotearPrivateLabel", new ExcecaoApiAc("CCCDH02", "Erro de parametro no controlador de configuracoes", "rotearPrivateLabel"), config);
            this.insertValueParameter("numeroSite", root, 1, true, confCTFClient, "", "numeroSites", null, true, config, true);
            this.insertValueParameter("quantidadeVias", root, 2, true, confCTFClient, "", "quantidadeVias", null, true, config, true);
            this.insertValueParameter("versaoAC", root, null, false, confCTFClient, "", "versaoAC", null, true, config, true);
            this.insertValueParameter("handler", root, "com.csi.ctfclient.integracao.SocketHandler", true, confCTFClient, "", "handler", null, true, config, true);
            this.insertValueParameter("hostclient", root, "127.0.0.1", true, confCTFClient, "", "hostClient", null, true, config, true);
            this.insertValueParameter("portclient", root, "2500", true, confCTFClient, "", "portClient", new ExcecaoApiAc("CCCDH07", "Erro de parametro no portClient", "portClient"), true, config, true);
            this.insertValueParameter("standalone", root, confCTFClient, "standAlone", new ExcecaoApiAc("CCCDH09", "Erro de parametro no controlador de configuracoes", "standalone"), config);
            this.insertValueParameter("integracaoCriptografada", root, confCTFClient, "integracaoCriptografada", new ExcecaoApiAc("CCCDH10", "Erro de parametro no controlador de configuracoes", "integracaoCriptografada"), config);
            this.insertValueParameter("capturacmc7", root, confCTFClient, "capturaCmc7", new ExcecaoApiAc("CCCDH11", "Erro de parametro no controlador de configuracoes", "capturacmc7"), config);
            this.insertValueParameter("usaComunicacaoSeguraPinpad", root, true, true, confCTFClient, "comunicacaoSeguraPinpad", config, this.isConfigurado(root, "comunicacaoSeguraPinpad"));
            this.insertValueParameter("pingUDP", root, false, true, confCTFClient, "", "pingUDP", null, true, config, true);
            try {
                this.insertValueParameterSet("multiec", confCTFClient, confCTFClient, root, new String[]{"habilitado", "codigoGrupo"}, new Object[]{false, null}, new boolean[]{true, false}, new String[]{"multiEC", "codigoGrupoMultiEC"}, config, new boolean[]{true, true});
            }
            catch (Exception e) {
                this.trataExcecaoParametro("multiec", root, confCTFClient);
            }
            this.insertValueParameterSet("traceApiwebctf", new ConfTraceApiwebctf(), confCTFClient, "confTraceApiwebctf", null, root, true, new String[]{"habilitado", "qtdDias"}, new Object[]{false, 0}, new boolean[]{true, true}, new String[]{"habilitado", "qtdDias"}, new ExcecaoApiAc[2], new boolean[]{true, true}, config, new boolean[]{true, true});
            this.insertValueParameterSet("timeoutPin", new ConfTimeoutPin(), confCTFClient, "timeoutPin", null, root, true, new String[]{"default", "blocking", "noblocking", "standard"}, new Object[]{0, 0, 0, 0}, new boolean[]{true, true, true, true}, new String[]{"timeoutDefault", "timeoutBlocking", "timeoutNoblocking", "timeoutStandard"}, new ExcecaoApiAc[4], new boolean[]{true, true, true, true}, config, new boolean[]{true, true, true, true});
            this.insertValueParameterSet("fusion", confCTFClient, confCTFClient, root, new String[]{"ip", "porta"}, new Object[]{"", 2501}, new boolean[]{true, true}, new String[]{"ipFusion", "portaFusion"}, config, new boolean[]{true, true});
            this.insertValueParameterSet("postef", new ConfPOSTef(), confCTFClient, "confPOSTef", null, root, true, new String[]{"habilitado", "porta", "posMovel"}, new Object[]{false, 0, ""}, new boolean[]{true, true, true}, new String[]{"habilitado", "porta", "terminalPosMovel"}, new ExcecaoApiAc[3], new boolean[]{true, true, true}, config, new boolean[]{true, true, true});
            this.insertValueParameterSet("clienteServico", new ConfClienteServico(), confCTFClient, "confClienteServico", null, root, true, new String[]{"habilitado", "host", "codigoPdv"}, new Object[]{false, null, ""}, new boolean[]{true, true, true}, new String[]{"habilitado", "host", "codigoPdv"}, new ExcecaoApiAc[3], new boolean[]{true, false, true}, config, new boolean[]{true, true, true});
            this.insertValueParameter("capturaApenasLinhaDigitavel", root, false, true, confCTFClient, "", "capturaApenasLinhaDigitavel", null, true, config, true);
            this.insertValueParameter("capturaEncargosCCB", root, false, true, confCTFClient, "capturaEncargosCCB", config, true);
            this.insertValueParameterSet("web", confCTFClient, confCTFClient, null, null, root, false, new String[]{"multitransacao", "controleTerminais", "filaTerminais"}, new Object[]{null, null, "0:0"}, new boolean[]{false, false, true}, new String[]{"multitransacaoWeb", "controleTerminais", "filaTerminais"}, new ExcecaoApiAc[]{new ExcecaoApiAc("CCCDH16", "Erro de parametro no controlador de configuracoes", "multitransacao"), new ExcecaoApiAc("CCCDH17", "Erro de parametro no controlador de configuracoes", "controleTerminais"), null}, new boolean[3], config, new boolean[]{true, true, true});
            this.insertValueParameterSet("timeout", confCTFClient, confCTFClient, null, null, root, false, new String[]{"intertef", "confirmacaoMultiTerminal"}, new Object[]{15, 120}, new boolean[]{true, true}, new String[]{"timeOutDefault", "timeOutConfirmacao"}, new ExcecaoApiAc[2], new boolean[]{true, true}, config, new boolean[]{true, true});
            this.insertValueParameterSet("creditodigital", confCTFClient, confCTFClient, null, null, root, false, new String[]{"capturaTelefonePinpad", "capturaTelefoneDoisDisplay", "capturaTelefoneDuplaCaptura", "confirmaDddTelefone", "versaolayout", "permiteValoresVariaveis"}, new Object[]{true, null, true, null, 3, true}, new boolean[]{true, false, true, false, true, true}, new String[]{"capturaTelefonePinpad", "capturaTelefoneDoisDisplay", "capturaTelefoneDuplaCaptura", "confirmaDddTelefone", "versaoLayoutCD", "permiteValoresVariaveis"}, new ExcecaoApiAc[]{null, new ExcecaoApiAc("CCCDH20", "Erro de parametro no controlador de configuracoes", "capturaTelefoneDoisDisplay"), null, new ExcecaoApiAc("CCCDH21", "Erro de parametro no controlador de configuracoes", "confirmaDddTelefone"), null, null}, new boolean[6], config, new boolean[]{true, true, true, true, true, true});
            ParameterSet ipsParameter = root.getParameterSet("ips");
            if (ipsParameter != null && ipsParameter.getAllParameterSets() != null && ipsParameter.getAllParameterSets().size() > 0) {
                LinkedHashSet<ServicoCTF> ips = new LinkedHashSet<ServicoCTF>();
                List<ParameterSet> listaIp = ipsParameter.getAllParameterSets();
                ServicoCTF servico = new ServicoCTF();
                for (ParameterSet ip : listaIp) {
                    this.insertValueParameter("host", ip, null, true, servico, ip.getName(), "host", null, true, config, true);
                    this.insertValueParameter("port", ip, "", true, servico, ip.getName(), "identifServico", null, true, config, true);
                    this.insertValueParameter("protocolo", ip, null, true, servico, ip.getName(), "protocolo", null, true, config, true);
                    ips.add(servico);
                }
                if (Objects.nonNull(servico.getHost()) && StringUtils.isNotBlank(servico.getHost().getEndereco()) && StringUtils.isNotBlank(servico.getProtocolo()) && StringUtils.isNotBlank(servico.getIdentificadorServico())) {
                    confCTFClient.setIps(ips);
                }
            } else {
                logger.error("lista de ips n\u00e3o configurada ==> ips");
                throw new ExcecaoApiAc("CCCDH23", "Erro de parametro ausente no controlador de configuracoes", "ips");
            }
            this.insertValueParameter("desabilitaCriptografiaCTF", root, false, true, confCTFClient, "desabilitaCriptografiaCTF", config, this.isConfigurado(root, "desabilitaCriptografiaCTF"));
            this.insertValueParameter("habilitaAtualizador", root, false, true, confCTFClient, "habilitaAtualizador", config, true);
            this.insertValueParameterSet("contingenciaConexao", new ConfContingenciaConexao(), confCTFClient, "confContingenciaConexao", root, new String[]{"maximoConexao", "tempoConexao", "resetConexao"}, new Object[3], new boolean[3], new String[]{"maximoConexao", "tempoMaximoConexao", "resetConexao"}, config, new boolean[]{true, true, true});
            ParameterSet perifericos = root.getParameterSet("perifericos");
            if (perifericos != null) {
                HashMap<String, String> parametrosPinpad;
                this.insertValueParameter("mapaTeclado", perifericos, null, true, confCTFClient, "mapaTeclado", config, true);
                this.insertValueParameterSet("DRIVER_TECLADO", new ConfPeriferico(), confCTFClient, "teclado", new ExcecaoApiAc("CCCDH55", "Erro de parametro no controlador de configuracoes", "perifericos.DRIVER_TECLADO"), perifericos, false, new String[]{"tipo", "params"}, new Object[]{null, null}, new boolean[]{Boolean.FALSE, Boolean.TRUE}, new String[]{"nomeLogico", "parametros"}, new ExcecaoApiAc[]{new ExcecaoApiAc("CCCDH24", "Erro de parametro no controlador de configuracoes", "perifericos.DRIVER_TECLADO.tipo "), null}, new boolean[2], config, new boolean[]{true, true});
                this.insertValueParameterSet("DRIVER_DISPLAY_OPERADOR", new ConfPeriferico(), confCTFClient, "displayOperador", perifericos, new String[]{"tipo", "params"}, new Object[]{null, null}, new boolean[]{Boolean.TRUE, Boolean.TRUE}, new String[]{"nomeLogico", "parametros"}, config, new boolean[]{true, true});
                this.insertValueParameterSet("DRIVER_SCANNER", new ConfPeriferico(), confCTFClient, "scanner", perifericos, new String[]{"tipo", "params"}, new Object[]{null, null}, new boolean[]{Boolean.TRUE, Boolean.TRUE}, new String[]{"nomeLogico", "parametros"}, config, new boolean[]{true, true});
                this.insertValueParameterSet("DRIVER_LEITOR_DOCUMENTO", new ConfPeriferico(), confCTFClient, "leitorDocumento", perifericos, new String[]{"tipo", "params"}, new Object[]{null, null}, new boolean[]{Boolean.TRUE, Boolean.TRUE}, new String[]{"nomeLogico", "parametros"}, config, new boolean[]{true, true});
                try {
                    ParameterSet configPinpad = perifericos.getParameterSet("CONFIG_PINPAD");
                    Parameter portaSerialParameter = configPinpad.getParameter("portaSerial");
                    boolean carregaPinpad = !portaSerialParameter.getContent().trim().equals("");
                    logger.info("Par\u00e2metro {}.portaSerial = '{}'", (Object)"CONFIG_PINPAD", (Object)portaSerialParameter.getContent());
                    if (carregaPinpad) {
                        parametrosPinpad = new HashMap();
                        parametrosPinpad.put("portaSerial", portaSerialParameter.getContent());
                        parametrosPinpad.put("msgPrompt", configPinpad.getParameter("msgPrompt").getContent());
                        parametrosPinpad.put("msgCartao", configPinpad.getParameter("msgCartao").getContent());
                        parametrosPinpad.put("msgSenha", configPinpad.getParameter("msgSenha").getContent());
                        parametrosPinpad.put("msgAguardo", configPinpad.getParameter("msgAguardo").getContent());
                        logger.info("Par\u00e2metro {}.msgPrompt = '{}'", (Object)"CONFIG_PINPAD", (Object)configPinpad.getParameter("msgPrompt").getContent());
                        logger.info("Par\u00e2metro {}.msgCartao = '{}'", (Object)"CONFIG_PINPAD", (Object)configPinpad.getParameter("msgCartao").getContent());
                        logger.info("Par\u00e2metro {}.msgSenha = '{}'", (Object)"CONFIG_PINPAD", (Object)configPinpad.getParameter("msgSenha").getContent());
                        logger.info("Par\u00e2metro {}.msgAguardo = '{}'", (Object)"CONFIG_PINPAD", (Object)configPinpad.getParameter("msgAguardo").getContent());
                        this.insertValueParameter("tentativasConexao", configPinpad, 3, true, confCTFClient, "CONFIG_PINPAD", "tentativasConexaoPinpad", null, true, config, true);
                        ConfPeriferico configLeitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
                        configLeitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
                        configLeitorCartao.setParametros(StringUtils.stripAll((String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgCartao"), (String)parametrosPinpad.get("msgPrompt")));
                        confCTFClient.setLeitorCartao(configLeitorCartao);
                        ConfPeriferico configPinPad = new ConfPeriferico("PARAMS_PINPAD");
                        configPinPad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
                        configPinPad.setParametros(ArrayUtils.toArray((String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgPrompt"), (String)parametrosPinpad.get("msgSenha"), (String)parametrosPinpad.get("msgAguardo")));
                        confCTFClient.setPinPad(configPinPad);
                    }
                }
                catch (Exception e) {
                    logger.warn("parametro 'CONFIG_PINPAD' n\u00e3o encontrado.");
                    ParameterSet leitorCartaoParameter = perifericos.getParameterSet("PARAMS_LEITOR_CARTAO");
                    parametrosPinpad = new HashMap<String, String>();
                    parametrosPinpad.put("portaSerial", leitorCartaoParameter.getParameter("portaSerial").getContent());
                    parametrosPinpad.put("msgCartao", leitorCartaoParameter.getParameter("msgCartao").getContent());
                    ParameterSet pinPadParameter = perifericos.getParameterSet("PARAMS_PINPAD");
                    parametrosPinpad.put("msgPrompt", pinPadParameter.getParameter("msgPrompt").getContent());
                    parametrosPinpad.put("msgSenha", pinPadParameter.getParameter("msgSenha").getContent());
                    parametrosPinpad.put("msgAguardo", pinPadParameter.getParameter("msgAguardo").getContent());
                    ParameterSet configPinpad = new ParameterSet("CONFIG_PINPAD");
                    Parameter portaSerialParameter = new Parameter("portaSerial");
                    portaSerialParameter.setContent((String)parametrosPinpad.get("portaSerial"));
                    configPinpad.attachParameter(portaSerialParameter);
                    logger.info("parametro perifericos:CONFIG_PINPAD:portaSerial = '" + (String)parametrosPinpad.get("portaSerial") + "'");
                    Parameter msgPromptParameter = new Parameter("msgPrompt");
                    msgPromptParameter.setContent((String)parametrosPinpad.get("msgPrompt"));
                    configPinpad.attachParameter(msgPromptParameter);
                    logger.info("parametro perifericos:CONFIG_PINPAD:msgPrompt = " + (String)parametrosPinpad.get("msgPrompt") + "'");
                    Parameter msgCartaoParameter = new Parameter("msgCartao");
                    msgCartaoParameter.setContent((String)parametrosPinpad.get("msgCartao"));
                    configPinpad.attachParameter(msgCartaoParameter);
                    logger.info("parametro perifericos:CONFIG_PINPAD:msgCartao = " + (String)parametrosPinpad.get("msgCartao") + "'");
                    Parameter msgSenhaParameter = new Parameter("msgSenha");
                    msgSenhaParameter.setContent((String)parametrosPinpad.get("msgSenha"));
                    configPinpad.attachParameter(msgSenhaParameter);
                    logger.info("parametro perifericos:CONFIG_PINPAD:msgSenha = " + (String)parametrosPinpad.get("msgSenha") + "'");
                    Parameter msgAguardoParameter = new Parameter("msgAguardo");
                    msgAguardoParameter.setContent((String)parametrosPinpad.get("msgAguardo"));
                    configPinpad.attachParameter(msgAguardoParameter);
                    logger.info("parametro perifericos:CONFIG_PINPAD:msgAguardo = " + (String)parametrosPinpad.get("msgAguardo") + "'");
                    perifericos.attachParameterSet(configPinpad);
                    logger.info("parametro 'CONFIG_PINPAD' criado com sucesso.");
                    leitorCartaoParameter.detach();
                    logger.info("parametro 'PARAMS_LEITOR_CARTAO' removido.");
                    pinPadParameter.detach();
                    logger.info("parametro 'PARAMS_PINPAD' removido.");
                    ConfPeriferico configLeitorCartao = new ConfPeriferico("PARAMS_LEITOR_CARTAO");
                    configLeitorCartao.setNomeClasse("com.csi.ctfclient.tools.devices.LeitorCartaoHandler");
                    configLeitorCartao.setParametros(StringUtils.stripAll((String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgCartao"), (String)parametrosPinpad.get("msgPrompt")));
                    confCTFClient.setLeitorCartao(configLeitorCartao);
                    ConfPeriferico configPinPad = new ConfPeriferico("PARAMS_PINPAD");
                    configPinPad.setNomeClasse("com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad");
                    configPinPad.setParametros(ArrayUtils.toArray((String)parametrosPinpad.get("portaSerial"), (String)parametrosPinpad.get("msgPrompt"), (String)parametrosPinpad.get("msgSenha"), (String)parametrosPinpad.get("msgAguardo")));
                    confCTFClient.setPinPad(configPinPad);
                }
                this.insertValueParameter("confirmadadoscancelamento", root, true, true, confCTFClient, "confirmaCancelamento", config, true);
                this.insertValueParameter("envioCupomIntegracao", root, false, true, confCTFClient, "", "envioCupomIntegracao", null, true, config, true);
                this.insertValueParameter("desabilitaDigitacao", root, false, true, confCTFClient, "", "desabilitadaDigitacao", null, true, config, true);
            }
            logger.info("Parametros Inicializados com sucesso");
        }
        catch (SecurityException e) {
            logger.fatal("", (Throwable)e);
            throw new ExcecaoApiAc("CCCDH25", "Erro de seguranca ao carregar arquivo de configuracoes", e.getMessage());
        }
        catch (ParseConfigException e) {
            logger.fatal("", (Throwable)e);
            throw new ExcecaoApiAc("CCCDH26", "Erro de parse ao carregar arquivo de configuracoes", e.getMessage());
        }
        catch (StructureConfigException e) {
            logger.fatal("", (Throwable)e);
            throw new ExcecaoApiAc("CCCDH27", "Erro de estrutura ao carregar arquivo de configuracoes", e.getMessage());
        }
        catch (NoSuchParameterException e) {
            logger.fatal("", (Throwable)e);
            throw new ExcecaoApiAc("CCCDH28", "Erro de parametro nao encontrado ao carregar arquivo de configuracoes", e.getMessage());
        }
        catch (MultipleNamesFoundException e) {
            logger.fatal("", (Throwable)e);
            throw new ExcecaoApiAc("CCCDH29", "Erro de multiplos nomes ao carregar arquivo de configuracoes", e.getMessage());
        }
        catch (FileNotFoundException e) {
            logger.fatal("", (Throwable)e);
            throw new ExcecaoApiAc("CCCDH30", "Erro de arquivo nao encontrado ao carregar arquivo de configuracoes", e.getMessage());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.fatal("", (Throwable)e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            logger.fatal("", (Throwable)e);
            throw new RuntimeException("CCCDH31", e);
        }
        this.setConfCTFClient(confCTFClient);
    }

    private void trataExcecaoParametro(String nomeAtributoParametro, ParameterSet root, ConfCTFClient confCTFClient) throws NoSuchParameterException, MultipleNamesFoundException, ExcecaoApiAc {
        switch (nomeAtributoParametro) {
            case "tipointegracao": {
                logger.warn("parametro 'tipointegracao' n\u00e3o encontrado. valor aplicado.");
                boolean multiTerminal = false;
                Parameter multiTerminalParameter = root.getParameter("multiterminal");
                if (multiTerminalParameter != null) {
                    multiTerminal = Boolean.parseBoolean(multiTerminalParameter.getContent());
                    multiTerminalParameter.detach();
                    logger.info("parametro multiterminal removido.");
                }
                Parameter translatorParameter = new Parameter("tipointegracao");
                if (multiTerminal) {
                    translatorParameter.setContent(TipoIntegracaoEnum.WEB.getId());
                    confCTFClient.setTipoIntegracaoEnum(TipoIntegracaoEnum.WEB);
                    logger.info("parametro tipointegracao = " + (Object)((Object)TipoIntegracaoEnum.WEB));
                } else {
                    translatorParameter.setContent(TipoIntegracaoEnum.DLL.getId());
                    confCTFClient.setTipoIntegracaoEnum(TipoIntegracaoEnum.DLL);
                    logger.info("parametro tipointegracao = " + (Object)((Object)TipoIntegracaoEnum.DLL));
                }
                root.attachParameter(translatorParameter);
                logger.info("parametro tipointegracao criado com sucesso");
                break;
            }
            case "versaoPathTerminal": {
                logger.info("parametro versaoPathTerminal = '0'");
                confCTFClient.setVersaoPathTerminal(0);
                if (!confCTFClient.isIntegracaoWeb() || confCTFClient.getVersaoPathTerminal() != 0) break;
                confCTFClient.setVersaoPathTerminal(1);
                logger.warn("parametro versaoPathTerminal configurado para valor = '1'. integracao web identificada.");
                break;
            }
            case "multiec": {
                if (confCTFClient.isMultiEC()) {
                    logger.error("Multi-EC habilitado e codigoGrupo nulo");
                    throw new ExcecaoApiAc("CCCDH13", "Erro de parametro no controlador de configuracoes", "Multi-EC habilitado e codigoGrupo nulo");
                }
                logger.info("parametro multiec.codigoGrupo = null");
                confCTFClient.setCodigoGrupoMultiEC(null);
            }
        }
    }

    private static Config getConfig() throws ParseConfigException, StructureConfigException, FileNotFoundException {
        String fileConfig = "configCTFClient.xml";
        if (ControladorConfCTFClient.getDiretorioTrabalho() != null) {
            return Config.getConfig(ControladorConfCTFClient.getDiretorioTrabalho() + fileConfig);
        }
        return Config.getConfig(fileConfig);
    }

    @Override
    public void resetDadosAutenticacao() {
        try {
            ParameterSet clienteServico;
            Config config = ConfCTFClientDefaultHandler.getConfig();
            ParameterSet root = config.getParameterSet("configCTFClient");
            root.getParameter("estabelecimento").setContent(null);
            root.getParameter("loja").setContent(null);
            root.getParameter("terminal").setContent(null);
            if (this.isConfigurado(root, "clienteServico") && (clienteServico = root.getParameterSet("clienteServico")) != null) {
                clienteServico.getParameter("habilitado").setContent("false");
            }
            if (this.isConfigurado(root, "ips")) {
                ParameterSet ipsParameter = root.getParameterSet("ips");
                if (ipsParameter.getAllParameterSets() != null && ipsParameter.getAllParameterSets().size() > 0) {
                    List<ParameterSet> listaIpParameter = ipsParameter.getAllParameterSets();
                    for (ParameterSet ipParameter : listaIpParameter) {
                        ipParameter.detach();
                    }
                }
                ParameterSet ipParameter = new ParameterSet("ip");
                Parameter hostParameter = new Parameter("host");
                hostParameter.setContent("");
                ipParameter.attachParameter(hostParameter);
                Parameter portParameter = new Parameter("port");
                portParameter.setContent("");
                ipParameter.attachParameter(portParameter);
                Parameter protocoloParameter = new Parameter("protocolo");
                protocoloParameter.setContent("");
                ipParameter.attachParameter(protocoloParameter);
                ipsParameter.attachParameterSet(ipParameter);
            }
            config.save();
            this.reader();
        }
        catch (Exception e) {
            logger.error("nao foi possivel resetar as configuracoes. " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void save(ConfCTFClient confCTFClient) throws ExcecaoApiAc {
        this.save(confCTFClient, !this.getConfCTFClient().isSuporteHttps());
    }

    @Override
    public void save(ConfCTFClient confCTFClient, boolean ignoreSuporteHttps) throws ExcecaoApiAc {
        try {
            ParameterSet perifericos;
            Config config = ConfCTFClientDefaultHandler.getConfig();
            ParameterSet root = config.getParameterSet("configCTFClient");
            if (ignoreSuporteHttps) {
                if (StringUtils.isNotBlank(confCTFClient.getEstabelecimento())) {
                    root.getParameter("estabelecimento").setContent(confCTFClient.getEstabelecimento());
                } else {
                    logger.error("valor de parametro invalido ==> estabelecimento");
                }
                if (StringUtils.isNotBlank(confCTFClient.getLoja())) {
                    root.getParameter("loja").setContent(confCTFClient.getLoja());
                } else {
                    logger.error("valor de parametro invalido ==> loja");
                }
            }
            if (StringUtils.isNotBlank(confCTFClient.getCnpj())) {
                Parameter cnpjParameter;
                try {
                    cnpjParameter = root.getParameter("cnpj");
                }
                catch (Exception e) {
                    cnpjParameter = new Parameter("cnpj");
                    root.attachParameter(cnpjParameter);
                }
                cnpjParameter.setContent(confCTFClient.getCnpj());
            }
            if (StringUtils.isNotBlank(confCTFClient.getTerminal()) && ignoreSuporteHttps) {
                root.getParameter("terminal").setContent(confCTFClient.getTerminal());
            }
            if (StringUtils.isNumeric(String.valueOf(confCTFClient.getNumeroSites()))) {
                root.getParameter("numeroSite").setContent(String.valueOf(confCTFClient.getNumeroSites()));
            } else if (StringUtils.isNumeric(String.valueOf(this.getConfCTFClient().getNumeroSites()))) {
                logger.warn("Par\u00e2metro 'numeroSite' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)this.getConfCTFClient().getNumeroSites());
                root.getParameter("numeroSite").setContent(String.valueOf(this.getConfCTFClient().getNumeroSites()));
            } else {
                logger.error("Erro Parametro 'numeroSite' Invalido ");
                throw new ExcecaoApiAc("CCCDH35", "Erro de parametro ao salvar arquivo de configuracoes", "numeroSites");
            }
            if (StringUtils.isNumeric(String.valueOf(confCTFClient.getQuantidadeVias()))) {
                root.getParameter("quantidadeVias").setContent(String.valueOf(confCTFClient.getQuantidadeVias()));
            } else if (StringUtils.isNumeric(String.valueOf(this.getConfCTFClient().getQuantidadeVias()))) {
                logger.warn("Par\u00e2metro 'quantidadeVias' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)this.getConfCTFClient().getQuantidadeVias());
                root.getParameter("quantidadeVias").setContent(String.valueOf(this.getConfCTFClient().getQuantidadeVias()));
            } else {
                logger.error("Erro Parametro 'quantidadeVias' Invalido ");
                throw new ExcecaoApiAc("CCCDH36", "Erro de parametro ao salvar arquivo de configuracoes", "quantidadeVias");
            }
            if (confCTFClient.isVersaoACCtrl()) {
                if (StringUtils.isNotBlank(confCTFClient.getVersaoAC())) {
                    root.getParameter("versaoAC").setContent(confCTFClient.getVersaoAC());
                } else if (StringUtils.isNotBlank(this.getConfCTFClient().getVersaoAC())) {
                    logger.warn("Par\u00e2metro 'versaoAC' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)this.getConfCTFClient().getVersaoAC());
                    root.getParameter("versaoAC").setContent(this.getConfCTFClient().getVersaoAC());
                } else {
                    logger.error("Erro Parametro 'versaoAC' Invalido ");
                    throw new ExcecaoApiAc("CCCDH37", "Erro de parametro ao salvar arquivo de configuracoes", "versaoAC");
                }
            }
            if (StringUtils.isNotBlank(confCTFClient.getHostClient())) {
                root.getParameter("hostclient").setContent(confCTFClient.getHostClient());
            } else if (StringUtils.isNotBlank(this.getConfCTFClient().getHostClient())) {
                logger.warn("Par\u00e2metro 'hostclient' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)this.getConfCTFClient().getHostClient());
                root.getParameter("hostclient").setContent(this.getConfCTFClient().getHostClient());
            }
            if (StringUtils.isNotBlank(confCTFClient.getPortClient())) {
                root.getParameter("portclient").setContent(confCTFClient.getPortClient());
            } else if (StringUtils.isNotBlank(this.getConfCTFClient().getPortClient())) {
                logger.warn("Par\u00e2metro 'portclient' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)this.getConfCTFClient().getPortClient());
                root.getParameter("portclient").setContent(this.getConfCTFClient().getPortClient());
            } else {
                logger.error("Erro Parametro 'portclient' Invalido ");
                throw new ExcecaoApiAc("CCCDH38", "Erro de parametro ao salvar arquivo de configuracoes", "portclient");
            }
            if (confCTFClient.isStandAlone() || this.getConfCTFClient().isStandAlone()) {
                root.getParameter("standalone").setContent(Boolean.TRUE.toString());
            } else {
                root.getParameter("standalone").setContent(Boolean.FALSE.toString());
            }
            if (StringUtils.isNotBlank(confCTFClient.getTipoIntegracao())) {
                root.getParameter("tipointegracao").setContent(String.valueOf(confCTFClient.getTipoIntegracao()));
            } else if (StringUtils.isNotBlank(this.getConfCTFClient().getTipoIntegracao())) {
                logger.warn("Par\u00e2metro 'tipointegracao' n\u00e3o encontrado ou inv\u00e1lido. Valor '{}' aplicado.", (Object)this.getConfCTFClient().getTipoIntegracao());
                root.getParameter("tipointegracao").setContent(String.valueOf(this.getConfCTFClient().getTipoIntegracao()));
            }
            root.getParameter("permitePagarSaldoVoucher").setContent(String.valueOf(confCTFClient.isPermitePagarSaldoVoucher()));
            root.getParameter("rotearPrivateLabel").setContent(String.valueOf(confCTFClient.isRotearPrivateLabel()));
            root.getParameter("integracaoCriptografada").setContent(String.valueOf(confCTFClient.isIntegracaoCriptografada()));
            root.getParameter("capturacmc7").setContent(String.valueOf(confCTFClient.isCapturaCmc7()));
            root.getParameter("pingUDP").setContent(String.valueOf(confCTFClient.isPingUDP()));
            ParameterSet timeOut = root.getParameterSet("timeout");
            if (confCTFClient.getTimeOutDefault() == 0) {
                timeOut.getParameter("intertef").setContent("15");
            } else {
                timeOut.getParameter("intertef").setContent(String.valueOf(confCTFClient.getTimeOutDefault()));
            }
            if (confCTFClient.getTimeOutConfirmacao() == 0) {
                timeOut.getParameter("confirmacaoMultiTerminal").setContent("120");
            } else {
                try {
                    timeOut.getParameter("confirmacaoMultiTerminal").setContent(String.valueOf(confCTFClient.getTimeOutConfirmacao()));
                }
                catch (Exception e) {
                    logger.warn("n\u00e3o foi poss\u00edvel atualizar o timeout confirmacaoMultiTerminal.");
                }
            }
            if (confCTFClient.getVersaoPathTerminal() > 0) {
                Parameter versaoPathTerminalParameter;
                try {
                    versaoPathTerminalParameter = root.getParameter("versaoPathTerminal");
                }
                catch (Exception e) {
                    versaoPathTerminalParameter = new Parameter("versaoPathTerminal");
                    root.attachParameter(versaoPathTerminalParameter);
                }
                versaoPathTerminalParameter.setContent(String.valueOf(confCTFClient.getVersaoPathTerminal()));
            }
            try {
                ConfPOSTef confPOSTef = confCTFClient.getConfPOSTef();
                ParameterSet postef = root.getParameterSet("postef");
                if (postef != null) {
                    postef.getParameter("habilitado").setContent(String.valueOf(confPOSTef.isHabilitado()));
                    postef.getParameter("posMovel").setContent(confPOSTef.getTerminalPosMovel());
                }
            }
            catch (Exception e) {
                logger.error("parametro 'postef' nao configurado.");
            }
            try {
                ConfClienteServico confClienteServico = confCTFClient.getConfClienteServico();
                ParameterSet clienteServico = root.getParameterSet("clienteServico");
                if (clienteServico != null) {
                    clienteServico.getParameter("habilitado").setContent(String.valueOf(confClienteServico.isHabilitado()));
                    clienteServico.getParameter("codigoPdv").setContent(confClienteServico.getCodigoPdv());
                }
            }
            catch (Exception e) {
                logger.error("parametro 'clienteServico' nao configurado.");
            }
            if (ignoreSuporteHttps) {
                if (confCTFClient.getIps() != null && confCTFClient.getIps().size() > 0) {
                    ParameterSet ipsParameter = root.getParameterSet("ips");
                    if (ipsParameter.getAllParameterSets() != null && ipsParameter.getAllParameterSets().size() > 0) {
                        List<ParameterSet> listaIpParameter = ipsParameter.getAllParameterSets();
                        for (ParameterSet parameterSet : listaIpParameter) {
                            parameterSet.detach();
                        }
                    }
                    LinkedHashSet<ServicoCTF> ipsServicoCTF = new LinkedHashSet<ServicoCTF>();
                    for (Object obj : confCTFClient.getIps()) {
                        ServicoCTF servicoCTF = obj instanceof ServicoCTF ? (ServicoCTF)obj : new ServicoCTF((Servico)obj);
                        ParameterSet ipParameter = new ParameterSet("ip");
                        if (servicoCTF.getHost() == null || servicoCTF.getHost().getEndereco() == null || servicoCTF.getHost().getEndereco().isEmpty()) {
                            logger.error("valor de parametro invalido ==> ips = host");
                            throw new ExcecaoApiAc("CCCDH41", "Erro de parametro ao salvar arquivo de configuracoes", "ips = host");
                        }
                        Parameter hostParameter = new Parameter("host");
                        hostParameter.setContent(servicoCTF.getHost().getEndereco());
                        ipParameter.attachParameter(hostParameter);
                        if (servicoCTF.getIdentificadorServico() == null || servicoCTF.getIdentificadorServico().equals("")) {
                            logger.error("valor de parametro invalido ==> ips = port");
                            throw new ExcecaoApiAc("CCCDH42", "Erro de parametro ao salvar arquivo de configuracoes", "ips = port");
                        }
                        Parameter portParameter = new Parameter("port");
                        portParameter.setContent(servicoCTF.getIdentificadorServico());
                        ipParameter.attachParameter(portParameter);
                        if (servicoCTF.getProtocolo() == null || servicoCTF.getProtocolo().equals("")) {
                            logger.error("valor de parametro invalido ==> ips = protocolo");
                            throw new ExcecaoApiAc("CCCDH43", "Erro de parametro ao salvar arquivo de configuracoes", "ips = protocolo");
                        }
                        Parameter protocoloParameter = new Parameter("protocolo");
                        protocoloParameter.setContent(servicoCTF.getProtocolo());
                        ipParameter.attachParameter(protocoloParameter);
                        ipsParameter.attachParameterSet(ipParameter);
                        ipsServicoCTF.add(servicoCTF);
                    }
                    confCTFClient.setIps(ipsServicoCTF);
                } else {
                    logger.error("lista de ips n\u00e3o configurada ==> ips");
                    throw new ExcecaoApiAc("CCCDH44", "Erro de parametro ao salvar arquivo de configuracoes", "ips");
                }
            }
            if (Objects.nonNull(confCTFClient.getConfContingenciaConexao())) {
                Parameter resetConexao;
                Parameter tempoConexao;
                Parameter maximoConexao;
                ParameterSet contingenciaConexao;
                ConfContingenciaConexao confContingenciaConexao = confCTFClient.getConfContingenciaConexao();
                int valorVazio = -1;
                if (this.isConfigurado(root, "contingenciaConexao")) {
                    contingenciaConexao = root.getParameterSet("contingenciaConexao");
                } else {
                    contingenciaConexao = new ParameterSet("contingenciaConexao");
                    root.attachParameterSet(contingenciaConexao);
                }
                if (this.isConfigurado(contingenciaConexao, "maximoConexao")) {
                    maximoConexao = contingenciaConexao.getParameter("maximoConexao");
                } else {
                    maximoConexao = new Parameter("maximoConexao");
                    maximoConexao.setContent("1");
                    contingenciaConexao.attachParameter(maximoConexao);
                }
                if (this.isConfigurado(contingenciaConexao, "tempoConexao")) {
                    tempoConexao = contingenciaConexao.getParameter("tempoConexao");
                } else {
                    tempoConexao = new Parameter("tempoConexao");
                    tempoConexao.setContent("0");
                    contingenciaConexao.attachParameter(tempoConexao);
                }
                if (this.isConfigurado(contingenciaConexao, "resetConexao")) {
                    resetConexao = contingenciaConexao.getParameter("resetConexao");
                } else {
                    resetConexao = new Parameter("resetConexao");
                    resetConexao.setContent("0");
                    contingenciaConexao.attachParameter(resetConexao);
                }
                if (confContingenciaConexao != null) {
                    if (confContingenciaConexao.getMaximoConexao() != valorVazio) {
                        maximoConexao.setContent(confContingenciaConexao.getMaximoConexao() + "");
                    }
                    if (confContingenciaConexao.getTempoMaximoConexao() != valorVazio) {
                        tempoConexao.setContent(confContingenciaConexao.getTempoMaximoConexao() + "");
                    }
                    if (confContingenciaConexao.getResetConexao() != valorVazio) {
                        resetConexao.setContent(confContingenciaConexao.getResetConexao() + "");
                    }
                } else {
                    maximoConexao.setContent("1");
                    tempoConexao.setContent("0");
                    resetConexao.setContent("0");
                }
            }
            if ((perifericos = root.getParameterSet("perifericos")) != null) {
                if (Objects.nonNull(confCTFClient.getMapaTeclado())) {
                    Parameter mapaTeclado;
                    try {
                        mapaTeclado = perifericos.getParameter("mapaTeclado");
                    }
                    catch (Exception e) {
                        mapaTeclado = new Parameter("mapaTeclado");
                        perifericos.attachParameter(mapaTeclado);
                    }
                    mapaTeclado.setContent(confCTFClient.getMapaTeclado());
                }
                if (Objects.nonNull(confCTFClient.getTeclado())) {
                    ParameterSet perifericoTeclado = perifericos.getParameterSet("DRIVER_TECLADO");
                    ConfPeriferico teclado = confCTFClient.getTeclado();
                    if ("TECLADO_PC".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_PC");
                    } else if ("TECLADO_JAVAPOS".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_JAVAPOS");
                    } else if ("TECLADO_TOUCH_LINX".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_TOUCH_LINX");
                    } else if ("TECLADO_TOUCH".equalsIgnoreCase(teclado.getNomeLogico())) {
                        perifericoTeclado.getParameter("tipo").setContent("TECLADO_TOUCH");
                    } else {
                        logger.error("valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("CCCDH45", "Erro de parametro ao salvar arquivo de configuracoes", "periferico - class");
                    }
                    if (teclado.getParametros() != null && teclado.getParametros().length > 0) {
                        perifericoTeclado.getParameter("params").setContent(StringUtil.toString(teclado.getParametros()));
                    } else {
                        perifericoTeclado.getParameter("params").setContent(null);
                    }
                }
                if (Objects.nonNull(confCTFClient.getDisplayOperador())) {
                    ParameterSet perifericoDisplayOperador = perifericos.getParameterSet("DRIVER_DISPLAY_OPERADOR");
                    ConfPeriferico displayOperador = confCTFClient.getDisplayOperador();
                    if (!("DISPLAY_CTFCLIENT".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_JAVAPOS".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_AUTTAR".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_CSI".equalsIgnoreCase(displayOperador.getNomeLogico()) || "DISPLAY_OPERADOR".equalsIgnoreCase(displayOperador.getNomeLogico()))) {
                        logger.error("valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("CCCDH46", "Erro de parametro ao salvar arquivo de configuracoes", "driver display operador");
                    }
                    perifericoDisplayOperador.getParameter("tipo").setContent(displayOperador.getNomeLogico());
                    if (displayOperador.getParametros() != null && displayOperador.getParametros().length > 0) {
                        perifericoDisplayOperador.getParameter("params").setContent(StringUtil.toString(displayOperador.getParametros()));
                    } else {
                        perifericoDisplayOperador.getParameter("params").setContent(null);
                    }
                }
                if (Objects.nonNull(confCTFClient.getScanner())) {
                    ParameterSet perifericoScanner = perifericos.getParameterSet("DRIVER_SCANNER");
                    ConfPeriferico scanner = confCTFClient.getScanner();
                    if (!"SCANNER_SERIAL".equalsIgnoreCase(scanner.getNomeLogico()) && !"SCANNER_JAVAPOS".equalsIgnoreCase(scanner.getNomeLogico())) {
                        logger.error("valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("CCCDH47", "Erro de parametro ao salvar arquivo de configuracoes", "driver scanner");
                    }
                    perifericoScanner.getParameter("tipo").setContent(scanner.getNomeLogico());
                    if (scanner.getParametros() != null && scanner.getParametros().length > 0) {
                        perifericoScanner.getParameter("params").setContent(StringUtil.toString(scanner.getParametros()));
                    } else {
                        perifericoScanner.getParameter("params").setContent(null);
                    }
                }
                if (Objects.nonNull(confCTFClient.getLeitorDocumento())) {
                    ParameterSet perifericoLeitorDocumento = perifericos.getParameterSet("DRIVER_LEITOR_DOCUMENTO");
                    ConfPeriferico leitorDocumento = confCTFClient.getLeitorDocumento();
                    if (!("LEITOR_DOCUMENTO_CHRONOS".equalsIgnoreCase(leitorDocumento.getNomeLogico()) || "LEITOR_DOCUMENTO_LOGGER2".equalsIgnoreCase(leitorDocumento.getNomeLogico()) || "LEITOR_DOCUMENTO_TECPOINTTL840".equalsIgnoreCase(leitorDocumento.getNomeLogico()))) {
                        logger.error("valor de parametro invalido ==> periferico - class");
                        throw new ExcecaoApiAc("CCCDH48", "Erro de parametro ao salvar arquivo de configuracoes", "driver leitor documentos");
                    }
                    perifericoLeitorDocumento.getParameter("tipo").setContent(leitorDocumento.getNomeLogico());
                    if (leitorDocumento.getParametros() != null && leitorDocumento.getParametros().length > 0) {
                        perifericoLeitorDocumento.getParameter("params").setContent(StringUtil.toString(leitorDocumento.getParametros()));
                    } else {
                        perifericoLeitorDocumento.getParameter("params").setContent(null);
                    }
                }
                if (Objects.nonNull(confCTFClient.getLeitorCartao()) && Objects.nonNull(confCTFClient.getPinPad())) {
                    ConfPeriferico configLeitorCartao = confCTFClient.getLeitorCartao();
                    ConfPeriferico configPinPad = confCTFClient.getPinPad();
                    if (configLeitorCartao.getParametros() != null && configLeitorCartao.getParametros().length > 0 && configPinPad.getParametros() != null && configPinPad.getParametros().length > 0) {
                        ParameterSet configPinpadParameter = perifericos.getParameterSet("CONFIG_PINPAD");
                        configPinpadParameter.getParameter("portaSerial").setContent(configLeitorCartao.getParametros()[0]);
                        configPinpadParameter.getParameter("msgPrompt").setContent(configLeitorCartao.getParametros()[2]);
                        configPinpadParameter.getParameter("msgCartao").setContent(configLeitorCartao.getParametros()[1]);
                        configPinpadParameter.getParameter("msgSenha").setContent(configPinPad.getParametros()[2]);
                        configPinpadParameter.getParameter("msgAguardo").setContent(configPinPad.getParametros()[3]);
                    }
                }
                if (confCTFClient.isTentativasConexaoPinpadCtrl()) {
                    ParameterSet configPinpadParameter = perifericos.getParameterSet("CONFIG_PINPAD");
                    configPinpadParameter.getParameter("tentativasConexao").setContent(confCTFClient.getTentativasConexaoPinpad() + "");
                }
                if (Objects.nonNull(confCTFClient.getTimeoutPin())) {
                    ParameterSet timeoutPin = root.getParameterSet("timeoutPin");
                    if (timeoutPin == null) {
                        logger.error("parametro n\u00e3o encontrado ==> timeoutPin");
                    } else {
                        ConfTimeoutPin confTimeoutPin = confCTFClient.getTimeoutPin();
                        timeoutPin.getParameter("default").setContent(String.valueOf(confTimeoutPin.getTimeoutDefault()));
                        timeoutPin.getParameter("blocking").setContent(String.valueOf(confTimeoutPin.getTimeoutBlocking()));
                        timeoutPin.getParameter("noblocking").setContent(String.valueOf(confTimeoutPin.getTimeoutNoblocking()));
                        timeoutPin.getParameter("standard").setContent(String.valueOf(confTimeoutPin.getTimeoutStandard()));
                    }
                }
                root.getParameter("integracaoCriptografada").setContent(String.valueOf(confCTFClient.isIntegracaoCriptografada()));
            }
            root.getParameter("envioCupomIntegracao").setContent(String.valueOf(confCTFClient.isEnvioCupomIntegracao()));
            config.save();
            this.reader();
            logger.info("Finalizando atualiza\u00e7\u00e3o do arquivo de configura\u00e7\u00f5es...");
        }
        catch (SecurityException e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoApiAc("CCCDH49", "Erro de seguranca ao salvar arquivo de configuracoes", e.getMessage());
        }
        catch (ParseConfigException e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoApiAc("CCCDH50", "Erro de parse ao salvar arquivo de configuracoes", e.getMessage());
        }
        catch (StructureConfigException e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoApiAc("CCCDH51", "Erro de estrutura ao salvar arquivo de configuracoes", e.getMessage());
        }
        catch (NoSuchParameterException e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoApiAc("CCCDH52", "Erro de parametro nao encontrado ao salvar arquivo de configuracoes", e.getMessage());
        }
        catch (MultipleNamesFoundException e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoApiAc("CCCDH53", "Erro de multiplos nomes ao salvar arquivo de configuracoes", e.getMessage());
        }
        catch (IOException e) {
            logger.fatal(e.getMessage());
            throw new ExcecaoApiAc("CCCDH54", "Erro de IO ao salvar arquivo de configuracoes", e.getMessage());
        }
    }

    private boolean isConfigurado(ParameterSet parametro, String nome) {
        try {
            parametro.getParameter(nome);
            return true;
        }
        catch (Exception exception) {
            try {
                parametro.getParameters(nome);
                return true;
            }
            catch (Exception exception2) {
                try {
                    parametro.getParameterSet(nome);
                    return true;
                }
                catch (Exception exception3) {
                    try {
                        parametro.getParameterSets(nome);
                        return true;
                    }
                    catch (Exception exception4) {
                        return false;
                    }
                }
            }
        }
    }
}

