/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.autenticacao;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.autenticacao.DadosAutenticacao;
import com.csi.ctfclient.integracao.GeneralConfigException;
import com.csi.ctfclient.integracao.GeneralConfigHandler;
import com.csi.ctfclient.integracao.GeneralConfigKeys;
import com.csi.ctfclient.servicos.CTFClientCore;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.KeyStoreUtil;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class AutenticacaoUtil {
    private static String pwAutKey;
    private static final AuttarLogger logger;
    private static AutenticacaoUtil autenticacaoUtil;
    private final String keyStoreAlias = "key-aut-token";
    private final String CONFIG_TOKEN = "key-aut-token";
    private final String CONFIG_DADOS = "key-aut-dados";
    private Properties properties;
    private KeyStore keyStore;
    private final String FILE_PROPERTIES = "config.properties";

    private static String getPwAutKey() throws GeneralConfigException {
        if (pwAutKey == null) {
            pwAutKey = GeneralConfigHandler.getInstance().getValue(GeneralConfigKeys.PW_AUT_KEY.name());
        }
        return pwAutKey;
    }

    private AutenticacaoUtil() {
        this.init();
    }

    public static AutenticacaoUtil getInstance() {
        if (autenticacaoUtil == null) {
            autenticacaoUtil = new AutenticacaoUtil();
        }
        return autenticacaoUtil;
    }

    public static String getIdentificao() {
        String mac = null;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            mac = ip.getHostName();
        }
        catch (UnknownHostException e) {
            logger.error("Nao foi possivel recuperar a identificacao da estacao: " + e.getMessage());
        }
        return mac;
    }

    private SecretKey createSecretKey() throws Exception {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            KeyStore.SecretKeyEntry keyStoreEntry = new KeyStore.SecretKeyEntry(skey);
            KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(AutenticacaoUtil.getPwAutKey().toCharArray());
            this.getKeyStory().setEntry(this.getKeyStoreAlias(), keyStoreEntry, keyPassword);
            KeyStoreUtil.store(this.getKeyStory());
            return skey;
        }
        catch (KeyStoreException e) {
            logger.error("Erro de deposito de chaves na criacao de chave secreta: " + e.getMessage());
            throw new Exception(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Erro de algoritmo na criacao de chave secreta: " + e.getMessage());
            throw new Exception(e);
        }
    }

    private SecretKey getSecretKey() throws Exception {
        try {
            KeyStore.PasswordProtection keyPassword = new KeyStore.PasswordProtection(AutenticacaoUtil.getPwAutKey().toCharArray());
            KeyStore.Entry entry = this.getKeyStory().getEntry(this.getKeyStoreAlias(), keyPassword);
            return ((KeyStore.SecretKeyEntry)entry).getSecretKey();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Erro de algoritmo na leitura de chave secreta: " + e.getMessage());
            throw new Exception(e);
        }
        catch (UnrecoverableEntryException e) {
            logger.error("Erro de indice de entrada na leitura de chave secreta: " + e.getMessage());
            throw new Exception(e);
        }
        catch (KeyStoreException e) {
            logger.error("Erro de deposito de chaves na leitura da chave secreta: " + e.getMessage());
            throw new Exception(e);
        }
        catch (GeneralConfigException e) {
            logger.error("Erro na recupera\u00e7\u00e3o das configura\u00e7\u00f5es gerais: " + e.getMessage());
            throw new Exception(e);
        }
    }

    private void init() {
        this.keyStore = KeyStoreUtil.getDefaultKeyStory();
        this.properties = new Properties();
        if (new File("config.properties").exists()) {
            try {
                this.properties.load(new FileInputStream("config.properties"));
            }
            catch (FileNotFoundException e) {
                logger.error(String.format("Nao foi possivel abrir o arquivo '%s': %s", "config.properties", e.getMessage()));
            }
            catch (IOException e) {
                logger.error(String.format("Nao foi possivel ler o arquivo '%s': %s", "config.properties", e.getMessage()));
            }
        }
    }

    private KeyStore getKeyStory() {
        return this.keyStore;
    }

    private String getKeyStoreAlias() {
        return "key-aut-token";
    }

    private void deleteConfiguracoes() throws Exception {
        try {
            this.keyStore.deleteEntry("key-aut-token");
            if (this.properties != null) {
                this.properties.remove("key-aut-dados");
                this.properties.remove("key-aut-token");
            }
        }
        catch (KeyStoreException e) {
            throw new Exception("nao foi possivel remover alias de autenticacao.", e);
        }
    }

    public void clean() throws Exception {
        this.deleteConfiguracoes();
        File file = new File("config.properties");
        if (file.exists()) {
            file.delete();
        }
    }

    private String getConfig(String name) throws Exception {
        if (!this.properties.containsKey(name)) {
            return null;
        }
        try {
            SecretKey secretKey = this.getSecretKey();
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, secretKey);
            byte[] cipheredText = cipher.doFinal(ByteUtil.hexToByteArray(this.properties.getProperty(name)));
            return new String(cipheredText);
        }
        catch (Exception e) {
            logger.error("Erro ao recuperar configuracao: " + e.getMessage());
            throw e;
        }
    }

    private void config(String name, String value) throws Exception {
        try {
            SecretKey secretKey = this.getSecretKey();
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] cipheredText = cipher.doFinal(value.getBytes());
            this.properties.setProperty(name, ByteUtil.byteArrayToHex(cipheredText));
        }
        catch (Exception e) {
            logger.error("Erro no processamento da configuracao: " + e.getMessage());
            throw e;
        }
    }

    private boolean saveConfig() {
        try {
            FileOutputStream os = new FileOutputStream("config.properties");
            this.properties.store(os, "autenticacao");
            os.close();
            this.init();
        }
        catch (Exception e) {
            logger.error("Erro no salvamento de configuracoes: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isTokenAutorizacao() throws Exception {
        return this.keyStore.containsAlias("key-aut-token") && this.properties != null && this.properties.containsKey("key-aut-token");
    }

    public String getTokenAutorizacao() throws Exception {
        if (this.isTokenAutorizacao()) {
            return this.getConfig("key-aut-token");
        }
        return null;
    }

    public boolean isDadosAutenticacao() throws Exception {
        return this.keyStore.containsAlias("key-aut-token") && this.properties != null && this.properties.containsKey("key-aut-dados");
    }

    public DadosAutenticacao getDadosAutenticacao() throws Exception {
        String json;
        if (this.isDadosAutenticacao() && (json = this.getConfig("key-aut-dados")) != null) {
            Gson gson = new Gson();
            return gson.fromJson(json, DadosAutenticacao.class);
        }
        return null;
    }

    public void configDadosAutenticacao(DadosAutenticacao dadosAutenticacao) throws Exception {
        this.createSecretKey();
        Gson gson = new Gson();
        String json = gson.toJson(dadosAutenticacao);
        this.config("key-aut-dados", json);
        this.config("key-aut-token", dadosAutenticacao.getToken());
        this.saveConfig();
    }

    static {
        logger = CTFClientCore.getAuttarLoggerFactory().getLogger(CTFClientCore.class);
        autenticacaoUtil = null;
    }
}

