/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.apitef;

import br.com.auttar.AuttarLogger;
import com.csi.ctfclient.apitef.annotation.FormatoBigDecimal;
import com.csi.ctfclient.apitef.annotation.FormatoData;
import com.csi.ctfclient.apitef.annotation.SubCampo;
import com.csi.ctfclient.apitef.annotation.Tipo;
import com.csi.ctfclient.apitef.model.EnumWithValue;
import com.csi.ctfclient.servicos.CTFClientCore;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ApitefStringUtil {
    private static final DecimalFormat FORMAT_4_ZEROS = new DecimalFormat("0000");
    private static final int SIZEOF_LENGTH = 4;
    private AuttarLogger logger = CTFClientCore.getAuttarLoggerFactory().getLogger(ApitefStringUtil.class);

    public static List<String> stringApiTefToList(String subfieldData) {
        int lenght;
        ArrayList<String> ret = new ArrayList<String>();
        for (int index = 0; index < subfieldData.length(); index += 4 + lenght) {
            lenght = Integer.parseInt(subfieldData.substring(index, index + 4));
            ret.add(subfieldData.substring(index + 4, index + 4 + lenght));
        }
        return ret;
    }

    public String completaString(String texto, int tamanho, char complemento, boolean esquerda) {
        while (texto.length() < tamanho) {
            if (esquerda) {
                texto = complemento + texto;
                continue;
            }
            texto = texto + complemento;
        }
        return texto;
    }

    public String formataSubCampo(SubCampo subCampo, Field field, Object obj) throws IllegalAccessException {
        String strSucampo = null;
        Object valorObj = field.get(obj);
        if (subCampo.tipo() == Tipo.INTEIRO) {
            if (field.getType().equals(Integer.TYPE) || field.getType().equals(Long.TYPE)) {
                try {
                    long valor = field.getLong(obj);
                    if (valor != -1L) {
                        String tam = valor + "";
                        String strValor = this.completaString(valor + "", subCampo.tamanho(), '0', true);
                        tam = this.completaString(strValor.length() + "", 4, '0', true);
                        strSucampo = subCampo.codigo() + tam + strValor;
                    }
                }
                catch (Exception e) {
                    this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                }
            } else if (field.getType().equals(Integer.class) || field.getType().equals(Long.class)) {
                try {
                    Object valor = field.get(obj);
                    if (valor != null) {
                        String tam = valor + "";
                        String strValor = this.completaString(valor + "", subCampo.tamanho(), '0', true);
                        tam = this.completaString(strValor.length() + "", 4, '0', true);
                        strSucampo = subCampo.codigo() + tam + strValor;
                    }
                }
                catch (Exception e) {
                    this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
                }
            }
        } else if (subCampo.tipo() == Tipo.ALFANUMERICO) {
            try {
                String valor;
                if (valorObj != null && ((valor = (String)valorObj).trim().length() != 0 || subCampo.permiteBranco())) {
                    if (subCampo.completa()) {
                        valor = this.completaString(valor, subCampo.tamanho(), ' ', false);
                    }
                    String tam = this.completaString(valor.length() + "", 4, '0', true);
                    strSucampo = subCampo.codigo() + tam + valor;
                }
            }
            catch (Exception e) {
                this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
            }
        } else if (subCampo.tipo() == Tipo.DATA) {
            try {
                if (valorObj != null && field.isAnnotationPresent(FormatoData.class)) {
                    FormatoData formatoData = field.getAnnotation(FormatoData.class);
                    Date date = (Date)valorObj;
                    SimpleDateFormat dateFormat = new SimpleDateFormat(formatoData.valor());
                    String tam = this.completaString(formatoData.valor().length() + "", 4, '0', true);
                    strSucampo = subCampo.codigo() + tam + dateFormat.format(date);
                }
            }
            catch (Exception e) {
                this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
            }
        } else if (subCampo.tipo() == Tipo.MONETARIO) {
            try {
                if (valorObj != null) {
                    int casasDecimais = 2;
                    if (field.isAnnotationPresent(FormatoBigDecimal.class)) {
                        FormatoBigDecimal formatoBigDecimal = field.getAnnotation(FormatoBigDecimal.class);
                        casasDecimais = formatoBigDecimal.casasDecimais();
                    }
                    BigDecimal valor = (BigDecimal)valorObj;
                    valor = valor.movePointRight(casasDecimais);
                    String strValor = valor.toString();
                    strValor = this.completaString(strValor, subCampo.tamanho(), '0', true);
                    String tam = this.completaString(strValor.length() + "", 4, '0', true);
                    strSucampo = subCampo.codigo() + tam + strValor;
                }
            }
            catch (Exception e) {
                this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
            }
        } else if (subCampo.tipo() == Tipo.BOOLEANO) {
            try {
                if (field.getType().equals(Boolean.TYPE)) {
                    boolean valor = field.getBoolean(obj);
                    strSucampo = subCampo.codigo() + "0001" + (valor ? "1" : "0");
                } else if (field.getType().equals(Boolean.class) && valorObj != null) {
                    boolean valor = (Boolean)valorObj;
                    strSucampo = subCampo.codigo() + "0001" + (valor ? "1" : "0");
                }
            }
            catch (Exception e) {
                this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
            }
        } else if (subCampo.tipo() == Tipo.ENUM) {
            try {
                if (valorObj instanceof EnumWithValue) {
                    EnumWithValue enumValue = (EnumWithValue)valorObj;
                    String strValor = enumValue.getValue().toString();
                    String tam = this.completaString(strValor.length() + "", 4, '0', true);
                    strSucampo = subCampo.codigo() + tam + strValor;
                }
            }
            catch (Exception e) {
                this.logger.debug("subcampo: " + subCampo.codigo() + " -> erro de formatacao.");
            }
        }
        if (strSucampo != null) {
            this.logger.debug("Subcampo: " + subCampo.codigo() + " -> OK = " + (subCampo.canPrint() ? strSucampo.substring(8) : "[omitido]"));
        }
        return strSucampo;
    }

    public String arrayParaStringApitef(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (String item : array) {
            sb.append(FORMAT_4_ZEROS.format(item.length()));
            sb.append(item);
        }
        return sb.toString();
    }
}

